
--SQL Script automatisch generiert von SuperX sx_fields_fuellen.xsl


--freemarker template

<sqlvars>
<sqlvar name="sx_fields_exists">
select sp_table_exists('sx_fields') from xdummy;

</sqlvar>

</sqlvars>
<#if sx_fields_exists=1>


CREATE temp TABLE tmp_fields(
tid serial NOT NULL,
table_name VARCHAR(255)  not null, 
name VARCHAR(255)  not null, 
caption VARCHAR(255) , 
description VARCHAR(255) , 
field_type VARCHAR(255)  not null, 
field_size VARCHAR(255)  , 
field_not_null smallint,
currentlyused SMALLINT , 
is_primarykey SMALLINT  default 0 , 
foreignkey_tab VARCHAR(255) , 
foreignkey_col VARCHAR(255) , 
foreignkey_int VARCHAR(255) , 
foreignkey_cap VARCHAR(255) , 
foreignkey_cond VARCHAR(255) , 
foreignkey_func VARCHAR(255) , 
check_integrity SMALLINT, 
is_sum SMALLINT  default 0,
foreignkey_uniquename VARCHAR(255)

);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_abint',
'hs_nr',
'Hochschulnummer',
'',
'INTEGER',
'4',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_abint',
'apnr',
'Fach (intern)',
'Schlssel Fach',
'CHAR',
'10',
1,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_abint',
'druck',
'Fachbezeichnung',
'Drucktext',
'VARCHAR',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_abint',
'astat',
'Fach (amtlich) ',
'Amtlicher Schlssel',
'CHAR',
'10',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_abint',
'datum',
'Datum der Erzeugung',
'Dieses Feld wird zur Archivierung von gelieferten Daten genutzt',
'date',
'4',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_abschl_pruef_grp',
'astat',
'Amtlicher Schlssel Abschluss',
'',
'CHAR',
'10',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_abschl_astat',
foreignkey_col='astat',
foreignkey_cap='dtxt',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_abschl_pruef_grp_astat';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_abschl_pruef_grp',
'pruef_grp',
'Prfungsgruppe Schlssel',
'',
'CHAR',
'10',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_cifx',
foreignkey_col='apnr',
foreignkey_cap='druck',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_abschl_pruef_grp_pruef_grp';

update tmp_fields set foreignkey_cond='687=kenn_cifx.key'
where trim(table_name) || '_' || trim(name) ='kenn_abschl_pruef_grp_pruef_grp'
and trim(foreignkey_tab) = 'kenn_cifx';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_abschl_sbereich',
'tid',
'tid',
'',
'SERIAL',
'4',
1,
1,
0,
0);

update tmp_fields set is_primarykey=1 
where trim(table_name) || '_' || trim(name) ='kenn_abschl_sbereich_tid';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_abschl_sbereich',
'abschluss',
'Abschluss (intern)',
'',
'CHAR',
'10',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_abint',
foreignkey_col='apnr',
foreignkey_cap='druck',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_abschl_sbereich_abschluss';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_abschl_sbereich',
'sbereich',
'Abschlussgruppe',
'',
'VARCHAR',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_absolv_aggr_astat',
'hs_nr',
'Hochschule',
'Hochschulnummer',
'INTEGER',
'4',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_hochschulen',
foreignkey_col='hs_nr',
foreignkey_cap='name',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_absolv_aggr_astat_hs_nr';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_absolv_aggr_astat',
'fach_nr',
'Fach-Nummer',
'z.B. 2 fr 2. Fach',
'SMALLINT',
'2',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_absolv_aggr_astat',
'geschlecht',
'Geschlecht',
' (1=nicht-weiblich,2= weibl.)',
'CHAR',
'10',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_cifx',
foreignkey_col='apnr',
foreignkey_cap='druck',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_absolv_aggr_astat_geschlecht';

update tmp_fields set foreignkey_cond='693=kenn_cifx.key'
where trim(table_name) || '_' || trim(name) ='kenn_absolv_aggr_astat_geschlecht'
and trim(foreignkey_tab) = 'kenn_cifx';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_absolv_aggr_astat',
'bildungstyp',
'Bildungstyp',
'BI=Deutsche/Bildungsinlnder ,BA_EWR=Bildungsaul. EWR, BA_EU=Bildungsauslnder EU, BA_N_EU Bildungsauslnder nicht-EU/EWR ',
'CHAR',
'10',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_cifx',
foreignkey_col='apnr',
foreignkey_cap='druck',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_absolv_aggr_astat_bildungstyp';

update tmp_fields set foreignkey_cond='691=kenn_cifx.key'
where trim(table_name) || '_' || trim(name) ='kenn_absolv_aggr_astat_bildungstyp'
and trim(foreignkey_tab) = 'kenn_cifx';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_absolv_aggr_astat',
'sem_der_pruefung',
'Semester',
'Schlssel, siehe Tab. kenn_semester',
'SMALLINT',
'2',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_semester',
foreignkey_col='tid',
foreignkey_cap='druck',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_absolv_aggr_astat_sem_der_pruefung';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_absolv_aggr_astat',
'stg',
'Fach (amtlich)',
'',
'CHAR',
'4',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_stg_astat',
foreignkey_col='astat',
foreignkey_cap='dtxt',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_absolv_aggr_astat_stg';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_absolv_aggr_astat',
'stg_land',
'Fach Land (amtlich)',
'',
'CHAR',
'4',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='k_astat_studienfach_land_l',
foreignkey_col='schluessel',
foreignkey_cap='name',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_absolv_aggr_astat_stg_land';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_absolv_aggr_astat',
'abschlusstyp',
'Abschlusstyp',
'Gruppierung BaWue 2024: BA, BA LA, MA, MA LA, StaEx, Magister/Diplom/Kirchliche/Fakulttsprfung, Promotion, sonstige,Kein Abschluss/Abschluss im Ausland',
'CHAR',
'10',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_cifx',
foreignkey_col='apnr',
foreignkey_cap='druck',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_absolv_aggr_astat_abschlusstyp';

update tmp_fields set foreignkey_cond='689=kenn_cifx.key'
where trim(table_name) || '_' || trim(name) ='kenn_absolv_aggr_astat_abschlusstyp'
and trim(foreignkey_tab) = 'kenn_cifx';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_absolv_aggr_astat',
'regel',
'Regelstudienzeit',
'',
'SMALLINT',
'2',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_absolv_aggr_astat',
'fach_sem_zahl',
'Anzahl Fachsemester',
'',
'SMALLINT',
'2',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_absolv_aggr_astat',
'aufbaustudium',
'Ist Aufbaustudium',
'Aufbau/Erweiterung/Ergnzung/Weiterbildung (1=ja)',
'CHAR',
'10',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_absolv_aggr_astat',
'datum',
'Datum der Erzeugung',
'Dieses Feld wird zur Archivierung von gelieferten Daten genutzt',
'date',
'4',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_absolv_aggr_astat',
'summe',
'Summe',
'',
'INTEGER',
'4',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_alt_keys',
'hs_nr',
'Hochschulnummer',
'',
'INTEGER',
'4',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_alt_keys',
'relation',
'relation',
'',
'CHAR',
'10',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_alt_keys',
'hierarchie_id',
'hierarchie_id',
'',
'integer',
'4',
1,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_alt_keys',
'key',
'key',
'',
'CHAR',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_alt_keys',
'parent',
'parent',
'',
'CHAR',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_alt_keys',
'flags',
'flags',
'',
'SMALLINT',
'',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_anlagen_aggr',
'hs_nr',
'Hochschulnummer',
'',
'INTEGER',
'4',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_hochschulen',
foreignkey_col='hs_nr',
foreignkey_cap='name',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_anlagen_aggr_hs_nr';

update tmp_fields set foreignkey_cond='inst_ext=kenn_inst_to_ext.instnr'
where trim(table_name) || '_' || trim(name) ='kenn_anlagen_aggr_hs_nr'
and trim(foreignkey_tab) = 'kenn_inst_to_ext';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_anlagen_aggr',
'jahr',
'Jahr',
'(in ivs:ivasp.asp_haushaltsjahr)',
'SMALLINT',
'2',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_anlagen_aggr',
'inst_ext',
'Institut',
'Externe Kostenstelle (in ivs:ivasp.asp_kostenstelle)',
'CHAR',
'20',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_inst_to_ext',
foreignkey_col='instnr',
foreignkey_cap='dbez_ext',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_anlagen_aggr_inst_ext';

update tmp_fields set foreignkey_cond='hs_nr=kenn_inst_to_ext.hs_nr'
where trim(table_name) || '_' || trim(name) ='kenn_anlagen_aggr_inst_ext'
and trim(foreignkey_tab) = 'kenn_inst_to_ext';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_anlagen_aggr',
'bund_fachgebiet',
'Fachgebiet ',
'4-stelliger Bundesschlssel, wird aus Kostenstelle ermittelt',
'CHAR',
'10',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_lfb_fg',
foreignkey_col='apnr',
foreignkey_cap='name',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_anlagen_aggr_bund_fachgebiet';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_anlagen_aggr',
'asp_akl',
'Anlagenklasse',
'Nur BaWue: Inventargegenstnde werden bestimmten Anlagenklassen zugeordnet, wobei jede Anlage zu genau einer AKL gehrt. Differenzierung der Anlagenklasse gem Festlegung des NSI-Landesprojekts (in ivs: ivasp.asp_akl).',
'varchar',
'6',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_cifx',
foreignkey_col='apnr',
foreignkey_cap='druck',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_anlagen_aggr_asp_akl';

update tmp_fields set foreignkey_cond='671=kenn_cifx.key'
where trim(table_name) || '_' || trim(name) ='kenn_anlagen_aggr_asp_akl'
and trim(foreignkey_tab) = 'kenn_cifx';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_anlagen_aggr',
'rest',
'Restbuchwert',
'Anlagen Restbuchwert zum 31.12. d. HH-Jahres (in ivs: ivasp.asp_restw_ende)',
'DECIMAL',
'(14,2)',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_anlagen_aggr',
'rest_vj',
'Restbuchwert Vorjahr',
'Anlagen Restbuchwert des Vorjahres (in ivs: ivasp.asp_restw_beginn)',
'DECIMAL',
'(14,2)',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_anlagen_aggr',
'zugang',
'Zugnge',
'Anlagen mengenmige Zugnge im HH-Jahr (in ivs: ivasp.asp_preis_zugang)',
'DECIMAL',
'(14,2)',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_anlagen_aggr',
'abgang',
'Abgnge',
'Anlagen mengenmige Abgnge im HH-Jahr (in ivs: ivasp.asp_preis_abgang)',
'DECIMAL',
'(14,2)',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_anlagen_aggr',
'abschr',
'Abschreibungen',
'Anlagen Kumulierte Abschreibungen im HH-Jahr (in ivs: ivasp.asp_afa_periode)',
'DECIMAL',
'(14,2)',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_anlagen_aggr',
'histor_ahk',
'Historische AHK',
'Anschaffungs- und Herstellungskosten  Stand 31.12. des Vorjahres, Anfangsbestand der Periode zu AHK (in ivs: ivasp.asp_preis_beginn)',
'DECIMAL',
'(14,2)',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_anlagen_aggr',
'umbuch',
'Umbuchungen',
'Anlagen Umbuchungen d. HH-Jahres (in ivs: ivasp_bga.asp_umbubetrag)',
'DECIMAL',
'(14,2)',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_anlagen_aggr',
'zuschr',
'Zuschreibungen',
'Anlagen Zuschreibungen d. HH-Jahres (in ivs: ivasp_bga.asp_zusch_periode)',
'DECIMAL',
'(14,2)',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_anlagen_aggr',
'abschr_ges',
'gesamte Abschreibungen',
'Anlagen gesamte Abschreibungen d. HH-Jahres (in ivs: ivasp.asp_afa_bis+ivasp.asp_afa_periode)',
'DECIMAL',
'(14,2)',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_anlagen_aggr',
'datum',
'Datum der Erzeugung',
'Dieses Feld wird zur Archivierung von gelieferten Daten genutzt',
'date',
'4',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_anlagen_aggr',
'extkotr',
'Externer Produktschlssel',
'Nummer des externen Produktschlssels (nur Sachsen)',
'CHAR',
'30',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_antr_aggr',
'hs_nr',
'Hochschulnummer',
'',
'INTEGER',
'4',
0,
1,
0,
0);

update tmp_fields set foreignkey_cond='abint=kenn_abint.apnr'
where trim(table_name) || '_' || trim(name) ='kenn_antr_aggr_hs_nr'
and trim(foreignkey_tab) = 'kenn_abint';

update tmp_fields set foreignkey_cond='stg_int=kenn_stg_int.apnr'
where trim(table_name) || '_' || trim(name) ='kenn_antr_aggr_hs_nr'
and trim(foreignkey_tab) = 'kenn_stg_int';

update tmp_fields set foreignkey_tab='kenn_hochschulen',
foreignkey_col='hs_nr',
foreignkey_cap='name',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_antr_aggr_hs_nr';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_antr_aggr',
'fach_nr',
'Fach-Nummer',
'z.B. 2 fr 2. Fach',
'SMALLINT',
'2',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_antr_aggr',
'geschlecht',
'Geschlecht (1 mnnl.,2 weibl.)',
'',
'SMALLINT',
'2',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_geschl',
foreignkey_col='apnr',
foreignkey_cap='druck',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_antr_aggr_geschlecht';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_antr_aggr',
'ca12_staat',
'Nationalitt',
'',
'SMALLINT',
'2',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_staat',
foreignkey_col='astat',
foreignkey_cap='druck',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_antr_aggr_ca12_staat';

update tmp_fields set foreignkey_func='val'
where trim(table_name) || '_' || trim(name) ='kenn_antr_aggr_ca12_staat';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_antr_aggr',
'bewsem',
'Semester',
'Schlssel, siehe Tab. kenn_semester',
'SMALLINT',
'2',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_semester',
foreignkey_col='tid',
foreignkey_cap='druck',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_antr_aggr_bewsem';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_antr_aggr',
'stg',
'Fach (amtlich)',
'',
'CHAR',
'4',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_stg_astat',
foreignkey_col='astat',
foreignkey_cap='dtxt',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_antr_aggr_stg';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_antr_aggr',
'abschluss',
'Abschluss (amtlich)',
'',
'CHAR',
'2',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_abschl_astat',
foreignkey_col='astat',
foreignkey_cap='dtxt',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_antr_aggr_abschluss';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_antr_aggr',
'antrnr',
'Antragsnummer',
'',
'SMALLINT',
'2',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_antr_aggr',
'fach_sem_zahl',
'Fachsemester',
'Bewerbung zum x-ten Fachsemester. Bei Datenquelle ZUL ist dies antr.stgsem',
'SMALLINT',
'2',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_antr_aggr',
'stort',
'Standort',
'Hochschulstandort (amtlich)',
'CHAR',
'10',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_stort',
foreignkey_col='apnr',
foreignkey_cap='druck',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_antr_aggr_stort';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_antr_aggr',
'stg_int',
'Fach (intern)',
'Fach (intern)',
'CHAR',
'10',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_stg_int',
foreignkey_col='apnr',
foreignkey_cap='druck',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_antr_aggr_stg_int';

update tmp_fields set foreignkey_cond='hs_nr=kenn_stg_int.hs_nr'
where trim(table_name) || '_' || trim(name) ='kenn_antr_aggr_stg_int'
and trim(foreignkey_tab) = 'kenn_stg_int';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_antr_aggr',
'abint',
'Abschluss (intern)',
'Abschluss (intern)',
'CHAR',
'10',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_abint',
foreignkey_col='apnr',
foreignkey_cap='druck',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_antr_aggr_abint';

update tmp_fields set foreignkey_cond='hs_nr=kenn_abint.hs_nr'
where trim(table_name) || '_' || trim(name) ='kenn_antr_aggr_abint'
and trim(foreignkey_tab) = 'kenn_abint';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_antr_aggr',
'hzbart',
'Art der Hochschulzugangsber.',
'             SuperX-eigene Gruppierung:             hzbart=1 Allg. Hochschulreife,               hzbart=2 Fachhochschulreife,                                             hzbart=3 Fach(geb.) Hochschulreife im Ausl.,                             hzbart=4 All',
'SMALLINT',
'2',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_hzbart',
foreignkey_col='astat',
foreignkey_cap='druck',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_antr_aggr_hzbart';

update tmp_fields set foreignkey_func='val'
where trim(table_name) || '_' || trim(name) ='kenn_antr_aggr_hzbart';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_antr_aggr',
'zul_kz',
'Zugelassen',
'J=ja',
'CHAR',
'1',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_antr_aggr',
'datum',
'Datum der Erzeugung',
'Dieses Feld wird zur Archivierung von gelieferten Daten genutzt',
'date',
'4',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_antr_aggr',
'einschreib_kz',
'Einschreibungs-Kennzeichen',
'J=Einschreibung, wird jeweils von HIS1 und ZUL-GX gefuellt',
'CHAR',
'1',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_antr_aggr',
'summe',
'Summe',
'',
'INTEGER',
'4',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_antr_aggr',
'stg_land',
'Fach Land (amtlich)',
'',
'CHAR',
'4',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='k_astat_studienfach_land_l',
foreignkey_col='schluessel',
foreignkey_cap='name',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_antr_aggr_stg_land';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_antr_cube',
'hs_nr',
'Hochschulnummer',
'',
'INTEGER',
'20',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='dim_hochschule',
foreignkey_col='hs_nr',
foreignkey_cap='name',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_antr_cube_hs_nr';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_antr_cube',
'fach_nr',
'Fach-Nummer',
'z.B. 2 fr 2. Fach',
'SMALLINT',
'2',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='cif',
foreignkey_col='apnr',
foreignkey_cap='druck',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_antr_cube_fach_nr';

update tmp_fields set foreignkey_cond='654=cif.key'
where trim(table_name) || '_' || trim(name) ='kenn_antr_cube_fach_nr'
and trim(foreignkey_tab) = 'cif';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_antr_cube',
'geschlecht',
'Geschlecht (1 mnnl.,2 weibl.)',
'',
'SMALLINT',
'2',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='cif',
foreignkey_col='apnr',
foreignkey_cap='druck',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_antr_cube_geschlecht';

update tmp_fields set foreignkey_cond='9003=cif.key'
where trim(table_name) || '_' || trim(name) ='kenn_antr_cube_geschlecht'
and trim(foreignkey_tab) = 'cif';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_antr_cube',
'ca12_staat',
'Nationalitt',
'',
'SMALLINT',
'2',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='cif',
foreignkey_col='apnr',
foreignkey_cap='druck',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_antr_cube_ca12_staat';

update tmp_fields set foreignkey_cond='12=cif.key'
where trim(table_name) || '_' || trim(name) ='kenn_antr_cube_ca12_staat'
and trim(foreignkey_tab) = 'cif';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_antr_cube',
'bewsem',
'Semester',
'Schlssel, siehe Tab. kenn_semester',
'SMALLINT',
'2',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='cif',
foreignkey_col='apnr',
foreignkey_cap='druck',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_antr_cube_bewsem';

update tmp_fields set foreignkey_cond='661=cif.key'
where trim(table_name) || '_' || trim(name) ='kenn_antr_cube_bewsem'
and trim(foreignkey_tab) = 'cif';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_antr_cube',
'zul_kz',
'Zulassungskennzeichen',
'EDUDATA-Merkmal Nummer 875',
'INTEGER',
'4',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='cif',
foreignkey_col='apnr',
foreignkey_cap='druck',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_antr_cube_zul_kz';

update tmp_fields set foreignkey_cond='663=cif.key'
where trim(table_name) || '_' || trim(name) ='kenn_antr_cube_zul_kz'
and trim(foreignkey_tab) = 'cif';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_antr_cube',
'abschluss_astat',
'Abschluss (amtlich)',
'',
'CHAR',
'10',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='dim_kenn_abschl_astat',
foreignkey_col='apnr',
foreignkey_cap='druck',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_antr_cube_abschluss_astat';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_antr_cube',
'stg_astat',
'Fach (amtlich)',
'',
'CHAR',
'20',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='dim_kenn_stg_astat',
foreignkey_col='apnr',
foreignkey_cap='druck',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_antr_cube_stg_astat';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_antr_cube',
'stg',
'Hochschule und Fach (intern)',
'',
'CHAR',
'20',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='dim_kenn_stg_int',
foreignkey_col='apnr',
foreignkey_cap='druck',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_antr_cube_stg';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_antr_cube',
'antrnr',
'Antragsnummer',
'',
'SMALLINT',
'2',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='cif',
foreignkey_col='apnr',
foreignkey_cap='druck',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_antr_cube_antrnr';

update tmp_fields set foreignkey_cond='662=cif.key'
where trim(table_name) || '_' || trim(name) ='kenn_antr_cube_antrnr'
and trim(foreignkey_tab) = 'cif';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_antr_cube',
'fach_sem_zahl',
'Fachsemester',
'Bewerbung zum x-ten Fachsemester',
'SMALLINT',
'2',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='cif',
foreignkey_col='apnr',
foreignkey_cap='druck',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_antr_cube_fach_sem_zahl';

update tmp_fields set foreignkey_cond='655=cif.key'
where trim(table_name) || '_' || trim(name) ='kenn_antr_cube_fach_sem_zahl'
and trim(foreignkey_tab) = 'cif';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_antr_cube',
'stort',
'Standort',
'Hochschulstandort (amtlich)',
'CHAR',
'10',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_antr_cube',
'hzbart',
'Art der Hochschulzugangsber.',
'             SuperX-eigene Gruppierung:             hzbart=1 Allg. Hochschulreife,               hzbart=2 Fachhochschulreife,                                             hzbart=3 Fach(geb.) Hochschulreife im Ausl.,                             hzbart=4 All',
'SMALLINT',
'2',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='cif',
foreignkey_col='apnr',
foreignkey_cap='druck',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_antr_cube_hzbart';

update tmp_fields set foreignkey_cond='652=cif.key'
where trim(table_name) || '_' || trim(name) ='kenn_antr_cube_hzbart'
and trim(foreignkey_tab) = 'cif';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_antr_cube',
'summe',
'Summe',
'',
'INTEGER',
'4',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_antr_prozess_aggr',
'hs_nr',
'Hochschulnummer',
'',
'INTEGER',
'4',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_hochschulen',
foreignkey_col='hs_nr',
foreignkey_cap='name',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_antr_prozess_aggr_hs_nr';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_antr_prozess_aggr',
'fach_nr',
'Fach-Nummer',
'z.B. 2 fr 2. Fach',
'SMALLINT',
'2',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_antr_prozess_aggr',
'geschlecht',
'Geschlecht',
' (1=nicht-weiblich,2= weibl.)',
'CHAR',
'10',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_cifx',
foreignkey_col='apnr',
foreignkey_cap='druck',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_antr_prozess_aggr_geschlecht';

update tmp_fields set foreignkey_cond='693=kenn_cifx.key'
where trim(table_name) || '_' || trim(name) ='kenn_antr_prozess_aggr_geschlecht'
and trim(foreignkey_tab) = 'kenn_cifx';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_antr_prozess_aggr',
'bewsem',
'Semester',
'Schlssel, siehe Tab. kenn_semester',
'SMALLINT',
'2',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_semester',
foreignkey_col='tid',
foreignkey_cap='druck',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_antr_prozess_aggr_bewsem';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_antr_prozess_aggr',
'stg',
'Fach (amtlich Bund)',
'',
'CHAR',
'4',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_stg_astat',
foreignkey_col='astat',
foreignkey_cap='dtxt',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_antr_prozess_aggr_stg';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_antr_prozess_aggr',
'stg_land',
'Fach Land (amtlich)',
'',
'CHAR',
'4',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='k_astat_studienfach_land_l',
foreignkey_col='schluessel',
foreignkey_cap='name',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_antr_prozess_aggr_stg_land';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_antr_prozess_aggr',
'abschlusstyp',
'Abschlusstyp',
'Gruppierung BaWue 2024: BA, BA LA, MA, MA LA, StaEx, Magister/Diplom/Kirchliche/Fakulttsprfung, Promotion, sonstige,Kein Abschluss/Abschluss im Ausland',
'CHAR',
'10',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_cifx',
foreignkey_col='apnr',
foreignkey_cap='druck',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_antr_prozess_aggr_abschlusstyp';

update tmp_fields set foreignkey_cond='689=kenn_cifx.key'
where trim(table_name) || '_' || trim(name) ='kenn_antr_prozess_aggr_abschlusstyp'
and trim(foreignkey_tab) = 'kenn_cifx';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_antr_prozess_aggr',
'antrnr',
'Antragsnummer',
'',
'SMALLINT',
'2',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_antr_prozess_aggr',
'fach_sem_zahl_1',
'1. Fachsemester',
'Bewerbung zum 1. Fachsemester, 0=nein,1=ja',
'CHAR',
'10',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_cifx',
foreignkey_col='apnr',
foreignkey_cap='druck',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_antr_prozess_aggr_fach_sem_zahl_1';

update tmp_fields set foreignkey_cond='690=kenn_cifx.key'
where trim(table_name) || '_' || trim(name) ='kenn_antr_prozess_aggr_fach_sem_zahl_1'
and trim(foreignkey_tab) = 'kenn_cifx';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_antr_prozess_aggr',
'antrag_status',
'Antragsstatus',
'Antrag ungltig / gltig / zugelassen / angenommen / eingeschrieben',
'CHAR',
'10',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_cifx',
foreignkey_col='apnr',
foreignkey_cap='druck',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_antr_prozess_aggr_antrag_status';

update tmp_fields set foreignkey_cond='692=kenn_cifx.key'
where trim(table_name) || '_' || trim(name) ='kenn_antr_prozess_aggr_antrag_status'
and trim(foreignkey_tab) = 'kenn_cifx';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_antr_prozess_aggr',
'aufbaustudium',
'Ist Aufbaustudium',
'Aufbau/Erweiterung/Ergnzung/Weiterbildung (1=ja)',
'CHAR',
'10',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_antr_prozess_aggr',
'datum',
'Datum der Erzeugung',
'Dieses Feld wird zur Archivierung von gelieferten Daten genutzt',
'date',
'4',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_antr_prozess_aggr',
'summe',
'Summe',
'',
'INTEGER',
'4',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_auslastung',
'hs_nr',
'Hochschulnummer',
'',
'INTEGER',
'4',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_auslastung',
'lehreinheit',
'Lehreinheit',
'',
'CHAR',
'10',
0,
0,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_auslastung',
'k_extkotr',
'Externer Produktschlssel',
'',
'CHAR',
'10',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_auslastung',
'sem',
'Semester',
'Format: JJJJS mit S = 1 fr SoSe und S = 2 fr WiSe, z.B. 20141 fr SoSe 2014, 20142 fr WiSe 2014/2015',
'INTEGER',
'4',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_auslastung',
'datum',
'Berechnungsdatum',
'',
'DATE',
'4',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_auslastung',
'ffidrgf2',
'VZ in der RSZ',
'',
'DOUBLE',
'8',
0,
0,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_auslastung',
'sws_lehrang',
'SWS Angebot',
'',
'DOUBLE',
'8',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_auslastung',
'sws_lehrnf',
'SWS Nachfrage',
'Summe eigene und fremde Studiengnge, sws_lehrnf_eigen+sws_lehrnf_fremd',
'DOUBLE',
'8',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_auslastung',
'sws_lehrnf_eigen',
'SWS Nachfrage (eigene Studiengnge)',
'',
'DOUBLE',
'8',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_auslastung',
'sws_lehrnf_fremd',
'SWS Nachfrage (Dienstleistung fr andere Studiengnge)',
'',
'DOUBLE',
'8',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_auslastung',
'sws_lehrnf_ea',
'SWS Nachfrage eigener Studiengnge an alle Lehreinheiten',
'',
'DOUBLE',
'8',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_auslastung',
'dlk',
'Dienstleistungskoeffizient',
'sws_lehrnf/sws_lehrnf_ea',
'DOUBLE',
'8',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_bestand',
'hs_nr',
'hs_nr',
'',
'INTEGER',
'10',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_bestand',
'bestandsart',
'bestandsart',
'',
'CHAR',
'40',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_bestand',
'stichtagsart_id',
'stichtagsart_id',
'',
'CHAR',
'40',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_bestand',
'quelltabelle',
'quelltabelle',
'',
'VARCHAR',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_bestand',
'timeunit',
'timeunit',
'',
'CHAR',
'1',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_bestand',
'zeitwert',
'zeitwert',
'',
'INTEGER',
'10',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_bestand',
'bestand_anz',
'bestand_anz',
'',
'INTEGER',
'10',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_bestand',
'bestand_datum',
'bestand_datum',
'',
'date',
'10',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_bestand',
'datenherkunft',
'datenherkunft',
'Manuell hochgeladen ODER dateibasiert aus HIIS bertragen',
'VARCHAR',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_bestandsart',
'apnr',
'Schlssel Bestandsart',
'',
'CHAR',
'40',
1,
1,
0,
0);

update tmp_fields set is_primarykey=1 
where trim(table_name) || '_' || trim(name) ='kenn_bestandsart_apnr';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_bestandsart',
'kurz',
'kurz',
'',
'VARCHAR',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_bestandsart',
'druck',
'druck',
'',
'VARCHAR',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_bestandsart',
'beschreibung',
'beschreibung',
'',
'VARCHAR',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_bestandsart',
'eingabeschema',
'eingabeschema',
'',
'VARCHAR',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_bestandsart',
'bezugsart',
'Bezugsart (Semester S, Akad. Jahr A,Jahr J, Quartal Q, Monat M)',
'',
'CHAR',
'1',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_bestandsart',
'quelltabelle',
'quelltabelle',
'',
'VARCHAR',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_bestandsart',
'zeitfeld',
'zeitfeld',
'',
'VARCHAR',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_bestandsart',
'stichtagsart_id',
'Schlssel Stichtagsart',
'',
'CHAR',
'40',
1,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_stichtagsart',
foreignkey_col='apnr',
foreignkey_cap='druck',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_bestandsart_stichtagsart_id';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_bestandsart_bland',
'tid',
'Tupelidentifier',
'',
'SERIAL',
'4',
1,
1,
0,
0);

update tmp_fields set is_primarykey=1 
where trim(table_name) || '_' || trim(name) ='kenn_bestandsart_bland_tid';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_bestandsart_bland',
'bestandsart',
'Schlssel Bestandsart',
'',
'CHAR',
'40',
1,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_bestandsart_bland',
'beschreibung',
'beschreibung',
'',
'VARCHAR',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_bestandsart_bland',
'eingabeschema',
'eingabeschema',
'',
'VARCHAR',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_bestandsart_bland',
'bland',
'Bundesland',
'Bundesland-spezifische Bestandsart?',
'CHAR',
'10',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_busa_aggr',
'hs_nr',
'Hochschulnummer',
'',
'INTEGER',
'4',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_hochschulen',
foreignkey_col='hs_nr',
foreignkey_cap='name',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_busa_aggr_hs_nr';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_busa_aggr',
'jahr',
'Jahr der Buchung',
'',
'SMALLINT',
'2',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_busa_aggr',
'quartal',
'Quartal der Buchung',
'',
'INTEGER',
'2',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_busa_aggr',
'monat',
'Monat der Buchung',
'',
'SMALLINT',
'2',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='dim_kenn_monat',
foreignkey_col='monat',
foreignkey_cap='name',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_busa_aggr_monat';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_busa_aggr',
'fikrkey',
'Kostenart',
'Hochschulinterne Kostenart, SAP Hochschulen knnen die Spalte leer liefern.',
'CHAR',
'12',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_fikr',
foreignkey_col='key',
foreignkey_cap='lbez',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_busa_aggr_fikrkey';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_busa_aggr',
'kokl_faktor',
'Kostenklasse (1=Kosten, -1=Erls)',
'',
'SMALLINT',
'2',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_busa_aggr',
'klr_geldgeber',
'Geldgeber nach KLR (Drittm.,Fremdkap.,HH)',
'In BaWue werden die dreistelligen Schlssel 110,190,210,290,300-311 geliefert.',
'CHAR',
'10',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_gege',
foreignkey_col='apnr',
foreignkey_cap='druck',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_busa_aggr_klr_geldgeber';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_busa_aggr',
'ch110_institut',
'Kostenstelle (alternative Hierarchie KENN-Kostenstellen)',
'Nur Lehreinheiten mssen gelfegt sein, alle anderen Zeilen knnen hier leer bleiben.',
'VARCHAR',
'50',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_inst',
foreignkey_col='key_apnr',
foreignkey_cap='name',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_busa_aggr_ch110_institut';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_busa_aggr',
'projnr',
'Externer Kostentrger',
'',
'CHAR',
'10',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_extkotr',
foreignkey_col='key',
foreignkey_cap='name',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_busa_aggr_projnr';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_busa_aggr',
'datum',
'Datum der Erzeugung',
'Dieses Feld wird zur Archivierung von gelieferten Daten genutzt',
'date',
'4',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_busa_aggr',
'betrag',
'Betrag in EUR',
'',
'DOUBLE',
'8',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_busa_aggr',
'bvkr_art',
'Kostenart (BVKR)',
'Hier werden nur ausgewhlte Kostenarten (gem. Grunddaten-Katalog) angezeigt.',
'CHAR',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_busa_aggr',
'inst_art',
'Externe Kostenstelle',
'Hier werden nur ausgewhlte Kostenstellen (gem. Grunddaten-Katalog) angezeigt.',
'CHAR',
'20',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_cifx',
'tid',
'tid',
'Schlssel',
'INTEGER',
'4',
0,
1,
0,
0);

update tmp_fields set is_primarykey=1 
where trim(table_name) || '_' || trim(name) ='kenn_cifx_tid';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_cifx',
'hs',
'Hochschulschlssel (ohne Verwendung)',
'',
'INTEGER',
'4',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_cifx',
'key',
'hochschulischer Schlssel',
'',
'SMALLINT',
'2',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_cifx',
'apnr',
'statistische Ausprgung',
'',
'CHAR',
'10',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_cifx',
'd_akt_von',
'gltig von',
'',
'DATE',
'4',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_cifx',
'd_akt_bis',
'gltig bis',
'',
'DATE',
'4',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_cifx',
'kurz',
'Kurzbezeichnung',
'',
'CHAR',
'10',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_cifx',
'druck',
'Druckbezeichnung',
'',
'CHAR',
'100',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_cifx',
'lang_1',
'Langbezeichnung1',
'',
'CHAR',
'250',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_cifx',
'lang_2',
'Langbezeichnung2',
'',
'CHAR',
'250',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_cifx',
'lang_3',
'Langbezeichnung3',
'',
'CHAR',
'250',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_cifx',
'parent',
'bergeordn. Schlssel',
'',
'CHAR',
'10',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_cifx',
'filter',
'(ohne Verwendung)',
'',
'CHAR',
'10',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_cifx',
'his_system_key',
'(ohne Verwendung)',
'',
'CHAR',
'10',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_cifx',
'astat',
'Statistikschlssel',
'',
'CHAR',
'10',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_cifx',
'bund_apnr',
'Statistikschlssel Bund',
'',
'CHAR',
'10',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_cifx',
'land_apnr',
'Statistikschlssel Land',
'',
'CHAR',
'10',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_cifx',
'sort1',
'Sortierschlssel (Ganzzahl)',
'',
'INTEGER',
'4',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_cifx',
'sort2',
'Sortierschlssel (Ganzzahl) 2',
'',
'INTEGER',
'4',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_cifx',
'sort3',
'Sortierschlssel (Ganzzahl) 3',
'',
'INTEGER',
'4',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_cifx',
'sortc1',
'Sortierschlssel (Alphabetisch)',
'',
'CHAR',
'10',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_cifx',
'sortc2',
'Sortierschlssel (Alphabetisch) 2',
'',
'CHAR',
'10',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_cifx',
'intern_int',
'(ohne Verwendung)',
'',
'INTEGER',
'4',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_cifx',
'intern_c',
'(ohne Verwendung)',
'',
'CHAR',
'10',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_cifx',
'sprache',
'(ohne Verwendung)',
'',
'CHAR',
'3',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_cifx',
'struktur_int',
'(ohne Verwendung)',
'',
'INTEGER',
'4',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_cifx',
'struktur_c',
'(ohne Verwendung)',
'',
'CHAR',
'50',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_cifx',
'ebene',
'Ebene in Hierarchie',
'',
'INTEGER',
'4',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_cifx',
'gruppe',
'Gruppierungsmerkmal',
'',
'CHAR',
'10',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_dim_extkost',
'hs_art',
'Hochschulart',
'',
'CHAR',
'10',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_dim_extkost',
'hs_art_str',
'Hochschulart Bezeichnung',
'',
'VARCHAR',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_dim_extkost',
'hs_nr',
'Hochschule (Schlssel)',
'',
'INTEGER',
'4',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_dim_extkost',
'hs_nr_str',
'Hochschule (Name)',
'',
'VARCHAR',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_dim_extkost',
'kost_art',
'Art der ext. Kostenstelle',
'',
'VARCHAR',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_dim_extkost',
'extkost',
'Externe Kostenstelle (Schlssel)',
'',
'CHAR',
'40',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_dim_extkost',
'extkost_str',
'Externe Kostenstelle (Name)',
'',
'VARCHAR',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_dim_extkotr',
'key',
'Externer Kostentrgerschlssel',
'',
'CHAR',
'30',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_dim_extkotr',
'name',
'Externer Kostentrgerbezeichnung',
'',
'CHAR',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_dim_extkotr',
'pb',
'Produktbereich Schlssel',
'',
'CHAR',
'30',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_dim_extkotr',
'pb_str',
'Produktbereich Name',
'',
'VARCHAR',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_dim_extkotr',
'fgr',
'Produktbereich Schlssel',
'',
'CHAR',
'30',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_dim_extkotr',
'fgr_str',
'Produktbereich Name',
'',
'VARCHAR',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_dim_extkotr',
'sb',
'Produktbereich Schlssel',
'',
'CHAR',
'30',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_dim_extkotr',
'sb_str',
'Produktbereich Name',
'',
'VARCHAR',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_dim_extkotr',
'fach',
'Produktbereich Schlssel',
'',
'CHAR',
'30',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_dim_extkotr',
'fach_str',
'Produktbereich Name',
'',
'VARCHAR',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_dim_extkotr',
'gueltig_von',
'Gltig von',
'',
'DATE',
'4',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_dim_extkotr',
'gueltig_bis',
'Gltig bis',
'',
'DATE',
'4',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_dim_fgr',
'apnr',
'Fchergruppe (Schlssel)',
'',
'CHAR',
'10',
0,
1,
0,
0);

update tmp_fields set is_primarykey=1 
where trim(table_name) || '_' || trim(name) ='kenn_dim_fgr_apnr';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_dim_fgr',
'drucktext',
'Fchergruppe (Bezeichnung)',
'',
'CHAR',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_dim_fgr',
'fg_personal',
'Fchergruppe Personal (Schlssel)',
'',
'CHAR',
'10',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_dim_fgr',
'fg_studierende',
'Fchergruppe Studierende (Schlssel)',
'',
'CHAR',
'10',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_dim_fgr',
'gueltig_von',
'Gltig von',
'',
'DATE',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_dim_fgr',
'gueltig_bis',
'Gltig von',
'',
'DATE',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_dim_lfb_fg',
'apnr',
'Fach (Schlssel)',
'',
'CHAR',
'10',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_dim_lfb_fg',
'drucktext',
'Fach (Bezeichnung)',
'',
'CHAR',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_dim_lfb_fg',
'lfb',
'LFB (Schlssel)',
'',
'CHAR',
'10',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_dim_lfb_fg',
'lfb_str',
'LFB (Bezeichnung)',
'',
'CHAR',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_dim_lfb_fg',
'fgr',
'Fchergruppe (Schlssel)',
'',
'CHAR',
'10',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_dim_lfb_fg',
'fgr_str',
'Fchergruppe (Bezeichnung)',
'',
'CHAR',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_dim_lfb_fg',
'gueltig_von',
'Gltig von',
'',
'DATE',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_dim_lfb_fg',
'gueltig_bis',
'Gltig von',
'',
'DATE',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_dr',
'hs_nr',
'Hochschulnummer',
'',
'INTEGER',
'4',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_dr',
'jahr',
'Haushaltsjahr',
'',
'SMALLINT',
'',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_dr',
'kapitel',
'Kapitel',
'',
'CHAR',
'5',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_dr',
'dr',
'Titelgruppe/Deckungsring',
'',
'CHAR',
'5',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_dr',
'dritt',
'Drittmittelkonto',
'',
'integer',
'',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_dr',
'bezeichnung',
'Bezeichnung',
'',
'CHAR',
'150',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_dr',
'check1',
'check1',
'',
'CHAR',
'1',
0,
0,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_dr',
'ktobez',
'Kontenbezeichnung',
'',
'VARCHAR',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_drittm_aggr',
'hs_nr',
'Hochschulnummer',
'',
'INTEGER',
'4',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_drittm_aggr',
'jahr',
'Jahr der Buchung',
'',
'SMALLINT',
'2',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_drittm_aggr',
'betragsart',
'Art des Betrages',
'BaWue:A=Ausgabe/Auswendungen,E=Einnahme/Ertrge',
'CHAR',
'1',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_drittm_aggr',
'kfmkam',
'Kaufm./Kameral berechnet',
'1=kameral, 2=kaufmnnisch',
'SMALLINT',
'30',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_drittm_aggr',
'syf',
'Syf-Code ',
'(aus zugewiesener Institution)',
'CHAR',
'10',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_drittm_aggr',
'fgr',
'Fchergruppe',
'(aus zugewiesenem LFB)',
'CHAR',
'10',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_drittm_aggr',
'datum',
'Datum der Erzeugung',
'Dieses Feld wird zur Archivierung von gelieferten Daten genutzt',
'date',
'4',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_drittm_aggr',
'betrag',
'Betrag in EUR',
'Achtung: Ausgaben haben positives Vorzeichen',
'DOUBLE',
'4',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_extkotr',
'hs_nr',
'Hochschulnummer',
'',
'INTEGER',
'4',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_hochschulen',
foreignkey_col='hs_nr',
foreignkey_cap='name',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_extkotr_hs_nr';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_extkotr',
'key',
'Externer Kostentrgerschlssel',
'',
'CHAR',
'30',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_extkotr',
'parent',
'bergeordneter Schlssel',
'',
'CHAR',
'30',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_extkotr',
'name',
'Externer Kostentrgerbezeichnung',
'',
'CHAR',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_extkotr',
'kategorie',
'Kostentrger-Kategorie',
'',
'CHAR',
'2',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_extkotr',
'fins_stugfach',
'Finanzstatistikschlssel',
'',
'CHAR',
'3',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_extkotr',
'tid',
'Laufnummer',
'',
'SERIAL',
'4',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_extkotr',
'gueltig_von',
'Gltig von',
'',
'DATE',
'4',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_extkotr',
'gueltig_bis',
'Gltig bis',
'',
'DATE',
'4',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_extkotr_lfb_hs',
'key',
'Externer Kostentrger (Schlssel)',
'',
'CHAR',
'10',
1,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_extkotr_lfb_hs',
'hs_nr',
'Hochschule',
'',
'INTEGER',
'10',
1,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_extkotr_stg',
'tid',
'tid',
'',
'SERIAL',
'4',
1,
1,
0,
0);

update tmp_fields set is_primarykey=1 
where trim(table_name) || '_' || trim(name) ='kenn_extkotr_stg_tid';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_extkotr_stg',
'extkotr',
'Externer Kostentrger',
'',
'CHAR',
'30',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_extkotr',
foreignkey_col='key',
foreignkey_cap='key ||''-'' || name',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_extkotr_stg_extkotr';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_extkotr_stg',
'stg',
'Fach (intern) Schlssel',
'',
'CHAR',
'10',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_stg_int',
foreignkey_col='apnr',
foreignkey_cap='druck',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_extkotr_stg_stg';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_extkotr_stg',
'stg_astat',
'Fach (amtlich) Bundesschlssel',
'',
'CHAR',
'10',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_stg_astat',
foreignkey_col='astat',
foreignkey_cap='dtxt',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_extkotr_stg_stg_astat';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_extkotr_stg',
'stg_str',
'Fach (intern) Name',
'',
'CHAR',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_fibu_bilanz',
'hs_nr',
'Hochschulnummer',
'',
'INTEGER',
'',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_fibu_bilanz',
'jahr',
'jahr',
'',
'SMALLINT',
'',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_fibu_bilanz',
'name',
'name',
'',
'VARCHAR',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_fibu_bilanz',
'hierarchie_ebene',
'hierarchie_ebene',
'',
'SMALLINT',
'',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_fibu_bilanz',
'betrag',
'betrag',
'',
'DOUBLE',
'4',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_fibu_bilanz',
'betragvorjahr',
'betragvorjahr',
'',
'DOUBLE',
'4',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_fibu_bilanz',
'unterstrich',
'unterstrich',
'',
'SMALLINT',
'',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_fibu_bilanz',
'sortnr',
'sortnr',
'',
'INTEGER',
'',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_fibu_bilanz',
'sortnr2',
'sortnr2',
'',
'INTEGER',
'',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_fibu_bilanz',
'datum',
'Datum der Erzeugung',
'Dieses Feld wird zur Archivierung von gelieferten Daten genutzt',
'DATE',
'',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_fibu_guv',
'hs_nr',
'Hochschulnummer',
'',
'INTEGER',
'',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_fibu_guv',
'jahr',
'jahr',
'',
'SMALLINT',
'',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_fibu_guv',
'name',
'name',
'',
'VARCHAR',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_fibu_guv',
'hierarchie_ebene',
'hierarchie_ebene',
'',
'SMALLINT',
'',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_fibu_guv',
'betrag',
'betrag',
'',
'DOUBLE',
'4',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_fibu_guv',
'betragvorjahr',
'betragvorjahr',
'',
'DOUBLE',
'4',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_fibu_guv',
'unterstrich',
'unterstrich',
'',
'SMALLINT',
'',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_fibu_guv',
'sortnr',
'sortnr',
'',
'INTEGER',
'',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_fibu_guv',
'sortnr2',
'sortnr2',
'',
'INTEGER',
'',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_fibu_guv',
'datum',
'Datum der Erzeugung',
'Dieses Feld wird zur Archivierung von gelieferten Daten genutzt',
'DATE',
'',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_fibu_quartal',
'hs_nr',
'Hochschulnummer',
'',
'INTEGER',
'',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_fibu_quartal',
'id',
'ID fr HIS-FIBU',
'',
'VARCHAR',
'50',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_fibu_quartal',
'jahr',
'jahr',
'',
'SMALLINT',
'',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_fibu_quartal',
'zeile',
'zeile',
'',
'VARCHAR',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_fibu_quartal',
'kontengruppe',
'kontengruppe',
'',
'VARCHAR',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_fibu_quartal',
'name',
'name',
'',
'VARCHAR',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_fibu_quartal',
'hierarchie_ebene',
'hierarchie_ebene',
'',
'SMALLINT',
'',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_fibu_quartal',
'plan',
'plan',
'',
'DOUBLE',
'4',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_fibu_quartal',
'q1',
'q1',
'',
'DOUBLE',
'4',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_fibu_quartal',
'q2',
'q2',
'',
'DOUBLE',
'4',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_fibu_quartal',
'q3',
'q3',
'',
'DOUBLE',
'4',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_fibu_quartal',
'q4',
'q4',
'',
'DOUBLE',
'4',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_fibu_quartal',
'steuerungvorschau',
'steuerungvorschau',
'',
'DOUBLE',
'4',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_fibu_quartal',
'steuerungvorjahr',
'steuerungvorjahr',
'',
'DOUBLE',
'4',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_fibu_quartal',
'erlaeuterung',
'erlaeuterung',
'',
'TEXT',
'',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_fibu_quartal',
'sortnr',
'sortnr',
'',
'INTEGER',
'',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_fibu_quartal',
'sortnr2',
'sortnr2',
'',
'INTEGER',
'',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_fibu_quartal',
'datum',
'Datum der Erzeugung',
'Dieses Feld wird zur Archivierung von gelieferten Daten genutzt',
'DATE',
'',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_fibu_quartal',
'zeilennr',
'zeilennr',
'',
'INTEGER',
'4',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_fibu_quartal',
'vorjahr_q1',
'vorjahr_q1',
'',
'DOUBLE',
'4',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_fibu_quartal',
'vorjahr_q2',
'vorjahr_q2',
'',
'DOUBLE',
'4',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_fibu_quartal',
'vorjahr_q3',
'vorjahr_q3',
'',
'DOUBLE',
'4',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_fibu_quartal',
'vorjahr_q4',
'vorjahr_q4',
'',
'DOUBLE',
'4',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_fibu_quartal',
'quartal',
'Quartal der Lieferung',
'',
'SMALLINT',
'',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_fibu_wiplan',
'hs_nr',
'Hochschulnummer',
'',
'INTEGER',
'',
0,
1,
0,
0);

update tmp_fields set is_primarykey=1 
where trim(table_name) || '_' || trim(name) ='kenn_fibu_wiplan_hs_nr';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_fibu_wiplan',
'id',
'eindeutig ID zum Hinterlegen von manuell zu erfassenden Werten',
'',
'VARCHAR',
'50',
1,
1,
0,
0);

update tmp_fields set is_primarykey=1 
where trim(table_name) || '_' || trim(name) ='kenn_fibu_wiplan_id';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_fibu_wiplan',
'jahr',
'jahr',
'',
'SMALLINT',
'',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_fibu_wiplan',
'kuerzel',
'kuerzel',
'',
'VARCHAR',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_fibu_wiplan',
'kontengruppe',
'kontengruppe',
'',
'VARCHAR',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_fibu_wiplan',
'zweckbestimmung',
'zweckbestimmung',
'',
'VARCHAR',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_fibu_wiplan',
'ist',
'ist',
'in TEUR',
'DOUBLE',
'4',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_fibu_wiplan',
'sollplus1',
'sollplus1',
'in TEUR',
'DOUBLE',
'4',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_fibu_wiplan',
'sollplus2',
'sollplus2',
'in TEUR',
'DOUBLE',
'4',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_fibu_wiplan',
'sollplus3',
'sollplus3',
'in TEUR',
'DOUBLE',
'4',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_fibu_wiplan',
'sortnr',
'sortnr',
'Fr Zeilenfolge',
'INTEGER',
'',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_fibu_wiplan',
'datum',
'Datum der Erzeugung',
'Dieses Feld wird zur Archivierung von gelieferten Daten genutzt',
'DATE',
'',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_fikr',
'hs_nr',
'Hochschulnummer',
'',
'INTEGER',
'4',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_fikr',
'key',
'key',
'Nr. d. Kostenart',
'CHAR',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_fikr',
'ueberg',
'ueberg',
'Nr. d. uebergeordn.Kostenart',
'CHAR',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_fikr',
'kbez',
'kbez',
'Kurztext',
'CHAR',
'130',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_fikr',
'lbez',
'lbez',
'Langtext',
'CHAR',
'150',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_fikr',
'kokl',
'kokl',
'K(osten), E(erloese), (Ausgaben, neutrale oder sekundaere Kostenarten werden gefiltert)',
'CHAR',
'1',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_fikr',
'habpos',
'habpos',
'Position im HAB',
'CHAR',
'1',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_fikr',
'ebene',
'ebene',
'Hierarchieebene',
'SMALLINT',
'2',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_fikr',
'key_von',
'key_von',
'gltig von',
'DATE',
'4',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_fikr',
'key_bis',
'key_bis',
'gltig bis',
'DATE',
'4',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_flaeche',
'hs_nr',
'Hochschulnummer',
'',
'INTEGER',
'4',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_hochschulen',
foreignkey_col='hs_nr',
foreignkey_cap='name',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_flaeche_hs_nr';

update tmp_fields set foreignkey_cond='ch110_institut=kenn_inst.key_apnr'
where trim(table_name) || '_' || trim(name) ='kenn_flaeche_hs_nr'
and trim(foreignkey_tab) = 'kenn_inst';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_flaeche',
'ch110_institut',
'Kostenstelle (alternative Hierarchie KENN-Kostenstellen)',
'Derzeit noch nicht gefllt.',
'VARCHAR',
'50',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_inst',
foreignkey_col='key_apnr',
foreignkey_cap='name',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_flaeche_ch110_institut';

update tmp_fields set foreignkey_cond='hs_nr=kenn_inst.hs_nr'
where trim(table_name) || '_' || trim(name) ='kenn_flaeche_ch110_institut'
and trim(foreignkey_tab) = 'kenn_inst';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_flaeche',
'nutzungsart',
'Raumnutzungsart',
'Hauptnutzflche (H)/Nebennutzflche (N), wird ermittelt aus rnanr',
'CHAR',
'4',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_flaeche',
'kfanr',
'Kostenflchenart',
'             0=NNF,              1=Garderoben, Abstellrume,              2=Bchermagazine, Lager,              3=Brorume, Sporthallen,              4=EDV-Brorume,-bungsram,              5=Techn.Labors, Ateliers,              6=Chem.-Techn.Labors, R',
'VARCHAR',
'10',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_flaeche',
'jahr',
'Jahr des Stichtags',
'',
'SMALLINT',
'2',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_flaeche',
'datum',
'Datum der Erzeugung',
'Dieses Feld wird zur Archivierung von gelieferten Daten genutzt',
'date',
'4',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_flaeche',
'flaeche',
'flaeche',
'Nutzflche in qm',
'DOUBLE',
'4',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_flaeche',
'extkotr',
'Externer Produktschlssel',
'Nummer des externen Produktschlssels (nur Sachsen)',
'CHAR',
'30',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_flaeche_cube',
'hs_nr',
'Hochschulnummer',
'',
'INTEGER',
'4',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='dim_hochschule',
foreignkey_col='hs_nr',
foreignkey_cap='name',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_flaeche_cube_hs_nr';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_flaeche_cube',
'bund_fachgebiet',
'Fachgebiet ',
'(aus zugewiesener Dienststelle in POZ ermittelt)',
'CHAR',
'10',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_dim_lfb_fg',
foreignkey_col='apnr',
foreignkey_cap='drucktext',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_flaeche_cube_bund_fachgebiet';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_flaeche_cube',
'nutzungsart',
'Raumnutzungsart',
'Hauptnutzflche (H)/Nebennutzflche (N), wird ermittelt aus rnanr',
'CHAR',
'4',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_cifx',
foreignkey_col='apnr',
foreignkey_cap='druck',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_flaeche_cube_nutzungsart';

update tmp_fields set foreignkey_cond='682=kenn_cifx.key'
where trim(table_name) || '_' || trim(name) ='kenn_flaeche_cube_nutzungsart'
and trim(foreignkey_tab) = 'kenn_cifx';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_flaeche_cube',
'kfanr',
'Kostenflchenart',
'             0=NNF,              1=Garderoben, Abstellrume,              2=Bchermagazine, Lager,              3=Brorume, Sporthallen,              4=EDV-Brorume,-bungsram,              5=Techn.Labors, Ateliers,              6=Chem.-Techn.Labors, R',
'VARCHAR',
'10',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_cifx',
foreignkey_col='apnr',
foreignkey_cap='druck',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_flaeche_cube_kfanr';

update tmp_fields set foreignkey_cond='681=kenn_cifx.key'
where trim(table_name) || '_' || trim(name) ='kenn_flaeche_cube_kfanr'
and trim(foreignkey_tab) = 'kenn_cifx';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_flaeche_cube',
'jahr',
'Jahr des Stichtags',
'',
'SMALLINT',
'2',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_flaeche_cube',
'inst_art',
'Externe Kostenstelle',
'Hier werden nur ausgewhlte Kostenstellen (gem. Grunddaten-Katalog) angezeigt.',
'CHAR',
'20',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_dim_extkost',
foreignkey_col='extkost',
foreignkey_cap='extkost_str',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_flaeche_cube_inst_art';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_flaeche_cube',
'flaeche',
'flaeche',
'Nutzflche in qm',
'DECIMAL',
'(15,2)',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_geschl',
'apnr',
'apnr',
'Geschlechts Schlssel',
'integer',
'4',
1,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_geschl',
'druck',
'druck',
'Druckbeschreibung',
'CHAR',
'150',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_hochschulen',
'name',
'Hochschulname',
'Hochschulname',
'CHAR',
'100',
1,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_hochschulen',
'hs_nr',
'Hochschulnummer (HIS)',
'',
'INTEGER',
'4',
1,
1,
0,
0);

update tmp_fields set is_primarykey=1 
where trim(table_name) || '_' || trim(name) ='kenn_hochschulen_hs_nr';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_hochschulen',
'kapitel',
'Hochschulkapitel',
'',
'CHAR',
'5',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_hochschulen',
'art',
'Hochschulart',
'U (Universitt), FH (Fachhochschule), PH (Pd. Hochschule), KMW (Kunst/Musikhochschule), VFH (Verwaltungs-Fachhochschule), DH (Duale Hochschule)',
'CHAR',
'10',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_cifx',
foreignkey_col='apnr',
foreignkey_cap='druck',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_hochschulen_art';

update tmp_fields set foreignkey_cond='673=kenn_cifx.key'
where trim(table_name) || '_' || trim(name) ='kenn_hochschulen_art'
and trim(foreignkey_tab) = 'kenn_cifx';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_hochschulen',
'traegerschaft',
'Trgerschaft',
'ST (staatlich), OEMWK (ff.Dienst MWK), OENMWK (oeff. Dienst nicht MWK), NST (Nichtstaatlich)',
'CHAR',
'10',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_cifx',
foreignkey_col='apnr',
foreignkey_cap='druck',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_hochschulen_traegerschaft';

update tmp_fields set foreignkey_cond='672=kenn_cifx.key'
where trim(table_name) || '_' || trim(name) ='kenn_hochschulen_traegerschaft'
and trim(foreignkey_tab) = 'kenn_cifx';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_hochschulen',
'kurztext',
'Hochschulname (kurz)',
'Kurzform von dem Hochschulnamen',
'CHAR',
'100',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_hochschulen',
'ort',
'Hochschulort',
'Ort der Hochschule',
'VARCHAR',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_hochschulen',
'bland',
'Bundesland',
'Bundesland der Hochschule',
'CHAR',
'10',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='cifx',
foreignkey_col='apnr',
foreignkey_cap='druck',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_hochschulen_bland';

update tmp_fields set foreignkey_cond='8=cifx.key'
where trim(table_name) || '_' || trim(name) ='kenn_hochschulen_bland'
and trim(foreignkey_tab) = 'cifx';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_hochschulen',
'kuerzel',
'Bundesland',
'Bundesland der Hochschule',
'CHAR',
'10',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_hsfinanz_stat',
'hs_nr',
'Hochschulnummer',
'',
'INTEGER',
'4',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_hsfinanz_stat',
'jahr',
'Jahr der Buchung',
'',
'SMALLINT',
'2',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_hsfinanz_stat',
'betragsart',
'Art des Betrages',
'BaWue:A=Ausgabe/Aufwendungen,E=Einnahme/Ertrge',
'CHAR',
'1',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_hsfinanz_stat',
'kfmkam',
'Kaufm./Kameral berechnet',
'1=kameral, 2=kaufmnnisch',
'SMALLINT',
'30',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_hsfinanz_stat',
'lfb',
'Lehr- und Forschungsbereich',
'',
'CHAR',
'10',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_hsfinanz_stat',
'syf',
'Syf-Code ',
'(aus zugewiesener Institution)',
'CHAR',
'10',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_hsfinanz_stat',
'betrag',
'Betrag in EUR',
'',
'DOUBLE',
'4',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_hzbart',
'astat',
'astat',
'Schlssel',
'CHAR',
'2',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_hzbart',
'druck',
'druck',
'Ausdruck',
'CHAR',
'150',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_hzbart_astat',
'tid',
'Tupelidentifier',
'',
'SERIAL',
'4',
1,
1,
0,
0);

update tmp_fields set is_primarykey=1 
where trim(table_name) || '_' || trim(name) ='kenn_hzbart_astat_tid';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_hzbart_astat',
'bland',
'Bundesland',
'',
'INTEGER',
'4',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_hzbart_astat',
'apnr',
'Schlssel HZB-Art',
'Schlssel der Hochschulzugangsber.',
'CHAR',
'10',
1,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_hzbart_astat',
'druck',
'Bezeichnung',
'Drucktext',
'VARCHAR',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_hzbart_astat',
'gruppe',
'Gruppe',
'HZB-Art (gruppiert)',
'INTEGER',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_hzbart_astat',
'gueltig_von',
'Gltig von',
'Anfang Gltigkeit',
'DATE',
'4',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_hzbart_astat',
'gueltig_bis',
'Gltig bis',
'Ende Gltigkeit',
'DATE',
'4',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_inst',
'tid',
'tid',
'Schlssel',
'SERIAL',
'4',
1,
1,
0,
0);

update tmp_fields set is_primarykey=1 
where trim(table_name) || '_' || trim(name) ='kenn_inst_tid';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_inst',
'hs_nr',
'Hochschulnummer',
'',
'INTEGER',
'4',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_hochschulen',
foreignkey_col='hs_nr',
foreignkey_cap='name',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_inst_hs_nr';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_inst',
'key_apnr',
'key_apnr',
'eindeutige Kostenstellennummer',
'VARCHAR',
'50',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_inst',
'parent',
'parent',
'In der Hierachie direkt bergeordnete eindeutige Kostenstelle, kann NULL sein',
'VARCHAR',
'50',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_inst',
'drucktext',
'Name (Drucktext',
'Wird nur bei Lehreinheiten bernommen',
'CHAR',
'50',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_inst',
'name',
'Name (Drucktext',
'Wird nur bei Lehreinheiten bernommen',
'CHAR',
'250',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_inst',
'ebene',
'ebene',
'Hierachieebene, kann NULL sein',
'INTEGER',
'4',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_inst',
'lehre',
'lehre',
'Kennz. fr 1=Lehreinheit',
'SMALLINT',
'2',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_inst',
'gueltig_seit',
'gueltig_seit',
'Beginn der Gltigkeit',
'DATE',
'4',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_inst',
'gueltig_bis',
'gueltig_bis',
'Ende der Gltigkeit',
'DATE',
'4',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_inst',
'orgstruktur',
'orgstruktur',
'Position in der Oragnisatorischen Struktur der Hochschule, bei Lehreinheiten sollte hier eine "30" bergeben werden.',
'INTEGER',
'4',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_inst',
'bund_lehr_forsch',
'bund_lehr_forsch',
'Lehr und Forschungsbereich (StBA 4.2), kann bei SAP-Hochschulen NULL sein',
'CHAR',
'3',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_lfb_fg',
foreignkey_col='apnr',
foreignkey_cap='name',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_inst_bund_lehr_forsch';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_inst',
'bund_fachgebiet',
'bund_fachgebiet',
'Fachgebiet (StBA 4.1), kann  bei SAP-Hochschulen NULL sein',
'CHAR',
'4',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_lfb_fg',
foreignkey_col='apnr',
foreignkey_cap='name',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_inst_bund_fachgebiet';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_inst_to_ext',
'hs_nr',
'Hochschulnummer',
'',
'INTEGER',
'4',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_inst_to_ext',
'instnr',
'Interne Kostenstellen-Nummer',
'',
'CHAR',
'10',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_inst',
foreignkey_col='key_apnr',
foreignkey_cap='drucktext',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_inst_to_ext_instnr';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_inst_to_ext',
'email',
'email',
'',
'CHAR',
'255',
0,
0,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_inst_to_ext',
'key_ext',
'Externe Kostenstellen-Nummer',
'derzeit nur in BaWue ausgewertet, die sog. "Walter-Systematik"',
'CHAR',
'15',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_inst_to_ext',
'dbez_ext',
'Externe Kostenstelle Bezeichnung',
'',
'CHAR',
'25',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_inst_to_ext',
'gebnr',
'gebnr',
'',
'CHAR',
'10',
0,
0,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_inst_to_ext',
'key_extkotr',
'ext. Kostentrger',
'',
'CHAR',
'10',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_k_buadbz',
'buadbz',
'Schlssel ADBZ',
'',
'CHAR',
'10',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_k_buadbz',
'gruppe_adbz',
'Volltext ADBZ (gruppiert)',
'',
'CHAR',
'50',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_k_buadbz',
'adbz',
'Volltext ADBZ',
'',
'CHAR',
'50',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_k_buadbz',
'druck_adbz',
'Drucktext ADBZ',
'',
'CHAR',
'50',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_k_buadbz',
'gruppe',
'Gruppe gem. HISCOB',
'P=Prof.,W=WHK,S=SHK,U=Azubi,A=ABM,L=Lehrbeauf,X=weitere',
'CHAR',
'1',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_kam_ja',
'hs_nr',
'Hochschulnummer',
'',
'INTEGER',
'',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_kam_ja',
'jahr',
'jahr',
'',
'SMALLINT',
'',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_kam_ja',
'dr',
'dr',
'',
'VARCHAR',
'50',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_kam_ja',
'titel',
'titel',
'',
'CHAR',
'10',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_kam_ja',
'soll',
'soll',
'',
'DOUBLE',
'17',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_kam_ja',
'reste',
'reste',
'',
'DOUBLE',
'17',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_kam_ja',
'haushaltsvorgriff',
'haushaltsvorgriff',
'',
'DOUBLE',
'17',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_kam_ja',
'ist',
'ist',
'',
'DOUBLE',
'17',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_kam_ja',
'erlaeuterung',
'erlaeuterung',
'',
'TEXT',
'2147483647',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_kam_ja',
'datum',
'Datum der Erzeugung',
'Dieses Feld wird zur Archivierung von gelieferten Daten genutzt',
'DATE',
'',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_kam_quartal',
'hs_nr',
'Hochschulnummer',
'',
'INTEGER',
'',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_kam_quartal',
'jahr',
'jahr',
'',
'SMALLINT',
'',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_kam_quartal',
'dr',
'dr',
'',
'VARCHAR',
'50',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_kam_quartal',
'titel',
'titel',
'',
'CHAR',
'10',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_kam_quartal',
'soll',
'soll',
'',
'DOUBLE',
'17',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_kam_quartal',
'reste',
'reste',
'',
'DOUBLE',
'17',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_kam_quartal',
'haushaltsvorgriff',
'haushaltsvorgriff',
'',
'DOUBLE',
'17',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_kam_quartal',
'istq1',
'istq1',
'',
'DOUBLE',
'17',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_kam_quartal',
'istq2',
'istq2',
'',
'DOUBLE',
'17',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_kam_quartal',
'istq3',
'istq3',
'',
'DOUBLE',
'17',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_kam_quartal',
'istq4',
'istq4',
'',
'DOUBLE',
'17',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_kam_quartal',
'istvorjahr_q1',
'istvorjahr_q1',
'',
'DOUBLE',
'17',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_kam_quartal',
'istvorjahr_q2',
'istvorjahr_q2',
'',
'DOUBLE',
'17',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_kam_quartal',
'istvorjahr_q3',
'istvorjahr_q3',
'',
'DOUBLE',
'17',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_kam_quartal',
'istvorjahr_q4',
'istvorjahr_q4',
'',
'DOUBLE',
'17',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_kam_quartal',
'vorschau',
'vorschau',
'',
'DOUBLE',
'17',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_kam_quartal',
'erlaeuterung',
'erlaeuterung',
'',
'TEXT',
'2147483647',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_kam_quartal',
'datum',
'Datum der Erzeugung',
'Dieses Feld wird zur Archivierung von gelieferten Daten genutzt',
'DATE',
'',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_kam_quartal',
'quartal',
'Quartal der Lieferung',
'',
'SMALLINT',
'',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_katalog',
'tid',
'Tupelidentifier',
'',
'SERIAL',
'4',
1,
1,
0,
0);

update tmp_fields set is_primarykey=1 
where trim(table_name) || '_' || trim(name) ='kenn_katalog_tid';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_katalog',
'id',
'ID der Kennzahl',
'',
'CHAR',
'100',
1,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_katalog',
'name',
'Name der Kennzahl',
'',
'CHAR',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_katalog',
'beschreibung',
'Beschreibung der Kennzahl',
'',
'TEXT',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_katalog',
'quelltabelle',
'Datenquelle',
'',
'CHAR',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_katalog',
'quellfeld',
'Feld (SQL-Ausdruck)',
'',
'CHAR',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_katalog',
'bedingung',
'Where-Bedingung (SQL-Ausdruck)',
'',
'TEXT',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_katalog',
'stichtagsart',
'Art des Stichtags',
'Studierendenstat./Prfungsstat./Haushalt etc.',
'CHAR',
'100',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_katalog',
'bezugsart',
'Art des Zeitbezugs',
'Jahr/Quartal/Semester.',
'CHAR',
'1',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_katalog',
'zeitfeld',
'Name des Zeitfeldes',
'in der Quelltabelle, z.B. jahr, semester',
'CHAR',
'40',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_katalog',
'einheit',
'Einheit des Ergebnisses der Kennahl',
'z.B. EUR wenn das Feld einen Geldbetrag darstellt.',
'VARCHAR',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_katalog',
'bezugszeit_wert',
'Bezugszeit Wert',
'z.B. Akad. Jahr aus Semester, oder bei Vorjahren',
'SMALLINT',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_katalog',
'bezugszeit_art',
'Bezugszeit Art',
'Jahr/Quartal/Semester.',
'CHAR',
'1',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_katalog',
'bezugszeit_diff',
'Bezugszeit Differenz',
'z.B. bei Vorjahren -1',
'VARCHAR',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_katalog',
'gueltig_von',
'gueltig_von',
'',
'DATE',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_katalog',
'gueltig_bis',
'gueltig_bis',
'',
'DATE',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_katalog_grp',
'tid',
'Tupelidentifier',
'',
'SERIAL',
'4',
1,
1,
0,
0);

update tmp_fields set is_primarykey=1 
where trim(table_name) || '_' || trim(name) ='kenn_katalog_grp_tid';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_katalog_grp',
'report_id',
'ID des Reports',
'',
'CHAR',
'40',
1,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_katalog_grp',
'id',
'ID der Gruppe',
'',
'CHAR',
'40',
1,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_katalog_grp',
'uniquename',
'Schlssel der Gruppe im Bericht',
'',
'VARCHAR',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_katalog_grp',
'name',
'Name der Gruppe',
'',
'VARCHAR',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_katalog_grp',
'beschreibung',
'Beschreibung der Kennzahl',
'Wenn dieses Feld gefllt ist, wird dieser Text, nicht der Beschreibungstext der Kennzahl angezeigt.',
'TEXT',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_katalog_grp',
'parent_id',
'ID der Gruppe',
'',
'CHAR',
'40',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_katalog_grp',
'ord_nr',
'Reihenfolge der Kennzahl',
'',
'SMALLINT',
'40',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_katalog_rpt',
'tid',
'Tupelidentifier',
'',
'SERIAL',
'4',
1,
1,
0,
0);

update tmp_fields set is_primarykey=1 
where trim(table_name) || '_' || trim(name) ='kenn_katalog_rpt_tid';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_katalog_rpt',
'katalog_id',
'ID der Kennzahl',
'',
'CHAR',
'100',
1,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_katalog_rpt',
'report_id',
'ID des Reports',
'',
'CHAR',
'40',
1,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_katalog_rpt',
'beschreibung',
'Beschreibung der Kennzahl',
'Wenn dieses Feld gefllt ist, wird dieser Text, nicht der Beschreibungstext der Kennzahl angezeigt.',
'TEXT',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_katalog_rpt',
'ord_nr',
'Reihenfolge der Kennzahl',
'',
'SMALLINT',
'40',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_katalog_rpt',
'gruppe_1',
'Gruppierungsebene 1 der Kennzahl',
'',
'CHAR',
'40',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_katalog_rpt',
'gruppe_2',
'Gruppierungsebene 2 der Kennzahl',
'',
'CHAR',
'40',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_katalog_rpt',
'ebene',
'Ebene der Kennzahl',
'1=oberste Ebene, 2=Berechnungsgrundlage fr 1 etc',
'SMALLINT',
'40',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_katalog_rpt',
'parent_katalog_id',
'bergeordnete Kennzahl (ID)',
'',
'CHAR',
'100',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_katalog_rpt',
'active',
'Aktiv',
'1=ja, 0=nein, 2=aktiv, aber unsichtbar',
'smallint',
'',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_katalog_rpt',
'uniquename',
'Schlssel der Kennzahl im Bericht',
'',
'VARCHAR',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_katalog_sub',
'tid',
'Tupelidentifier',
'',
'SERIAL',
'4',
1,
1,
0,
0);

update tmp_fields set is_primarykey=1 
where trim(table_name) || '_' || trim(name) ='kenn_katalog_sub_tid';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_katalog_sub',
'report_id',
'ID des Reports',
'',
'CHAR',
'40',
1,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_katalog_sub',
'katalog_id',
'ID der Kennzahl',
'',
'CHAR',
'100',
1,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_katalog_sub',
'sub_caption',
'Differenzierung Name',
'',
'VARCHAR',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_katalog_sub',
'sub_key_col',
'Differenzierung Spaltenname',
'',
'VARCHAR',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_katalog_sub',
'sub_lookup_table',
'Differenzierung Lookup-Tabelle',
'',
'VARCHAR',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_katalog_sub',
'sub_lookup_key',
'Differenzierung Lookup-Tabelle key-Spalte',
'',
'VARCHAR',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_katalog_sub',
'sub_lookup_name',
'Differenzierung  Lookup-Tabelle Name-Spalte',
'',
'VARCHAR',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_katalog_sub',
'sub_lookup_whereclause',
'Differenzierung whereclause Lookup-Tabelle',
'',
'VARCHAR',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_katalog_sub',
'sub_lookup_snowflake',
'Differenzierung weitere Lookup-Tabellen',
'',
'TEXT',
'32255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_katalog_sub',
'ord_nr',
'Reihenfolge der Kennzahl',
'',
'SMALLINT',
'40',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_kennz_aggr',
'hs_nr',
'hs_nr',
'',
'INTEGER',
'10',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_kennz_aggr',
'report_id',
'ID des Reports',
'',
'CHAR',
'40',
1,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_kennz_aggr',
'katalog_id',
'katalog_id',
'',
'CHAR',
'100',
1,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_kennz_aggr',
'parent_katalog_id',
'parent_katalog_id',
'',
'CHAR',
'100',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_kennz_aggr',
'katalog_id_beschreibung',
'katalog_id_beschreibung',
'',
'TEXT',
'2147483647',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_kennz_aggr',
'hochschulart',
'hochschulart',
'',
'CHAR',
'10',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_kennz_aggr',
'zeitraum_int',
'zeitraum_int',
'',
'INTEGER',
'10',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_kennz_aggr',
'bezugszeit',
'bezugszeit',
'',
'INTEGER',
'10',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_kennz_aggr',
'bezugsart',
'bezugsart',
'',
'CHAR',
'1',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_kennz_aggr',
'ebene',
'ebene',
'',
'SMALLINT',
'5',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_kennz_aggr',
'ord_nr',
'ord_nr',
'',
'SMALLINT',
'5',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_kennz_aggr',
'ord_nr_2',
'ord_nr_2',
'',
'SMALLINT',
'5',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_kennz_aggr',
'is_sub',
'is_sub',
'',
'SMALLINT',
'5',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_kennz_aggr',
'sub_1_caption',
'sub_1_caption',
'',
'VARCHAR',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_kennz_aggr',
'sub_1_key',
'sub_1_key',
'',
'VARCHAR',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_kennz_aggr',
'sub_1_name',
'sub_1_name',
'',
'VARCHAR',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_kennz_aggr',
'sub_2_caption',
'sub_2_caption',
'',
'VARCHAR',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_kennz_aggr',
'sub_2_key',
'sub_2_key',
'',
'VARCHAR',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_kennz_aggr',
'sub_2_name',
'sub_2_name',
'',
'VARCHAR',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_kennz_aggr',
'betrag',
'betrag',
'',
'DOUBLE',
'17',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_kennz_aggr',
'einheit',
'einheit',
'',
'CHAR',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_konto_aggr',
'hs_nr',
'Hochschulnummer',
'',
'INTEGER',
'4',
0,
1,
0,
0);

update tmp_fields set foreignkey_cond='fikrkey=kenn_fikr.key'
where trim(table_name) || '_' || trim(name) ='kenn_konto_aggr_hs_nr'
and trim(foreignkey_tab) = 'kenn_fikr';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_konto_aggr',
'jahr',
'Jahr der Buchung',
'',
'SMALLINT',
'2',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_konto_aggr',
'quartal',
'Quartal der Buchung',
'1-4',
'INTEGER',
'2',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_konto_aggr',
'monat',
'Monat der Buchung',
'1-12',
'SMALLINT',
'2',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='dim_kenn_monat',
foreignkey_col='monat',
foreignkey_cap='name',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_konto_aggr_monat';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_konto_aggr',
'kapitel',
'Kapitel',
'',
'CHAR',
'5',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_konto_aggr',
'dr',
'Titelgruppe (nur gefllt wenn Konstante KENN_KAMERAL_ERWEITERT=1)',
'',
'CHAR',
'5',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_konto_aggr',
'titel',
'Titel',
'',
'CHAR',
'10',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_konto_aggr',
'fikrkey',
'Kostenart gem.BVKR',
'',
'CHAR',
'12',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_fikr',
foreignkey_col='key',
foreignkey_cap='lbez',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_konto_aggr_fikrkey';

update tmp_fields set foreignkey_cond='hs_nr=kenn_fikr.hs_nr'
where trim(table_name) || '_' || trim(name) ='kenn_konto_aggr_fikrkey'
and trim(foreignkey_tab) = 'kenn_fikr';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_konto_aggr',
'klr_geldgeber',
'Geldgeber nach KLR (Drittm.,Fremdkap.,HH)',
'In BaWue werden die dreistelligen Schlssel 110,190,210,290,300-311 geliefert.',
'CHAR',
'10',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_gege',
foreignkey_col='apnr',
foreignkey_cap='druck',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_konto_aggr_klr_geldgeber';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_konto_aggr',
'betragsart',
'Art des Betrages',
'BaWue:H=Haushaltsansatz laut FIN,A=Ausgabe,E=Einnahme,L=Haushaltsmittel laut Ladenshaushaltsrechnung, R=Vorjahresreste. Sachsen: S=aktuelles Soll, W=HHAns Titel, X=Ausgaben, Y=Einnahmen, Z=Reste,B=Einnahmen aus Weiterbildungsangeboten,(speziell fr zHEB F',
'CHAR',
'1',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_konto_aggr',
'bund_fachgebiet',
'Fachgebiet ',
'(aus zugewiesener Institution)',
'CHAR',
'10',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_lfb_fg',
foreignkey_col='apnr',
foreignkey_cap='name',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_konto_aggr_bund_fachgebiet';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_konto_aggr',
'datum',
'Datum der Erzeugung',
'Dieses Feld wird zur Archivierung von gelieferten Daten genutzt',
'date',
'4',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_konto_aggr',
'betrag',
'Betrag in EUR',
'Achtung: Ausgaben haben positives Vorzeichen',
'DOUBLE',
'4',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_konto_aggr',
'extkost',
'Externe Kostenstelle',
'Nummer der Fakultt (nur Sachsen)',
'CHAR',
'30',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_konto_aggr',
'extkotr',
'Externer Produktschlssel',
'Nummer des externen Produktschlssels (nur Sachsen)',
'CHAR',
'30',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_konto_aggr',
'kfmkam',
'Kaufm./Kameral berechnet',
'1=kameral, 2=kaufmnnisch (nur Sachsen)',
'SMALLINT',
'30',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_kzfa',
'astat',
'astat',
'Schlssel',
'CHAR',
'10',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_kzfa',
'kurz',
'kurz',
'Kurzbeschreibung',
'CHAR',
'10',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_kzfa',
'druck',
'druck',
'Ausdruck',
'CHAR',
'150',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_kzfa',
'tid',
'Laufnummer',
'',
'SERIAL',
'4',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_kzfach_int',
'hs_nr',
'Hochschulnummer',
'',
'INTEGER',
'4',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_kzfach_int',
'apnr',
'Fachkennzeichen (intern)',
'Schlssel Fachkennzeichen',
'CHAR',
'10',
1,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_kzfach_int',
'druck',
'Fachkennzeichenbezeichnung',
'Drucktext',
'VARCHAR',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_kzfach_int',
'datum',
'Datum der Erzeugung',
'Dieses Feld wird zur Archivierung von gelieferten Daten genutzt',
'date',
'4',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_aggr_astat',
'hs_nr',
'Hochschule',
'Hochschulnummer',
'INTEGER',
'4',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_hochschulen',
foreignkey_col='hs_nr',
foreignkey_cap='name',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_lab_aggr_astat_hs_nr';

update tmp_fields set foreignkey_cond='stort=kenn_stort.apnr'
where trim(table_name) || '_' || trim(name) ='kenn_lab_aggr_astat_hs_nr'
and trim(foreignkey_tab) = 'kenn_stort';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_aggr_astat',
'studiengang_nr',
'Studiengang-Nummer',
'z.B. 2 fr 2. Studiengang',
'SMALLINT',
'2',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_aggr_astat',
'fach_nr',
'Fach-Nummer',
'z.B. 2 fr 2. Fach',
'SMALLINT',
'2',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_aggr_astat',
'geschlecht',
'Geschlecht',
'1 mnnl.,2 weibl.',
'SMALLINT',
'2',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_geschl',
foreignkey_col='apnr',
foreignkey_cap='druck',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_lab_aggr_astat_geschlecht';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_aggr_astat',
'ca12_staat',
'Nationalitt',
'',
'SMALLINT',
'2',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_staat',
foreignkey_col='astat',
foreignkey_cap='druck',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_lab_aggr_astat_ca12_staat';

update tmp_fields set foreignkey_func='val'
where trim(table_name) || '_' || trim(name) ='kenn_lab_aggr_astat_ca12_staat';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_aggr_astat',
'sem_der_pruefung',
'Semester',
'Schlssel, siehe Tab. kenn_semester',
'SMALLINT',
'2',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_semester',
foreignkey_col='tid',
foreignkey_cap='druck',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_lab_aggr_astat_sem_der_pruefung';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_aggr_astat',
'stg',
'Fach (amtlich)',
'',
'CHAR',
'4',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_stg_astat',
foreignkey_col='astat',
foreignkey_cap='dtxt',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_lab_aggr_astat_stg';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_aggr_astat',
'abschluss',
'Abschluss (amtlich)',
'',
'CHAR',
'2',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_abschl_astat',
foreignkey_col='astat',
foreignkey_cap='dtxt',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_lab_aggr_astat_abschluss';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_aggr_astat',
'fgr',
'Fchergruppe',
'',
'CHAR',
'10',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_dim_fgr',
foreignkey_col='apnr',
foreignkey_cap='drucktext',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_lab_aggr_astat_fgr';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_aggr_astat',
'abgrp',
'Abschlussart',
'Bachelor, Master, Sonstige',
'CHAR',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_aggr_astat',
'regel',
'Regelstudienzeit',
'',
'SMALLINT',
'2',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_aggr_astat',
'fach_sem_zahl',
'Anzahl Fachsemester',
'',
'SMALLINT',
'2',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_aggr_astat',
'hzbart_astat',
'Hochschulzugangsberechtigung Art',
'Hochschulzugangsberechtigung (amtlich)',
'CHAR',
'10',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_hzbart_astat_akt',
foreignkey_col='apnr',
foreignkey_cap='druck',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_lab_aggr_astat_hzbart_astat';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_aggr_astat',
'hzbkfzkz',
'Hochschulzugangsberechtigung Land',
'Bundesland der Hochschulzugangsberechtigung (amtlich), bei Ausland 99. ef119 Stelle 1 und 2',
'CHAR',
'2',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_aggr_astat',
'stort',
'Standort',
'Hochschulstandort (amtlich)',
'CHAR',
'10',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_stort',
foreignkey_col='apnr',
foreignkey_cap='druck',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_lab_aggr_astat_stort';

update tmp_fields set foreignkey_cond='hs_nr=kenn_stort.hs_nr'
where trim(table_name) || '_' || trim(name) ='kenn_lab_aggr_astat_stort'
and trim(foreignkey_tab) = 'kenn_stort';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_aggr_astat',
'stufrm',
'Studienform (amtlich)',
'Studienform (amtlich)',
'CHAR',
'10',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_stufrm',
foreignkey_col='apnr',
foreignkey_cap='druck',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_lab_aggr_astat_stufrm';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_aggr_astat',
'pruefung_monat',
'Monat der Prfung',
'',
'SMALLINT',
'2',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_aggr_astat',
'pruefung_jahr',
'Jahr der Prfung',
'',
'SMALLINT',
'2',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_aggr_astat',
'pruefung_ergebnis',
'Prfungsergebnis',
'Erfolgreich=1,endgltig nicht bestanden=2',
'SMALLINT',
'2',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_aggr_astat',
'ausland',
'Studienbezogene Auslandsaufenthalte',
'1=ja, 0=nein',
'SMALLINT',
'2',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_aggr_astat',
'datum',
'Datum der Erzeugung',
'Dieses Feld wird zur Archivierung von gelieferten Daten genutzt',
'date',
'4',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_aggr_astat',
'summe',
'Summe',
'',
'INTEGER',
'4',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_aggr_astat',
'stg_land',
'Fach Land (amtlich)',
'',
'CHAR',
'4',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='k_astat_studienfach_land_l',
foreignkey_col='schluessel',
foreignkey_cap='name',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_lab_aggr_astat_stg_land';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'hs_nr',
'Hochschulnummer',
'',
'INTEGER',
'',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'semester',
'Semester',
'',
'integer',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'matrikel_nr',
'Matrikelnr.',
'',
'integer',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef001',
'ef001-Berichtsland 01 = Schleswig-Holstein . . . 16 = Thringen',
'             Berichtsland             01 = Schleswig-Holstein             .             .             .             16 = Thringen           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef002',
'ef002-Berichtssemester 1 = Sommersemester 2 = Wintersemester',
'             Berichtssemester             1 = Sommersemester             2 = Wintersemester           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef003',
'ef003-Berichtsjahr',
'Berichtsjahr',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef004',
'ef004-Hochschulstandort',
'Hochschulstandort',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef005',
'ef005-Paginiernummer',
'Paginiernummer',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef006',
'ef006-Matrikelnummer',
'Matrikelnummer',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef007',
'ef007-Geschlecht 1 = mnnlich 2 = weiblich',
'             Geschlecht             1 = mnnlich             2 = weiblich           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef008u1',
'ef008u1-Geburtsdatum - Tag',
'Geburtsdatum - Tag',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef008u2',
'ef008u2-Geburtsdatum - Monat',
'Geburtsdatum - Monat',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef008u3',
'ef008u3-Geburtsdatum - Jahr',
'Geburtsdatum - Jahr',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef009',
'ef009-Name (Die ersten 4 Buchstaben des Vornamens',
'Name (Die ersten 4 Buchstaben des Vornamens',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef010',
'ef010-Staatsangehrigkeit',
'Staatsangehrigkeit',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef011',
'ef011-Weitere Staatsangehrigkeit',
'Weitere Staatsangehrigkeit',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef012u1',
'ef012u1-Semesterwohnsitz - Bundesland/Ausland: Bundesland bzw. "99" fr Ausland',
'Semesterwohnsitz - Bundesland/Ausland:             Bundesland bzw. "99" fr Ausland',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef012u2',
'ef012u2-Semesterwohnsitz Kreis/Staat: Kreis bei Wohnsitz in Deutschland bzw. Staat bei Wohnsitz im Ausland',
'Semesterwohnsitz Kreis/Staat:             Kreis bei Wohnsitz in Deutschland             bzw. Staat bei Wohnsitz im Ausland',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef013u1',
'ef013u1-Heimatwohnsitz - Bundesland/Ausland: Bundesland bzw. "99" fr Ausland',
'Heimatwohnsitz - Bundesland/Ausland:             Bundesland bzw. "99" fr Ausland',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef013u2',
'ef013u2-Heimatwohnsitz Kreis/Staat: Kreis bei Wohnsitz in Deutschland bzw. Staat bei Wohnsitz im Ausland',
'Heimatwohnsitz Kreis/Staat:             Kreis bei Wohnsitz in Deutschland             bzw. Staat bei Wohnsitz im Ausland',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef014',
'ef014-Hrerstatus: 1 = Haupthrer 2 = Nebenhrer/Zweithrer 3 = Studienkollegiat',
'             Hrerstatus:             1 = Haupthrer             2 = Nebenhrer/Zweithrer             3 = Studienkollegiat           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef015',
'ef015-Frei fr StL',
'Frei fr StL',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef016',
'ef016-Frei fr StL',
'Frei fr StL',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef017',
'ef017-Hochschulstandort der Ersteinschreibung',
'Hochschule der Ersteinschreibung',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef018',
'ef018-Bei Ersteinschreibung an einer Hochschule ausserhalb Deutschlands der Staat der Hochschule',
'Bei Ersteinschreibung an einer Hochschule auerhalb Deutschlands der Staat der Hochschule',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef019',
'ef019-Ersteinschreibung in Deutschland/Semester',
'             1 = Sommersemester             2 = Wintersemester           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef020',
'ef020-Jahr der Ersteinschreibung',
'Jahr der Ersteinschreibung',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef021',
'ef021-Anzahl der Hochschulsemester an deutschen Hochschulen insgesamt',
'             (einschl. Urlaubs-, Praxissemester sowie             Semester in der DDR bzw. Berlin (Ost)).           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef022',
'ef022-Urlaubssemester',
'Urlaubssemester',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef023',
'ef023-Praxissemester',
'Praxissemester',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef024',
'ef024-Semester am Studienkolleg',
'Semester am Studienkolleg',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef025',
'ef025-Anzahl der Unterbrechungssemester insgesamt',
'Anzahl der Unterbrechungssemester insgesamt',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef026',
'ef026-Art der Studienunterbrechung (Nur bei Exmatrikulation)',
'Art der Studienunterbrechung (Nur bei Exmatrikulation)',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef027',
'ef027-Frei fr StL',
'Frei fr StL',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef028',
'ef028-Art der Einschreibung/Exmatrikulation/Beurlaubung 1 = Ersteinschreibung 2 = Neueinschreibung 3 = Rckmeldung 4 = Beurlaubung 5 = Exmatrikulation 6 = frhere Exmatrikulation',
'Art der Einschreibung/Exmatrikulation/Beurlaubung             1 = Ersteinschreibung             2 = Neueinschreibung             3 = Rckmeldung             4 = Beurlaubung             5 = Exmatrikulation             6 = frhere Exmatrikulation',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef029',
'ef029-Grund der Beurlaubung/Exmatrikulation',
'Grund der Beurlaubung/Exmatrikulation',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef030',
'ef030-Art des Studiums im Berichtssemester (1. Studiengang) 1. Studium in Deutschland 1 = Prsenzstudium 2 = Fernstudium 3 = Praxissemester 2. Auslandsstudium 4 = Prsenzstudium 5 = Praxissemester',
'             Art des Studiums im Berichtssemester (1. Studiengang)             1. Studium in Deutschland             1 = Prsenzstudium             2 = Fernstudium             3 = Praxissemester             2. Auslandsstudium             4 = Prsenzstudiu',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef031',
'ef031-Voll-/Teilzeit/ Duales Studium im Berichtssemester (1. Studiengang) 1 = Vollzeit 2 = Teilzeit 3 = Duales Studium',
'Voll-/Teilzeit/ Duales Studium im Berichtssemester (1. Studiengang)             1 = Vollzeit             2 = Teilzeit             3 = Duales Studium',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef032',
'ef032-Anzahl der Fachsemester im Hinblick auf die angestrebte Abschlussprfung im Berichtssemester (1. Studiengang)',
'             Anzahl der Fachsemester im Hinblick auf die angestrebte Abschlussprfung             im Berichtssemester (1. Studiengang)           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef033u1',
'ef033u1-Angestrebte Abschlussprfung im Berichtssemester (1. Studiengang)-Studienform',
'Angestrebte Abschlussprfung im Berichtssemester (1. Studiengang)-Studienform',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef033u2',
'ef033u2-Angestrebte Abschlussprfung im Berichtssemester (1. Studiengang)-Abschluss',
'Angestrebte Abschlussprfung im Berichtssemester (1. Studiengang)-Studienform',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef034u1',
'ef034u1-Ort der angestrebten Abschlussprfung - Bundesland bzw. "99" fr Ausland',
'Ort der angestrebten Abschlussprfung - Bundesland bzw. "99" fr Ausland',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef034u2',
'ef034u2-Ort der angestrebten Abschlussprfung - Kreis bei Ort in Deutschland',
'Ort der angestrebten Abschlussprfung - Kreis bei Ort in Deutschland',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef035',
'ef035-Regelstudienzeit 1. Studiengang',
'Regelstudienzeit 1. Studiengang',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef036',
'ef036-1. Studienfach im Berichtssemester (1. Studiengang)',
'1. Studienfach im Berichtssemester (1. Studiengang)',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef037',
'ef037-2. Studienfach im Berichtssemester (1. Studiengang)',
'2. Studienfach im Berichtssemester (1. Studiengang)',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef038',
'ef038-Frei fr StL',
'Frei fr StL',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef039',
'ef039-3. Studienfach im Berichtssemester (1. Studiengang)',
'3. Studienfach im Berichtssemester (1. Studiengang)',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef040',
'ef040-Frei fr StL',
'Frei fr StL',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef041',
'ef041-Frei fr StL',
'Frei fr StL',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef042',
'ef042-Frei fr StL',
'Frei fr StL',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef043',
'ef043-Frei fr StL',
'Frei fr StL',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef044',
'ef044-Art der Einschreibung/Exmatrikulation/Beurlaubung 1 = Ersteinschreibung 2 = Neueinschreibung 3 = Rckmeldung 4 = Beurlaubung 5 = Exmatrikulation 6 = frhere Exmatrikulation',
'Art der Einschreibung/Exmatrikulation/Beurlaubung             1 = Ersteinschreibung             2 = Neueinschreibung             3 = Rckmeldung             4 = Beurlaubung             5 = Exmatrikulation             6 = frhere Exmatrikulation',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef045',
'ef045-Grund der Beurlaubung/Exmatrikulation',
'Grund der Beurlaubung/Exmatrikulation',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef046',
'ef046-Art des Studiums im Berichtssemester (2. Studiengang) 1. Studium in Deutschland 1 = Prsenzstudium 2 = Fernstudium 3 = Praxissemester 2. Auslandsstudium 4 = Prsenzstudium 5 = Praxissemester',
'             Art des Studiums im Berichtssemester (2. Studiengang)             1. Studium in Deutschland             1 = Prsenzstudium             2 = Fernstudium             3 = Praxissemester             2. Auslandsstudium             4 = Prsenzstudiu',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef047',
'ef047-Voll-/Teilzeit/ Duales Studium im Berichtssemester (2. Studiengang) 1 = Vollzeit 2 = Teilzeit 3 = Duales Studium',
'Voll-/Teilzeit/ Duales Studium im Berichtssemester (2. Studiengang)             1 = Vollzeit             2 = Teilzeit             3 = Duales Studium',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef048',
'ef048-Anzahl der Fachsemester im Hinblick auf die angestrebte Abschlussprfung im Berichtssemester (2. Studiengang)',
'             Anzahl der Fachsemester im Hinblick auf die angestrebte Abschlussprfung             im Berichtssemester (2. Studiengang)           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef049u1',
'ef049u1-Angestrebte Abschlussprfung im Berichtssemester (1. Studiengang)-Studienform',
'Angestrebte Abschlussprfung im Berichtssemester (2. Studiengang)-Studienform',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef049u2',
'ef049u2-Angestrebte Abschlussprfung im Berichtssemester (1. Studiengang)-Abschluss',
'Angestrebte Abschlussprfung im Berichtssemester (2. Studiengang)-Studienform',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef050u1',
'ef050u1-Ort der angestrebten Abschlussprfung - Bundesland bzw. "99" fr Ausland (2. Studiengang)',
'Ort der angestrebten Abschlussprfung - Bundesland bzw. "99" fr Ausland (2. Studiengang)',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef050u2',
'ef050u2-Ort der angestrebten Abschlussprfung - Kreis bei Ort in Deutschland (2. Studiengang)',
'Ort der angestrebten Abschlussprfung - Kreis bei Ort in Deutschland (2. Studiengang)',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef051',
'ef051-Regelstudienzeit 2. Studiengang',
'Regelstudienzeit 2. Studiengang',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef052',
'ef052-1. Studienfach im Berichtssemester (2. Studiengang)',
'1. Studienfach im Berichtssemester (2. Studiengang)',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef053',
'ef053-2. Studienfach im Berichtssemester (2. Studiengang)',
'2. Studienfach im Berichtssemester (2. Studiengang)',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef054',
'ef054-Frei fr StL',
'Frei fr StL',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef055',
'ef055-3. Studienfach im Berichtssemester (2. Studiengang)',
'3. Studienfach im Berichtssemester (2. Studiengang)',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef056',
'ef056-Frei fr StL',
'Frei fr StL',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef057',
'ef057-Frei fr StL',
'Frei fr StL',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef058',
'ef058-Frei fr StL',
'Frei fr StL',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef059',
'ef059-Frei fr StL',
'Frei fr StL',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef060',
'ef060-Einschreibung an einer anderen Hochschule - Hochschulstandort',
'Einschreibung an einer anderen Hochschule - Hochschulstandort',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef061',
'ef061-Einschreibung an einer anderen Hochschule - Bei Einschreibung an einer Hochschule ausserhalb Deutschlands der Staat der Hochschule',
'Einschreibung an einer anderen Hochschule - Bei Einschreibung an einer Hochschule auerhalb Deutschlands der Staat der Hochschule',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef062',
'ef062-Angestrebte Abschlussprfung, bei Einschreibung an einer anderen Hochschule im Berichtssemester.',
'             Angestrebte Abschlussprfung, bei Einschreibung an             einer anderen Hochschule im Berichtssemester.           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef063',
'ef063-1. Studienfach, bei Einschreibung an einer anderen Hochschule im Berichtssemester.',
'             1. Studienfach, bei Einschreibung an einer             anderen Hochschule im Berichtssemester.           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef064',
'ef064-2. Studienfach, bei Einschreibung an einer anderen Hochschule im Berichtssemester.',
'             2. Studienfach, bei Einschreibung an einer             anderen Hochschule im Berichtssemester.           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef065',
'ef065-3. Studienfach, bei Einschreibung an einer anderen Hochschule im Berichtssemester.',
'             3. Studienfach, bei Einschreibung an einer             anderen Hochschule im Berichtssemester.           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef066',
'ef066-Frei fr StL',
'Frei fr StL',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef067',
'ef067-Frei fr StL',
'Frei fr StL',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef068',
'ef068-Frei fr StL',
'Frei fr StL',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef069',
'ef069-Kennziffer fr jetzige oder andere Hochschule 1 = jetzige Hochschule 2 = andere Hochschule in Deutschland 3 = Hochschule im Ausland 4 = jetzige und weitere Hochschulen',
'             Kennziffer fr jetzige oder andere Hochschule             1 = jetzige Hochschule             2 = andere Hochschule in Deutschland             3 = Hochschule im Ausland             4 = jetzige und weitere Hochschulen           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef070',
'ef070-Studiengang gleich dem Berichtssemster?',
'Studiengang gleich dem Berichtssemster?',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef071',
'ef071-Hochschulstandort',
'Hochschulstandort',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef072',
'ef072-Wenn Hochschule im vorhergehenden Semester ausserhalb Deutschlands der Staat der Hochschule',
'Wenn Hochschule im vorhergehenden Semester auerhalb Deutschlands der Staat der Hochschule',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef073',
'ef073-Angestrebte Abschlussprfung beim Studium im vorhergehenden Semester, nur Studium in Deutschland (1. Studiengang).',
'             Angestrebte Abschlussprfung beim Studium im vorhergehenden Semester,             nur Studium in Deutschland (1. Studiengang).           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef074',
'ef074-1. Studienfach beim Studium im vorhergehenden Semester, nur Studium in Deutschland (1. Studiengang).',
'1. Studienfach beim Studium im vorhergehenden Semester, nur Studium in Deutschland (1. Studiengang).',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef075',
'ef075-2. Studienfach beim Studium im vorhergehenden Semester, nur Studium in Deutschland (1. Studiengang).',
'             2. Studienfach beim Studium im vorhergehenden Semester,             nur Studium in Deutschland (1. Studiengang).           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef076',
'ef076-3. Studienfach beim Studium im vorhergehenden Semester, nur Studium in Deutschland (1. Studiengang).',
'             3. Studienfach beim Studium im vorhergehenden Semester,             nur Studium in Deutschland (1. Studiengang).           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef077',
'ef077-Frei fr StL',
'Frei fr StL',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef078',
'ef078-Frei fr StL',
'Frei fr StL',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef079',
'ef079-Frei fr StL',
'Frei fr StL',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef080',
'ef080-Hochschulstandort',
'Hochschulstandort',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef081',
'ef081-Wenn Hochschule im vorhergehenden Semester ausserhalb Deutschlands der Staat der Hochschule',
'Wenn Hochschule im vorhergehenden Semester auerhalb Deutschlands der Staat der Hochschule',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef082',
'ef082-Angestrebte Abschlussprfung beim Studium im vorhergehenden Semester, nur Studium in Deutschland (2. Studiengang).',
'             Angestrebte Abschlussprfung beim Studium im vorhergehenden Semester,             nur Studium in Deutschland (2. Studiengang).           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef083',
'ef083-1. Studienfach beim Studium im vorhergehenden Semester, nur Studium in Deutschland (2. Studiengang).',
'             1. Studienfach beim Studium im vorhergehenden Semester,             nur Studium in Deutschland (2. Studiengang).           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef084',
'ef084-2. Studienfach beim Studium im vorhergehenden Semester, nur Studium in Deutschland (2. Studiengang).',
'             2. Studienfach beim Studium im vorhergehenden Semester,             nur Studium in Deutschland (2. Studiengang).           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef085',
'ef085-3. Studienfach beim Studium im vorhergehenden Semester, nur Studium in Deutschland (2. Studiengang).',
'             3. Studienfach beim Studium im vorhergehenden Semester,             nur Studium in Deutschland (2. Studiengang).           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef086',
'ef086-Frei fr StL',
'Frei fr StL',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef087',
'ef087-Frei fr StL',
'Frei fr StL',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef088',
'ef088-Frei fr StL',
'Frei fr StL',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef089',
'ef089-Hochschulstandort',
'Hochschulstandort',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef090',
'ef090-Wenn Hochschule einer bereits abgelegten Abschlussprfung auerhalb Deutschlands der Staat der Hochschule',
'Wenn Hochschule einer bereits abgelegten Abschlussprfung auerhalb Deutschlands der Staat der Hochschule',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef091',
'ef091-Art der Prfung bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (letzte Prfung).',
'             Art der Prfung bei  bereits vor dem Berichtssemester             abgelegten Abschlussprfungen an Hochschulen             (letzte Prfung).           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef092',
'ef092-1. Studienfach bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (letzte Prfung).',
'             1. Studienfach bei  bereits vor dem Berichtssemester             abgelegten Abschlussprfungen an Hochschulen             (letzte Prfung).           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef093',
'ef093-2. Studienfach bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (letzte Prfung).',
'             2. Studienfach bei  bereits vor dem Berichtssemester             abgelegten Abschlussprfungen an Hochschulen             (letzte Prfung).           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef094',
'ef094-3. Studienfach bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (letzte Prfung).',
'             3. Studienfach bei  bereits vor dem Berichtssemester             abgelegten Abschlussprfungen an Hochschulen             (letzte Prfung).           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef095',
'ef095-Monat des Prfnugsabschlusses bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (letzte Prfung).',
'             Monat des Prfungsabschlusses             bei  bereits vor dem Berichtssemester             abgelegten Abschlussprfungen an Hochschulen             (letzte Prfung).           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef096',
'ef096-Jahr des Prfungsabschlusses bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (letzte Prfung).',
'             Jahr des Prfungsabschlusses             bei  bereits vor dem Berichtssemester             abgelegten Abschlussprfungen an Hochschulen             (letzte Prfung).           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef097',
'ef097-Prfungsergebnis bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (letzte Prfung). 1 = insgesamt bestanden 2 = endgltig nicht bestanden',
'             Prfungsergebnis bei  bereits vor dem Berichtssemester             abgelegten Abschlussprfungen an Hochschulen             (letzte Prfung).             1 = insgesamt bestanden             2 = endgltig nicht bestanden           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef098',
'ef098-Gesamtnote bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (letzte Prfung). X,00',
'             Gesamtnote bei  bereits vor dem Berichtssemester             abgelegten Abschlussprfungen an Hochschulen             (letzte Prfung).             X,00           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef099',
'ef099-Frei fr StL',
'Frei fr StL',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef100',
'ef100-Frei fr StL',
'Frei fr StL',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef101',
'ef101-Frei fr StL',
'Frei fr StL',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef102',
'ef102-Frei fr StL',
'Frei fr StL',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef103',
'ef103-Hochschulstandort',
'Hochschulstandort (vorletzte Prfung)',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef104',
'ef104-Wenn Hochschule einer bereits abgelegten Abschlussprfung auerhalb Deutschlands der Staat der Hochschule',
'Wenn Hochschule einer bereits abgelegten Abschlussprfung auerhalb Deutschlands der Staat der Hochschule (vorletzte Prfung)',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef105',
'ef105-Art der Prfung bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (vorletzte Prfung).',
'             Art der Prfung bei  bereits vor dem Berichtssemester             abgelegten Abschlussprfungen an Hochschulen             (vorletzte Prfung).           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef106',
'ef106-1. Studienfach bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (vorletzte Prfung).',
'             1. Studienfach bei  bereits vor dem Berichtssemester             abgelegten Abschlussprfungen an Hochschulen             (vorletzte Prfung).           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef107',
'ef107-2. Studienfach bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (vorletzte Prfung).',
'             2. Studienfach bei  bereits vor dem Berichtssemester             abgelegten Abschlussprfungen an Hochschulen             (vorletzte Prfung).           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef108',
'ef108-3. Studienfach bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (vorletzte Prfung).',
'             3. Studienfach bei  bereits vor dem Berichtssemester             abgelegten Abschlussprfungen an Hochschulen             (vorletzte Prfung).           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef109',
'ef109-Monat des Prfnugsabschlusses bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (vorletzte Prfung).',
'             Monat des Prfungsabschlusses             bei  bereits vor dem Berichtssemester             abgelegten Abschlussprfungen an Hochschulen             (vorletzte Prfung).           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef110',
'ef110-Jahr des Prfungsabschlusses bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (vorletzte Prfung).',
'             Jahr des Prfungsabschlusses             bei  bereits vor dem Berichtssemester             abgelegten Abschlussprfungen an Hochschulen             (vorletzte Prfung).           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef111',
'ef111-Prfungsergebnis bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (vorletzte Prfung). 1 = insgesamt bestanden 2 = endgltig nicht bestanden',
'             Prfungsergebnis bei  bereits vor dem Berichtssemester             abgelegten Abschlussprfungen an Hochschulen             (vorletzte Prfung).             1 = insgesamt bestanden             2 = endgltig nicht bestanden           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef112',
'ef112-Gesamtnote bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (vorletzte Prfung). X,00',
'             Gesamtnote bei  bereits vor dem Berichtssemester             abgelegten Abschlussprfungen an Hochschulen             (vorletzte Prfung).             X,00           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef113',
'ef113-Frei fr StL',
'Frei fr StL',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef114',
'ef114-Frei fr StL',
'Frei fr StL',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef115',
'ef115-Frei fr StL',
'Frei fr StL',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef116',
'ef116-Frei fr StL',
'Frei fr StL',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef117',
'ef117-Jahr des ersten Erwerbs der HZB',
'Jahr des ersten Erwerbs der HZB',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef118',
'ef118-Art der HZB',
'Art der HZB',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef119u1',
'ef119u1-Erwerb der HZB Bundesland bzw. "99" fr Ausland',
'             Erwerb der HZB             Bundesland bzw. "99" fr Ausland           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef119u2',
'ef119u2-Erwerb der HZB Kreis (bei Erwerb in Deutschland) bzw. Staat (bei Erwerb im Ausland)',
'             Erwerb der HZB             Kreis (bei Erwerb in Deutschland)             bzw. Staat (bei Erwerb im Ausland)           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef120',
'ef120-Frei fr StL',
'Frei fr StL',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef121',
'ef121-Frei fr StL',
'Frei fr StL',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef122',
'ef122-Berufspraktische Ttigkeit vor dem Studium Art der Ttigkeit 1 = Berufsausbildung mit Abschluss sonst LEER',
'             Berufspraktische Ttigkeit vor dem Studium                          Art der Ttigkeit             1 = Berufsausbildung mit Abschluss             sonst LEER           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef123',
'ef123-Berufspraktische Ttigkeit vor dem Studium Art der Ttigkeit 1 = Praktikum oder Volontariat im Hinblick auf das derzeitige Studium sonst LEER',
'             Berufspraktische Ttigkeit vor dem Studium                          Art der Ttigkeit             1 = Praktikum oder Volontariat im Hinblick auf das derzeitige Studium             sonst LEER           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef124',
'ef124-Frei fr StL',
'Frei fr StL',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef125',
'ef125-Frei fr StL',
'Frei fr StL',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef126',
'ef126-Prfungsamt der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (1. Prfung)',
'             Prfungsamt der seit der letzten             Semestermeldung insgesamt             abgeschlossene Prfung(en).             (1. Prfung)           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef127',
'ef127-Anzahl der Fachsemester fr diese Prfung der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (1. Prfung)',
'             Anzahl der Fachsemester fr diese             Prfung der seit der letzten             Semestermeldung insgesamt             abgeschlossene Prfung(en).             (1. Prfung)           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef128',
'ef128-Anzahl der Fachsemester fr diese Prfung der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (1. Prfung)',
'             Anzahl der Fachsemester fr diese             Prfung der seit der letzten             Semestermeldung insgesamt             abgeschlossene Prfung(en).             (1. Prfung)                          dar.: Anzahl der angerechneten Fachseme',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef129',
'ef129-Anzahl der Fachsemester fr diese Prfung der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (1. Prfung) hier: Aus einem anderem Studiengang an einer deutschen Hochschule (einschl. Praxissemester)',
'             Anzahl der Fachsemester fr diese             Prfung der seit der letzten             Semestermeldung insgesamt             abgeschlossene Prfung(en).             (1. Prfung)                          hier: Aus einem anderem Studiengang an ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef130',
'ef130-Anzahl der Fachsemester fr diese Prfung der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (1. Prfung) hier: Berufspraktische Ttigkeit vor der Einschreibungim Studiengang der Prfung, soweit als Praxissemester bewertet',
'             Anzahl der Fachsemester fr diese             Prfung der seit der letzten             Semestermeldung insgesamt             abgeschlossene Prfung(en).             (1. Prfung)                          hier: Berufspraktische Ttigkeit vor de',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef131',
'ef131-Anzahl der Fachsemester fr diese Prfung der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (1. Prfung) hier: aus einem Auslandsstudium',
'             Anzahl der Fachsemester fr diese             Prfung der seit der letzten             Semestermeldung insgesamt             abgeschlossene Prfung(en).             (1. Prfung)                          hier: aus einem Auslandsstudium        ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef132',
'ef132-seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en) (1. Prfung) - Anzahl der fr den Studiengang anerkannten ECTS-Punkte',
'seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en) (1. Prfung) - Anzahl der fr den Studiengang anerkannten ECTS-Punkte',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef133',
'ef133-seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en) (1. Prfung) - beruflicher Qualifikationen "Darunter-Position" von EF132',
'seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en) (1. Prfung) - beruflicher Qualifikationen "Darunter-Position" von EF132',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef134',
'ef134-seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en) (1. Prfung) - im Ausland erworbenen anerkannte ECTS-Punkte',
'seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en) (1. Prfung) - im Ausland erworbenen anerkannte ECTS-Punkte',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef135',
'ef135-1. Auslandsaufenthalt 1. Prfung - Staat des Auslandsaufenthalts',
'1. Auslandsaufenthalt 1. Prfung - Staat des Auslandsaufenthalts',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef136',
'ef136-1. Auslandsaufenthalt 1. Prfung - Dauer des Aufenthaltes in Monaten',
'1. Auslandsaufenthalt 1. Prfung - Dauer des Aufenthaltes in Monaten',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef137',
'ef137-1. Auslandsaufenthalt 1. Prfung - Art des Auslandsaufenthaltes',
'1. Auslandsaufenthalt 1. Prfung - Art des Auslandsaufenthaltes',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef138',
'ef138-1. Auslandsaufenthalt 1. Prfung - Art des Mobilittsprogramm',
'1. Auslandsaufenthalt 1. Prfung - Art des Mobilittsprogramms',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef139',
'ef139-2. Auslandsaufenthalt 1. Prfung - Staat des Auslandsaufenthalts',
'2. Auslandsaufenthalt 1. Prfung - Staat des Auslandsaufenthalts',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef140',
'ef140-2. Auslandsaufenthalt 1. Prfung - Dauer des Aufenthaltes in Monaten',
'2. Auslandsaufenthalt 1. Prfung - Dauer des Aufenthaltes in Monaten',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef141',
'ef141-2. Auslandsaufenthalt 1. Prfung - Art des Auslandsaufenthaltes',
'2. Auslandsaufenthalt 1. Prfung - Art des Auslandsaufenthaltes',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef142',
'ef142-2. Auslandsaufenthalt 1. Prfung - Art des Mobilittsprogramm',
'2. Auslandsaufenthalt 1. Prfung - Art des Mobilittsprogramms',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef143',
'ef143-3. Auslandsaufenthalt 1. Prfung - Staat des Auslandsaufenthalts',
'3. Auslandsaufenthalt 1. Prfung - Staat des Auslandsaufenthalts',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef144',
'ef144-3. Auslandsaufenthalt 1. Prfung - Dauer des Aufenthaltes in Monaten',
'3. Auslandsaufenthalt 1. Prfung - Dauer des Aufenthaltes in Monaten',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef145',
'ef145-3. Auslandsaufenthalt 1. Prfung - Art des Auslandsaufenthaltes',
'3. Auslandsaufenthalt 1. Prfung - Art des Auslandsaufenthaltes',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef146',
'ef146-3. Auslandsaufenthalt 1. Prfung - Art des Mobilittsprogramm',
'3. Auslandsaufenthalt 1. Prfung - Art des Mobilittsprogramms',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef147u1',
'ef147u1-Art der Prfung der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (1. Prfung)- Studienform',
'',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef147u2',
'ef147u2-Art der Prfung der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (1. Prfung)- Abschluss',
'',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef148',
'ef148-Fr Promotionsabsolventen Art der Promotion (1. Prfung)',
'Fr Promotionsabsolventen Art der Promotion (1. Prfung)',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef149',
'ef149-Regelstudienzeit (1. Prfung)',
'Regelstudienzeit (1. Prfung)',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef150',
'ef150-1. Studienfach der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (1. Prfung)',
'             1. Studienfach der seit der letzten             Semestermeldung insgesamt             abgeschlossene Prfung(en).             (1. Prfung)           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef151',
'ef151-2. Studienfach der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (1. Prfung)',
'             2. Studienfach der seit der letzten             Semestermeldung insgesamt             abgeschlossene Prfung(en).             (1. Prfung)           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef152',
'ef152-Frei fr StL',
'Frei fr StL',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef153',
'ef153-3. Studienfach der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (1. Prfung)',
'             3. Studienfach der seit der letzten             Semestermeldung insgesamt             abgeschlossene Prfung(en).             (1. Prfung)           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef154',
'ef154-Frei fr StL',
'Frei fr StL',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef155',
'ef155-Monat des Prfungsabschlusses bei der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (1. Prfung)',
'             Monat des Prfungsabschlusses             bei der seit der letzten             Semestermeldung insgesamt             abgeschlossene Prfung(en).             (1. Prfung)           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef156',
'ef156-Jahr des Prfungsabschlusses bei der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (1. Prfung)',
'             Jahr des Prfungsabschlusses             bei der seit der letzten             Semestermeldung insgesamt             abgeschlossene Prfung(en).             (1. Prfung)           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef157',
'ef157-Prfungsergebnis bei der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (1. Prfung)',
'             Prfungsergebnis bei der seit der letzten             Semestermeldung insgesamt             abgeschlossene Prfung(en).             (1. Prfung)           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef158',
'ef158-Gesamtnote bei der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (1. Prfung) X,00',
'             Gesamtnote bei der seit der letzten             Semestermeldung insgesamt             abgeschlossene Prfung(en).             (1. Prfung)             X,00           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef159',
'ef159-Frei fr StL',
'Frei fr StL',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef160',
'ef160-Frei fr StL',
'Frei fr StL',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef161',
'ef161-Frei fr StL',
'Frei fr StL',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef162',
'ef162-Frei fr StL',
'Frei fr StL',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef163',
'ef163-Prfungsamt der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung)',
'             Prfungsamt der seit der letzten             Semestermeldung insgesamt             abgeschlossene Prfung(en).             (2. Prfung)           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef164',
'ef164-Anzahl der Fachsemester fr diese Prfung der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung)',
'             Anzahl der Fachsemester fr diese             Prfung der seit der letzten             Semestermeldung insgesamt             abgeschlossene Prfung(en).             (2. Prfung)           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef165',
'ef165-Anzahl der Fachsemester fr diese Prfung der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung)',
'             Anzahl der Fachsemester fr diese             Prfung der seit der letzten             Semestermeldung insgesamt             abgeschlossene Prfung(en).             (2. Prfung)             dar.: Anzahl der angerechneten Fachsemester insgesam',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef166',
'ef166-Anzahl der Fachsemester fr diese Prfung der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung) hier: Aus einem anderem Studiengang an einer deutschen Hochschule (einschl. Praxissemester)',
'             Anzahl der Fachsemester fr diese             Prfung der seit der letzten             Semestermeldung insgesamt             abgeschlossene Prfung(en).             (2. Prfung)                          hier: Aus einem anderem Studiengang an ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef167',
'ef167-Anzahl der Fachsemester fr diese Prfung der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung) hier: Berufspraktische Ttigkeit vor der Einschreibungim Studiengang der Prfung, soweit als Praxissemester bewertet',
'             Anzahl der Fachsemester fr diese             Prfung der seit der letzten             Semestermeldung insgesamt             abgeschlossene Prfung(en).             (2. Prfung)                          hier: Berufspraktische Ttigkeit vor de',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef168',
'ef168-Anzahl der Fachsemester fr diese Prfung der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung) hier: aus einem Auslandsstudium',
'             Anzahl der Fachsemester fr diese             Prfung der seit der letzten             Semestermeldung insgesamt             abgeschlossene Prfung(en).             (2. Prfung)                          hier: aus einem Auslandsstudium        ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef169',
'ef169-seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en) (2. Prfung) - Anzahl der fr den Studiengang anerkannten ECTS-Punkte',
'seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en) (2. Prfung) - Anzahl der fr den Studiengang anerkannten ECTS-Punkte',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef170',
'ef170-seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en) (2. Prfung) - beruflicher Qualifikationen "Darunter-Position" von EF132',
'seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en) (2. Prfung) - beruflicher Qualifikationen "Darunter-Position" von EF170',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef171',
'ef171-seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en) (2. Prfung) - im Ausland erworbenen anerkannte ECTS-Punkte',
'seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en) (2. Prfung) - im Ausland erworbenen anerkannte ECTS-Punkte',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef172',
'ef172-1. Auslandsaufenthalt 2. Prfung - Staat des Auslandsaufenthalts',
'1. Auslandsaufenthalt 2. Prfung - Staat des Auslandsaufenthalts',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef173',
'ef173-1. Auslandsaufenthalt 2. Prfung - Dauer des Aufenthaltes in Monaten',
'1. Auslandsaufenthalt 2. Prfung - Dauer des Aufenthaltes in Monaten',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef174',
'ef174-1. Auslandsaufenthalt 2. Prfung - Art des Auslandsaufenthaltes',
'1. Auslandsaufenthalt 2. Prfung - Art des Auslandsaufenthaltes',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef175',
'ef175-1. Auslandsaufenthalt 2. Prfung - Art des Mobilittsprogramm',
'1. Auslandsaufenthalt 2. Prfung - Art des Mobilittsprogramms',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef176',
'ef176-2. Auslandsaufenthalt 2. Prfung - Staat des Auslandsaufenthalts',
'2. Auslandsaufenthalt 2. Prfung - Staat des Auslandsaufenthalts',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef177',
'ef177-2. Auslandsaufenthalt 2. Prfung - Dauer des Aufenthaltes in Monaten',
'2. Auslandsaufenthalt 2. Prfung - Dauer des Aufenthaltes in Monaten',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef178',
'ef178-2. Auslandsaufenthalt 2. Prfung - Art des Auslandsaufenthaltes',
'2. Auslandsaufenthalt 2. Prfung - Art des Auslandsaufenthaltes',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef179',
'ef179-2. Auslandsaufenthalt 2. Prfung - Art des Mobilittsprogramm',
'2. Auslandsaufenthalt 2. Prfung - Art des Mobilittsprogramms',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef180',
'ef180-3. Auslandsaufenthalt 2. Prfung - Staat des Auslandsaufenthalts',
'3. Auslandsaufenthalt 2. Prfung - Staat des Auslandsaufenthalts',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef181',
'ef181-3. Auslandsaufenthalt 2. Prfung - Dauer des Aufenthaltes in Monaten',
'3. Auslandsaufenthalt 2. Prfung - Dauer des Aufenthaltes in Monaten',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef182',
'ef182-3. Auslandsaufenthalt 2. Prfung - Art des Auslandsaufenthaltes',
'3. Auslandsaufenthalt 2. Prfung - Art des Auslandsaufenthaltes',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef183',
'ef183-3. Auslandsaufenthalt 2. Prfung - Art des Mobilittsprogramm',
'3. Auslandsaufenthalt 2. Prfung - Art des Mobilittsprogramms',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef184u1',
'ef184u1-Art der Prfung der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung)-Studienform',
'             Art der Prfung der seit der letzten             Semestermeldung insgesamt             abgeschlossene Prfung(en).             (2. Prfung)-Studienform           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef184u2',
'ef184u2-Art der Prfung der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung)-Abschluss',
'             Art der Prfung der seit der letzten             Semestermeldung insgesamt             abgeschlossene Prfung(en).             (2. Prfung)-Abschluss           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef185',
'ef185-Fr Promotionsabsolventen Art der Promotion (2. Prfung)',
'Fr Promotionsabsolventen Art der Promotion (2. Prfung)',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef186',
'ef186-Regelstudienzeit (2. Prfung)',
'Regelstudienzeit (2. Prfung)',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef187',
'ef187-1. Studienfach der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung)',
'             1. Studienfach der seit der letzten             Semestermeldung insgesamt             abgeschlossene Prfung(en).             (2. Prfung)           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef188',
'ef188-2. Studienfach der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung)',
'             2. Studienfach der seit der letzten             Semestermeldung insgesamt             abgeschlossene Prfung(en).             (2. Prfung)           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef189',
'ef189-Frei fr StL',
'Frei fr StL',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef190',
'ef190-3. Studienfach der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung)',
'             3. Studienfach der seit der letzten             Semestermeldung insgesamt             abgeschlossene Prfung(en).             (2. Prfung)           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef191',
'ef191-Frei fr StL',
'Frei fr StL',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef192',
'ef192-Monat des Prfungsabschlusses bei der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung)',
'             Monat des Prfungsabschlusses             bei der seit der letzten             Semestermeldung insgesamt             abgeschlossene Prfung(en).             (2. Prfung)           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef193',
'ef193-Jahr des Prfungsabschlusses bei der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung)',
'             Jahr des Prfungsabschlusses             bei der seit der letzten             Semestermeldung insgesamt             abgeschlossene Prfung(en).             (2. Prfung)           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef194',
'ef194-Prfungsergebnis bei der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung)',
'             Prfungsergebnis bei der seit der letzten             Semestermeldung insgesamt             abgeschlossene Prfung(en).             (2. Prfung)           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef195',
'ef195-Gesamtnote bei der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung) X,00',
'             Gesamtnote bei der seit der letzten             Semestermeldung insgesamt             abgeschlossene Prfung(en).             (2. Prfung)             X,00           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef196',
'ef196-Frei fr StL',
'Frei fr StL',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef197',
'ef197-Frei fr StL',
'Frei fr StL',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef198',
'ef198-Frei fr StL',
'Frei fr StL',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'ef199',
'ef199-Frei fr StL',
'Frei fr StL',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'id',
'id',
'',
'SERIAL',
'4',
1,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat',
'importdatum',
'importdatum',
'Datum/Uhrzeit des Imports',
'DATETIME',
'3594',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat_2015',
'hs_nr',
'Hochschulnummer',
'',
'INTEGER',
'',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat_2015',
'semester',
'Semester',
'',
'integer',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat_2015',
'matrikel_nr',
'Matrikelnr.',
'',
'integer',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat_2015',
'ef001',
'ef001-Berichtsland 01 = Schleswig-Holstein . . . 16 = Thringen',
'             Berichtsland             01 = Schleswig-Holstein             .             .             .             16 = Thringen           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat_2015',
'ef002',
'ef002-Berichtssemester 1 = Sommersemester 2 = Wintersemester',
'             Berichtssemester             1 = Sommersemester             2 = Wintersemester           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat_2015',
'ef003',
'ef003-Berichtsjahr',
'Berichtsjahr',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat_2015',
'ef004',
'ef004-Hochschule',
'Hochschule',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat_2015',
'ef005',
'ef005-Paginiernummer',
'Paginiernummer',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat_2015',
'ef006',
'ef006-Matrikelnummer',
'Matrikelnummer',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat_2015',
'ef007',
'ef007-Geschlecht 1 = mnnlich 2 = weiblich',
'             Geschlecht             1 = mnnlich             2 = weiblich           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat_2015',
'ef008u1',
'ef008u1-Geburtsdatum - Monat',
'Geburtsdatum - Monat',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat_2015',
'ef008u2',
'ef008u2-Geburtsdatum - Jahr',
'Geburtsdatum - Jahr',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat_2015',
'ef009',
'ef009-Staatsangehrigkeit',
'Staatsangehrigkeit',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat_2015',
'ef010u1',
'ef010u1-Semesterwohnsitz - Bundesland/Ausland: Bundesland bzw. "99" fr Ausland',
'Semesterwohnsitz - Bundesland/Ausland:             Bundesland bzw. "99" fr Ausland',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat_2015',
'ef010u2',
'ef010u2-Semesterwohnsitz Kreis/Staat: Kreis bei Wohnsitz in Deutschland bzw. Staat bei Wohnsitz im Ausland',
'Semesterwohnsitz Kreis/Staat:             Kreis bei Wohnsitz in Deutschland             bzw. Staat bei Wohnsitz im Ausland',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat_2015',
'ef011u1',
'ef011u1-Heimatwohnsitz - Bundesland/Ausland: Bundesland bzw. "99" fr Ausland',
'Heimatwohnsitz - Bundesland/Ausland:             Bundesland bzw. "99" fr Ausland',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat_2015',
'ef011u2',
'ef011u2-Heimatwohnsitz Kreis/Staat: Kreis bei Wohnsitz in Deutschland bzw. Staat bei Wohnsitz im Ausland',
'Heimatwohnsitz Kreis/Staat:             Kreis bei Wohnsitz in Deutschland             bzw. Staat bei Wohnsitz im Ausland',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat_2015',
'ef012',
'ef012-Hrerstatus: 1 = Haupthrer 2 = Nebenhrer/Zweithrer 3 = Studienkollegiat',
'             Hrerstatus:             1 = Haupthrer             2 = Nebenhrer/Zweithrer             3 = Studienkollegiat           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat_2015',
'ef013',
'ef013-Frei fr StL',
'Frei fr StL',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat_2015',
'ef014',
'ef014-Frei fr StL',
'Frei fr StL',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat_2015',
'ef015',
'ef015-Frei fr StL',
'Frei fr StL',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat_2015',
'ef016',
'ef016-Hochschule der Ersteinschreibung',
'Hochschule der Ersteinschreibung',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat_2015',
'ef017',
'ef017-Ersteinschreibung in Deutschland/Semester',
'             1 = Sommersemester             2 = Wintersemester           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat_2015',
'ef018',
'ef018-Jahr der Ersteinschreibung',
'Jahr der Ersteinschreibung',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat_2015',
'ef019',
'ef019-Anzahl der Hochschulsemester an deutschen Hochschulen insgesamt',
'             (einschl. Urlaubs-, Praxissemester sowie             Semester in der DDR bzw. Berlin (Ost)).           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat_2015',
'ef020',
'ef020-Urlaubssemester',
'Urlaubssemester',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat_2015',
'ef021',
'ef021-Praxissemester',
'Praxissemester',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat_2015',
'ef022',
'ef022-- Semester in der DDR bzw. Berlin (Ost) (einschl. Urlaubssemester)',
'             - Semester in der DDR bzw. Berlin (Ost)             (einschl. Urlaubssemester)           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat_2015',
'ef023',
'ef023-Nur bei Studium in der DDR bzw. Berlin (Ost) Art des Studiums 1 = Prsenzstudium 2 = Fernstudium',
'             Nur bei Studium in der DDR bzw. Berlin (Ost)             Art des Studiums             1 = Prsenzstudium             2 = Fernstudium           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat_2015',
'ef024',
'ef024-Semester am Studienkolleg',
'Semester am Studienkolleg',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat_2015',
'ef025',
'ef025-Anzahl der Unterbrechungssemester insgesamt',
'Anzahl der Unterbrechungssemester insgesamt',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat_2015',
'ef026',
'ef026-Art der Einschreibung/Exmatrikulation/Beurlaubung 1 = Ersteinschreibung 2 = Neueinschreibung 3 = Rckmeldung 4 = Beurlaubung 5 = Exmatrikulation 6 = frhere Exmatrikulation',
'Art der Einschreibung/Exmatrikulation/Beurlaubung             1 = Ersteinschreibung             2 = Neueinschreibung             3 = Rckmeldung             4 = Beurlaubung             5 = Exmatrikulation             6 = frhere Exmatrikulation',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat_2015',
'ef027',
'ef027-Grund der Beurlaubung/Exmatrikulation',
'Grund der Beurlaubung/Exmatrikulation',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat_2015',
'ef028',
'ef028-Art des Studiums im Berichtssemester (1. Studiengang) 1. Studium in Deutschland 1 = Prsenzstudium 2 = Fernstudium 3 = Praxissemester 2. Auslandsstudium 4 = Prsenzstudium 5 = Praxissemester',
'             Art des Studiums im Berichtssemester (1. Studiengang)             1. Studium in Deutschland             1 = Prsenzstudium             2 = Fernstudium             3 = Praxissemester             2. Auslandsstudium             4 = Prsenzstudiu',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat_2015',
'ef029',
'ef029-Voll-/Teilzeit/ Duales Studium im Berichtssemester (1. Studiengang) 1 = Vollzeit 2 = Teilzeit 3 = Duales Studium',
'Voll-/Teilzeit/ Duales Studium im Berichtssemester (1. Studiengang)             1 = Vollzeit             2 = Teilzeit             3 = Duales Studium',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat_2015',
'ef030',
'ef030-Anzahl der Fachsemester im Hinblick auf die angestrebte Abschlussprfung im Berichtssemester (1. Studiengang)',
'             Anzahl der Fachsemester im Hinblick auf die angestrebte Abschlussprfung             im Berichtssemester (1. Studiengang)           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat_2015',
'ef031u1',
'ef031u1-Angestrebte Abschlussprfung im Berichtssemester (1. Studiengang)-Studienform',
'Angestrebte Abschlussprfung im Berichtssemester (1. Studiengang)',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat_2015',
'ef031u2',
'ef031u2-Angestrebte Abschlussprfung im Berichtssemester (1. Studiengang)-Abschluss',
'Angestrebte Abschlussprfung im Berichtssemester (1. Studiengang)',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat_2015',
'ef032',
'ef032-1. Studienfach im Berichtssemester (1. Studiengang)',
'1. Studienfach im Berichtssemester (1. Studiengang)',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat_2015',
'ef033',
'ef033-Frei fr StL',
'Frei fr StL',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat_2015',
'ef034',
'ef034-2. Studienfach im Berichtssemester (1. Studiengang)',
'2. Studienfach im Berichtssemester (1. Studiengang)',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat_2015',
'ef035',
'ef035-Frei fr StL',
'Frei fr StL',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat_2015',
'ef036',
'ef036-3. Studienfach im Berichtssemester (1. Studiengang)',
'3. Studienfach im Berichtssemester (1. Studiengang)',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat_2015',
'ef037',
'ef037-Frei fr StL',
'Frei fr StL',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat_2015',
'ef038',
'ef038-Frei fr StL',
'Frei fr StL',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat_2015',
'ef039',
'ef039-Frei fr StL',
'Frei fr StL',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat_2015',
'ef040',
'ef040-Frei fr StL',
'Frei fr StL',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat_2015',
'ef041',
'ef041-Art der Einschreibung/Exmatrikulation/Beurlaubung 1 = Ersteinschreibung 2 = Neueinschreibung 3 = Rckmeldung 4 = Beurlaubung 5 = Exmatrikulation 6 = frhere Exmatrikulation',
'Art der Einschreibung/Exmatrikulation/Beurlaubung             1 = Ersteinschreibung             2 = Neueinschreibung             3 = Rckmeldung             4 = Beurlaubung             5 = Exmatrikulation             6 = frhere Exmatrikulation',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat_2015',
'ef042',
'ef042-Grund der Beurlaubung/Exmatrikulation',
'Grund der Beurlaubung/Exmatrikulation',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat_2015',
'ef043',
'ef043-Art des Studiums im Berichtssemester (2. Studiengang) 1. Studium in Deutschland 1 = Prsenzstudium 2 = Fernstudium 3 = Praxissemester 2. Auslandsstudium 4 = Prsenzstudium 5 = Praxissemester',
'             Art des Studiums im Berichtssemester (2. Studiengang)             1. Studium in Deutschland             1 = Prsenzstudium             2 = Fernstudium             3 = Praxissemester             2. Auslandsstudium             4 = Prsenzstudiu',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat_2015',
'ef044',
'ef044-Voll-/Teilzeit/ Duales Studium im Berichtssemester (2. Studiengang) 1 = Vollzeit 2 = Teilzeit 3 = Duales Studium',
'Voll-/Teilzeit/ Duales Studium im Berichtssemester (2. Studiengang)             1 = Vollzeit             2 = Teilzeit             3 = Duales Studium',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat_2015',
'ef045',
'ef045-Anzahl der Fachsemester im Hinblick auf die angestrebte Abschlussprfung im Berichtssemester (2. Studiengang)',
'             Anzahl der Fachsemester im Hinblick auf die angestrebte Abschlussprfung             im Berichtssemester (2. Studiengang)           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat_2015',
'ef046u1',
'ef046u1-Angestrebte Abschlussprfung im Berichtssemester (2. Studiengang)-Studienform',
'Angestrebte Abschlussprfung im Berichtssemester (2. Studiengang)',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat_2015',
'ef046u2',
'ef046u2-Angestrebte Abschlussprfung im Berichtssemester (2. Studiengang)-Abschluss',
'Angestrebte Abschlussprfung im Berichtssemester (2. Studiengang)',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat_2015',
'ef047',
'ef047-1. Studienfach im Berichtssemester (2. Studiengang)',
'1. Studienfach im Berichtssemester (2. Studiengang)',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat_2015',
'ef048',
'ef048-Frei fr StL',
'Frei fr StL',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat_2015',
'ef049',
'ef049-2. Studienfach im Berichtssemester (2. Studiengang)',
'2. Studienfach im Berichtssemester (2. Studiengang)',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat_2015',
'ef050',
'ef050-Frei fr StL',
'Frei fr StL',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat_2015',
'ef051',
'ef051-3. Studienfach im Berichtssemester (2. Studiengang)',
'3. Studienfach im Berichtssemester (2. Studiengang)',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat_2015',
'ef052',
'ef052-Frei fr StL',
'Frei fr StL',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat_2015',
'ef053',
'ef053-Frei fr StL',
'Frei fr StL',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat_2015',
'ef054',
'ef054-Frei fr StL',
'Frei fr StL',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat_2015',
'ef055',
'ef055-Frei fr StL',
'Frei fr StL',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat_2015',
'ef056',
'ef056-Hochschule (bei Einschreibung an einer anderen HS im Berichtssemester)',
'Hochschule (bei Einschreibung an einer anderen HS im Berichtssemester)',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat_2015',
'ef057',
'ef057-Frei fr StL',
'Frei fr StL',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat_2015',
'ef058',
'ef058-Frei fr StL',
'Frei fr StL',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat_2015',
'ef059u1',
'ef059u1-Angestrebte Abschlussprfung, bei Einschreibung an einer anderen Hochschule im Berichtssemester-Studienform',
'             Angestrebte Abschlussprfung, bei Einschreibung an             einer anderen Hochschule im Berichtssemester.           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat_2015',
'ef059u2',
'ef059u2-Angestrebte Abschlussprfung, bei Einschreibung an einer anderen Hochschule im Berichtssemester-Abschluss',
'             Angestrebte Abschlussprfung, bei Einschreibung an             einer anderen Hochschule im Berichtssemester.           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat_2015',
'ef060',
'ef060-1. Studienfach, bei Einschreibung an einer anderen Hochschule im Berichtssemester.',
'             1. Studienfach, bei Einschreibung an einer             anderen Hochschule im Berichtssemester.           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat_2015',
'ef061',
'ef061-2. Studienfach, bei Einschreibung an einer anderen Hochschule im Berichtssemester.',
'             2. Studienfach, bei Einschreibung an einer             anderen Hochschule im Berichtssemester.           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat_2015',
'ef062',
'ef062-3. Studienfach, bei Einschreibung an einer anderen Hochschule im Berichtssemester.',
'             3. Studienfach, bei Einschreibung an einer             anderen Hochschule im Berichtssemester.           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat_2015',
'ef063',
'ef063-Frei fr StL',
'Frei fr StL',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat_2015',
'ef064',
'ef064-Kennziffer fr jetzige oder andere Hochschule 1 = jetzige Hochschule 2 = andere Hochschule in Deutschland 3 = Hochschule im Ausland 4 = jetzige und weitere Hochschulen',
'             Kennziffer fr jetzige oder andere Hochschule             1 = jetzige Hochschule             2 = andere Hochschule in Deutschland             3 = Hochschule im Ausland             4 = jetzige und weitere Hochschulen           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat_2015',
'ef065',
'ef065-Studiengang gleich dem Berichtssemster?',
'Studiengang gleich dem Berichtssemster?',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat_2015',
'ef066',
'ef066-Hochschule beim Studium im vorhergehenden Semester, nur Studium in Deutschland (1. Studiengang).',
'             Hochschule beim Studium im vorhergehenden Semester,             nur Studium in Deutschland (1. Studiengang).           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat_2015',
'ef067',
'ef067-Frei fr StL',
'Frei fr StL',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat_2015',
'ef068',
'ef068-Frei fr StL',
'Frei fr StL',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat_2015',
'ef069u2',
'ef069u2-Angestrebte Abschlussprfung beim Studium im vorhergehenden Semester, nur Studium in Deutschland (1. Studiengang)-Studienform',
'             Angestrebte Abschlussprfung beim Studium im vorhergehenden Semester,             nur Studium in Deutschland (1. Studiengang).           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat_2015',
'ef069u1',
'ef069u1-Angestrebte Abschlussprfung beim Studium im vorhergehenden Semester, nur Studium in Deutschland (1. Studiengang)-Abschluss',
'             Angestrebte Abschlussprfung beim Studium im vorhergehenden Semester,             nur Studium in Deutschland (1. Studiengang).           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat_2015',
'ef070',
'ef070-1. Studienfach beim Studium im vorhergehenden Semester, nur Studium in Deutschland (1. Studiengang).',
'             1. Studienfach beim Studium im vorhergehenden Semester,             nur Studium in Deutschland (1. Studiengang).           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat_2015',
'ef071',
'ef071-2. Studienfach beim Studium im vorhergehenden Semester, nur Studium in Deutschland (1. Studiengang).',
'             2. Studienfach beim Studium im vorhergehenden Semester,             nur Studium in Deutschland (1. Studiengang).           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat_2015',
'ef072',
'ef072-3. Studienfach beim Studium im vorhergehenden Semester, nur Studium in Deutschland (1. Studiengang).',
'             3. Studienfach beim Studium im vorhergehenden Semester,             nur Studium in Deutschland (1. Studiengang).           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat_2015',
'ef073',
'ef073-Frei fr StL',
'Frei fr StL',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat_2015',
'ef074',
'ef074-Hochschule beim Studium im vorhergehenden Semester, nur Studium in Deutschland (2. Studiengang).',
'             Hochschule beim Studium im vorhergehenden Semester,             nur Studium in Deutschland (2. Studiengang).           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat_2015',
'ef075',
'ef075-Frei fr StL',
'Frei fr StL',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat_2015',
'ef076',
'ef076-Frei fr StL',
'Frei fr StL',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat_2015',
'ef077u1',
'ef077u1-Angestrebte Abschlussprfung beim Studium im vorhergehenden Semester, nur Studium in Deutschland (2. Studiengang)-Studienform',
'             Angestrebte Abschlussprfung beim Studium im vorhergehenden Semester,             nur Studium in Deutschland (2. Studiengang).           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat_2015',
'ef077u2',
'ef077u2-Angestrebte Abschlussprfung beim Studium im vorhergehenden Semester, nur Studium in Deutschland (2. Studiengang)-Abschluss',
'             Angestrebte Abschlussprfung beim Studium im vorhergehenden Semester,             nur Studium in Deutschland (2. Studiengang).           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat_2015',
'ef078',
'ef078-1. Studienfach beim Studium im vorhergehenden Semester, nur Studium in Deutschland (2. Studiengang).',
'             1. Studienfach beim Studium im vorhergehenden Semester,             nur Studium in Deutschland (2. Studiengang).           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat_2015',
'ef079',
'ef079-2. Studienfach beim Studium im vorhergehenden Semester, nur Studium in Deutschland (2. Studiengang).',
'             2. Studienfach beim Studium im vorhergehenden Semester,             nur Studium in Deutschland (2. Studiengang).           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat_2015',
'ef080',
'ef080-3. Studienfach beim Studium im vorhergehenden Semester, nur Studium in Deutschland (2. Studiengang).',
'             3. Studienfach beim Studium im vorhergehenden Semester,             nur Studium in Deutschland (2. Studiengang).           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat_2015',
'ef081',
'ef081-Frei fr StL',
'Frei fr StL',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat_2015',
'ef082',
'ef082-1. Land (Staat) bei einem frheren - auf das jetzige Studium in Deutschland bezogene - Studium im Ausland.',
'             1. Land (Staat) bei einem frheren - auf das jetzige             Studium in Deutschland bezogene - Studium im Ausland.           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat_2015',
'ef083',
'ef083-Monate im 1. Land (Staat) bei einem frheren - auf das jetzige Studium in Deutschland bezogene - Studium im Ausland.',
'             Monate im 1. Land (Staat) bei einem frheren - auf das jetzige             Studium in Deutschland bezogene - Studium im Ausland.           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat_2015',
'ef084',
'ef084-Frei fr StL',
'Frei fr StL',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat_2015',
'ef085',
'ef085-2. Land (Staat) bei einem frheren - auf das jetzige Studium in Deutschland bezogene - Studium im Ausland.',
'             2. Land (Staat) bei einem frheren - auf das jetzige             Studium in Deutschland bezogene - Studium im Ausland.           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat_2015',
'ef086',
'ef086-Monate im 2. Land (Staat) bei einem frheren - auf das jetzige Studium in Deutschland bezogene - Studium im Ausland.',
'             Monate im 2. Land (Staat) bei einem frheren - auf das jetzige             Studium in Deutschland bezogene - Studium im Ausland.           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat_2015',
'ef087',
'ef087-Frei fr StL',
'Frei fr StL',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat_2015',
'ef088',
'ef088-Frei fr StL',
'Frei fr StL',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat_2015',
'ef089',
'ef089-Frei fr StL',
'Frei fr StL',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat_2015',
'ef090',
'ef090-Frei fr StL',
'Frei fr StL',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat_2015',
'ef091u1',
'ef091u1-Art der Prfung bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (letzte Prfung)-Studienform',
'             Art der Prfung bei  bereits vor dem Berichtssemester             abgelegten Abschlussprfungen an Hochschulen             (letzte Prfung).           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat_2015',
'ef091u2',
'ef091u2-Art der Prfung bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (letzte Prfung)-Abschluss',
'             Art der Prfung bei  bereits vor dem Berichtssemester             abgelegten Abschlussprfungen an Hochschulen             (letzte Prfung).           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat_2015',
'ef092',
'ef092-1. Studienfach bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (letzte Prfung).',
'             1. Studienfach bei  bereits vor dem Berichtssemester             abgelegten Abschlussprfungen an Hochschulen             (letzte Prfung).           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat_2015',
'ef093',
'ef093-2. Studienfach bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (letzte Prfung).',
'             2. Studienfach bei  bereits vor dem Berichtssemester             abgelegten Abschlussprfungen an Hochschulen             (letzte Prfung).           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat_2015',
'ef094',
'ef094-3. Studienfach bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (letzte Prfung).',
'             3. Studienfach bei  bereits vor dem Berichtssemester             abgelegten Abschlussprfungen an Hochschulen             (letzte Prfung).           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat_2015',
'ef095',
'ef095-Frei fr StL',
'Frei fr StL',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat_2015',
'ef096',
'ef096-Monat des Prfnugsabschlusses bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (letzte Prfung).',
'             Monat des Prfnugsabschlusses             bei  bereits vor dem Berichtssemester             abgelegten Abschlussprfungen an Hochschulen             (letzte Prfung).           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat_2015',
'ef097',
'ef097-Jahr des Prfungsabschlusses bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (letzte Prfung).',
'             Jahr des Prfungsabschlusses             bei  bereits vor dem Berichtssemester             abgelegten Abschlussprfungen an Hochschulen             (letzte Prfung).           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat_2015',
'ef098',
'ef098-Prfungsergebnis bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (letzte Prfung). 1 = insgesamt bestanden 2 = endgltig nicht bestanden',
'             Prfungsergebnis bei  bereits vor dem Berichtssemester             abgelegten Abschlussprfungen an Hochschulen             (letzte Prfung).             1 = insgesamt bestanden             2 = endgltig nicht bestanden           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat_2015',
'ef099',
'ef099-Gesamtnote bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (letzte Prfung). X,00',
'             Gesamtnote bei  bereits vor dem Berichtssemester             abgelegten Abschlussprfungen an Hochschulen             (letzte Prfung).             X,00           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat_2015',
'ef100u1',
'ef100u1-Art der Prfung bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (vorletzte Prfung)-Studienform',
'             Art der Prfung bei  bereits vor dem Berichtssemester             abgelegten Abschlussprfungen an Hochschulen             (vorletzte Prfung).           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat_2015',
'ef100u2',
'ef100u2-Art der Prfung bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (vorletzte Prfung)-Abschluss',
'             Art der Prfung bei  bereits vor dem Berichtssemester             abgelegten Abschlussprfungen an Hochschulen             (vorletzte Prfung).           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat_2015',
'ef101',
'ef101-1. Studienfach bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (vorletzte Prfung).',
'             1. Studienfach bei  bereits vor dem Berichtssemester             abgelegten Abschlussprfungen an Hochschulen             (vorletzte Prfung).           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat_2015',
'ef102',
'ef102-2. Studienfach bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (vorletzte Prfung).',
'             2. Studienfach bei  bereits vor dem Berichtssemester             abgelegten Abschlussprfungen an Hochschulen             (vorletzte Prfung).           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat_2015',
'ef103',
'ef103-3. Studienfach bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (vorletzte Prfung).',
'             3. Studienfach bei  bereits vor dem Berichtssemester             abgelegten Abschlussprfungen an Hochschulen             (vorletzte Prfung).           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat_2015',
'ef104',
'ef104-Frei fr StL',
'Frei fr StL',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat_2015',
'ef105',
'ef105-Monat des Prfnugsabschlusses bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (vorletzte Prfung).',
'             Monat des Prfnugsabschlusses             bei  bereits vor dem Berichtssemester             abgelegten Abschlussprfungen an Hochschulen             (vorletzte Prfung).           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat_2015',
'ef106',
'ef106-Jahr des Prfungsabschlusses bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (vorletzte Prfung).',
'             Jahr des Prfungsabschlusses             bei  bereits vor dem Berichtssemester             abgelegten Abschlussprfungen an Hochschulen             (vorletzte Prfung).           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat_2015',
'ef107',
'ef107-Prfungsergebnis bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (vorletzte Prfung). 1 = insgesamt bestanden 2 = endgltig nicht bestanden',
'             Prfungsergebnis bei  bereits vor dem Berichtssemester             abgelegten Abschlussprfungen an Hochschulen             (vorletzte Prfung).             1 = insgesamt bestanden             2 = endgltig nicht bestanden           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat_2015',
'ef108',
'ef108-Gesamtnote bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (vorletzte Prfung). X,00',
'             Gesamtnote bei  bereits vor dem Berichtssemester             abgelegten Abschlussprfungen an Hochschulen             (vorletzte Prfung).             X,00           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat_2015',
'ef109',
'ef109-Jahr des ersten Erwerbs der HZB',
'Jahr des ersten Erwerbs der HZB',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat_2015',
'ef110',
'ef110-Art der HZB',
'Art der HZB',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat_2015',
'ef111u1',
'ef111u1-Erwerb der HZB Bundesland bzw. "99" fr Ausland',
'             Erwerb der HZB             Bundesland bzw. "99" fr Ausland           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat_2015',
'ef111u2',
'ef111u2-Erwerb der HZB Kreis (bei Erwerb in Deutschland) bzw. Staat (bei Erwerb im Ausland)',
'             Erwerb der HZB             Kreis (bei Erwerb in Deutschland)             bzw. Staat (bei Erwerb im Ausland)           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat_2015',
'ef112',
'ef112-Berufspraktische Ttigkeit vor dem Studium Art der Ttigkeit 1 = Berufsausbildung mit Abschluss sonst LEER',
'             Berufspraktische Ttigkeit vor dem Studium                          Art der Ttigkeit             1 = Berufsausbildung mit Abschluss             sonst LEER           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat_2015',
'ef113',
'ef113-Berufspraktische Ttigkeit vor dem Studium Art der Ttigkeit 1 = Praktikum oder Volontariat im Hinblick auf das derzeitige Studium sonst LEER',
'             Berufspraktische Ttigkeit vor dem Studium                          Art der Ttigkeit             1 = Praktikum oder Volontariat im Hinblick auf das derzeitige Studium             sonst LEER           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat_2015',
'ef114',
'ef114-Frei fr StL',
'Frei fr StL',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat_2015',
'ef115',
'ef115-Frei fr StL',
'Frei fr StL',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat_2015',
'ef116',
'ef116-Frei fr StL',
'Frei fr StL',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat_2015',
'ef117',
'ef117-Frei fr StL',
'Frei fr StL',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat_2015',
'ef118',
'ef118-Frei fr StL',
'Frei fr StL',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat_2015',
'ef119',
'ef119-Frei fr StL',
'Frei fr StL',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat_2015',
'ef120',
'ef120-Prfungsamt der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (1. Prfung)',
'             Prfungsamt der seit der letzten              Semestermeldung insgesamt              abgeschlossene Prfung(en).             (1. Prfung)           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat_2015',
'ef121',
'ef121-Anzahl der Fachsemester fr diese Prfung der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (1. Prfung)',
'             Anzahl der Fachsemester fr diese              Prfung der seit der letzten              Semestermeldung insgesamt              abgeschlossene Prfung(en).             (1. Prfung)           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat_2015',
'ef122',
'ef122-Anzahl der Fachsemester fr diese Prfung der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (1. Prfung)',
'             Anzahl der Fachsemester fr diese              Prfung der seit der letzten              Semestermeldung insgesamt              abgeschlossene Prfung(en).             (1. Prfung)           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat_2015',
'ef123',
'ef123-Anzahl der Fachsemester fr diese Prfung der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (1. Prfung) hier: Aus einem anderem Studiengang an einer deutschen Hochschule (einschl. Praxissemester)',
'             Anzahl der Fachsemester fr diese              Prfung der seit der letzten              Semestermeldung insgesamt              abgeschlossene Prfung(en).             (1. Prfung)                          hier: Aus einem anderem Studiengang ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat_2015',
'ef124',
'ef124-Anzahl der Fachsemester fr diese Prfung der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (1. Prfung) hier: Berufspraktische Ttigkeit vor der Einschreibungim Studiengang der Prfung, soweit als Praxissemester bewertet',
'             Anzahl der Fachsemester fr diese              Prfung der seit der letzten              Semestermeldung insgesamt              abgeschlossene Prfung(en).             (1. Prfung)                          hier: Berufspraktische Ttigkeit vor',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat_2015',
'ef125',
'ef125-Anzahl der Fachsemester fr diese Prfung der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (1. Prfung) hier: aus einem Auslandsstudium',
'             Anzahl der Fachsemester fr diese              Prfung der seit der letzten              Semestermeldung insgesamt              abgeschlossene Prfung(en).             (1. Prfung)                          hier: aus einem Auslandsstudium     ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat_2015',
'ef126u1',
'ef126u1-Art der Prfung der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (1. Prfung)-Studienform',
'             Art der Prfung der seit der letzten              Semestermeldung insgesamt              abgeschlossene Prfung(en).             (1. Prfung)           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat_2015',
'ef126u2',
'ef126u2-Art der Prfung der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (1. Prfung)-Abschluss',
'             Art der Prfung der seit der letzten              Semestermeldung insgesamt              abgeschlossene Prfung(en).             (1. Prfung)           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat_2015',
'ef127',
'ef127-1. Studienfach der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (1. Prfung)',
'             1. Studienfach der seit der letzten              Semestermeldung insgesamt              abgeschlossene Prfung(en).             (1. Prfung)           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat_2015',
'ef128',
'ef128-2. Studienfach der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (1. Prfung)',
'             2. Studienfach der seit der letzten              Semestermeldung insgesamt              abgeschlossene Prfung(en).             (1. Prfung)           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat_2015',
'ef129',
'ef129-3. Studienfach der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (1. Prfung)',
'             3. Studienfach der seit der letzten              Semestermeldung insgesamt              abgeschlossene Prfung(en).             (1. Prfung)           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat_2015',
'ef130',
'ef130-Frei fr StL',
'Frei fr StL',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat_2015',
'ef131',
'ef131-Frei fr StL',
'Frei fr StL',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat_2015',
'ef132',
'ef132-Monat des Prfungsabschlusses bei der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (1. Prfung)',
'             Monat des Prfungsabschlusses             bei der seit der letzten              Semestermeldung insgesamt              abgeschlossene Prfung(en).             (1. Prfung)           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat_2015',
'ef133',
'ef133-Jahr des Prfungsabschlusses bei der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (1. Prfung)',
'             Jahr des Prfungsabschlusses             bei der seit der letzten              Semestermeldung insgesamt              abgeschlossene Prfung(en).             (1. Prfung)           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat_2015',
'ef134',
'ef134-Prfungsergebnis bei der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (1. Prfung)',
'             Prfungsergebnis bei der seit der letzten              Semestermeldung insgesamt              abgeschlossene Prfung(en).             (1. Prfung)           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat_2015',
'ef135',
'ef135-Gesamtnote bei der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (1. Prfung) X,00',
'             Gesamtnote bei der seit der letzten              Semestermeldung insgesamt              abgeschlossene Prfung(en).             (1. Prfung)             X,00           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat_2015',
'ef136',
'ef136-Prfungsamt der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung)',
'             Prfungsamt der seit der letzten              Semestermeldung insgesamt              abgeschlossene Prfung(en).             (2. Prfung)           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat_2015',
'ef137',
'ef137-Anzahl der Fachsemester fr diese Prfung der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung)',
'             Anzahl der Fachsemester fr diese              Prfung der seit der letzten              Semestermeldung insgesamt              abgeschlossene Prfung(en).             (2. Prfung)           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat_2015',
'ef138',
'ef138-Anzahl der Fachsemester fr diese Prfung der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung)',
'             Anzahl der Fachsemester fr diese              Prfung der seit der letzten              Semestermeldung insgesamt              abgeschlossene Prfung(en).             (2. Prfung)           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat_2015',
'ef139',
'ef139-Anzahl der Fachsemester fr diese Prfung der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung) hier: Aus einem anderem Studiengang an einer deutschen Hochschule (einschl. Praxissemester)',
'             Anzahl der Fachsemester fr diese              Prfung der seit der letzten              Semestermeldung insgesamt              abgeschlossene Prfung(en).             (2. Prfung)                          hier: Aus einem anderem Studiengang ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat_2015',
'ef140',
'ef140-Anzahl der Fachsemester fr diese Prfung der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung) hier: Berufspraktische Ttigkeit vor der Einschreibungim Studiengang der Prfung, soweit als Praxissemester bewertet',
'             Anzahl der Fachsemester fr diese              Prfung der seit der letzten              Semestermeldung insgesamt              abgeschlossene Prfung(en).             (2. Prfung)                          hier: Berufspraktische Ttigkeit vor',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat_2015',
'ef141',
'ef141-Anzahl der Fachsemester fr diese Prfung der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung) hier: aus einem Auslandsstudium',
'             Anzahl der Fachsemester fr diese              Prfung der seit der letzten              Semestermeldung insgesamt              abgeschlossene Prfung(en).             (2. Prfung)                          hier: aus einem Auslandsstudium     ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat_2015',
'ef142u1',
'ef142u1-Art der Prfung der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung)-Studienform',
'             Art der Prfung der seit der letzten              Semestermeldung insgesamt              abgeschlossene Prfung(en).             (2. Prfung)           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat_2015',
'ef142u2',
'ef142u2-Art der Prfung der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung)-Abschluss',
'             Art der Prfung der seit der letzten              Semestermeldung insgesamt              abgeschlossene Prfung(en).             (2. Prfung)           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat_2015',
'ef143',
'ef143-1. Studienfach der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung)',
'             1. Studienfach der seit der letzten              Semestermeldung insgesamt              abgeschlossene Prfung(en).             (2. Prfung)           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat_2015',
'ef144',
'ef144-2. Studienfach der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung)',
'             2. Studienfach der seit der letzten              Semestermeldung insgesamt              abgeschlossene Prfung(en).             (2. Prfung)           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat_2015',
'ef145',
'ef145-3. Studienfach der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung)',
'             3. Studienfach der seit der letzten              Semestermeldung insgesamt              abgeschlossene Prfung(en).             (2. Prfung)           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat_2015',
'ef146',
'ef146-Frei fr StL',
'Frei fr StL',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat_2015',
'ef147',
'ef147-Frei fr StL',
'Frei fr StL',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat_2015',
'ef148',
'ef148-Monat des Prfungsabschlusses bei der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung)',
'             Monat des Prfungsabschlusses             bei der seit der letzten              Semestermeldung insgesamt              abgeschlossene Prfung(en).             (2. Prfung)           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat_2015',
'ef149',
'ef149-Jahr des Prfungsabschlusses bei der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung)',
'             Jahr des Prfungsabschlusses             bei der seit der letzten              Semestermeldung insgesamt              abgeschlossene Prfung(en).             (2. Prfung)           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat_2015',
'ef150',
'ef150-Prfungsergebnis bei der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung)',
'             Prfungsergebnis bei der seit der letzten              Semestermeldung insgesamt              abgeschlossene Prfung(en).             (2. Prfung)           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat_2015',
'ef151',
'ef151-Gesamtnote bei der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung) X,00',
'             Gesamtnote bei der seit der letzten              Semestermeldung insgesamt              abgeschlossene Prfung(en).             (2. Prfung)             X,00           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat_2015',
'ef152',
'ef152-Gesamtnote in Punkten bei der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung)',
'             Gesamtnote in Punkten             bei der seit der letzten              Semestermeldung insgesamt              abgeschlossene Prfung(en).             (2. Prfung)           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lab_astat_2015',
'id',
'id',
'',
'SERIAL',
'10',
1,
1,
0,
0);

update tmp_fields set is_primarykey=1 
where trim(table_name) || '_' || trim(name) ='kenn_lab_astat_2015_id';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lfb_fg',
'tid',
'tid',
'Schlssel',
'SERIAL',
'4',
1,
1,
0,
0);

update tmp_fields set is_primarykey=1 
where trim(table_name) || '_' || trim(name) ='kenn_lfb_fg_tid';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lfb_fg',
'apnr',
'Schlssel Fach/LFB/Fchergruppe',
'',
'CHAR',
'10',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lfb_fg',
'parent',
'bergeordneter Schlssel',
'Wird zur Ermittlung der Baumstruktur verwendet.',
'CHAR',
'10',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lfb_fg',
'drucktext',
'Volltext Druck',
'',
'CHAR',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lfb_fg',
'name',
'Volltext Lang',
'',
'CHAR',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lfb_fg',
'struktur_c',
'Art des Schlssels (FG,LFB,FGR)',
'',
'CHAR',
'50',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lfb_fg',
'gueltig_von',
'Gltig von',
'',
'DATE',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lfb_fg',
'gueltig_bis',
'Gltig von',
'',
'DATE',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lieferung',
'hs_nr',
'Hochschulnummer',
'',
'INTEGER',
'4',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lieferung',
'kennzahl',
'Art der Kennzahl',
'',
'CHAR',
'40',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_lieferung',
'datum',
'Datum der letzten Lieferung',
'Dieses Feld wird zur Archivierung von gelieferten Daten genutzt',
'date',
'4',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_pbe_aggr',
'hs_nr',
'Hochschulnummer',
'',
'INTEGER',
'4',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_pbe_aggr',
'bund_fachgebiet',
'Fachgebiet ',
'(aus zugewiesener Dienststelle in SOE ermittelt)',
'CHAR',
'10',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_pbe_aggr',
'bund_dienstart',
'Dienstart (1=Wiss./2=Nichtwiss. Bundesschlssel)',
'',
'SMALLINT',
'10',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_pbe_aggr',
'faktor',
'Halbe Stelle/ganze Stelle',
'Minimum von (soe.anteil_proz / 100) und (sgd.ansatz_proz/100)),z.B.0.5 fr halbe Stelle',
'DECIMAL',
'(3,2)',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_pbe_aggr',
'buadbz',
'Bundesschlssel ADBZ',
'dient zur Unterscheidung Prof./Wiss.Mitarb./etc',
'CHAR',
'10',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_pbe_aggr',
'buadbz_besetzung',
'Amtsdienstbezeichung (Bund) der Besetzung',
'',
'CHAR',
'10',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_pbe_aggr',
'da_besetzung',
'Dienstart (Bund) der Besetzung',
'wiss.(1)/nichtwiss.(2) Personal',
'SMALLINT',
'2',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_pbe_aggr',
'taet_besetzung',
'Ttigkeit (Bund) der Besetzung',
'Haupt(1)/Nebenberufliche(2) Ttigkeit',
'SMALLINT',
'2',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_pbe_aggr',
'stichtag',
'Datum der Gltigkeit der Stelle',
'i.d.R. der 1.12. des jew. Jahres',
'DATE',
'2',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_pbe_aggr',
'datum',
'Datum der Erzeugung',
'Dieses Feld wird zur Archivierung von gelieferten Daten genutzt',
'date',
'4',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_pbe_aggr',
'zaehlung',
'Zhlung der Besetzung',
'v=VZ, k=Kpfe',
'CHAR',
'2',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_pbe_aggr',
'summe',
'Umfang der Besetzung (VZ)',
'VZ-Summe der die Stelle besetzenden Personen',
'DOUBLE',
'4',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_pbv_aggr',
'hs_nr',
'Hochschulnummer',
'',
'INTEGER',
'4',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_hochschulen',
foreignkey_col='hs_nr',
foreignkey_cap='name',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_pbv_aggr_hs_nr';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_pbv_aggr',
'geschlecht',
'geschlecht',
'mnnlich oder weiblich',
'SMALLINT',
'1',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_pbv_aggr',
'bund_fachgebiet',
'Fachgebiet ',
'(aus zugewiesener Dienststelle in POZ ermittelt)',
'CHAR',
'10',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_lfb_fg',
foreignkey_col='apnr',
foreignkey_cap='drucktext',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_pbv_aggr_bund_fachgebiet';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_pbv_aggr',
'bund_taetigkeit',
'Art der Ttigkeit ',
'Haupt (1)/Nebenberuflich (2)',
'SMALLINT',
'10',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_taetigkeit',
foreignkey_col='bund_taetigkeit',
foreignkey_cap='drucktext',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_pbv_aggr_bund_taetigkeit';

update tmp_fields set foreignkey_func='val'
where trim(table_name) || '_' || trim(name) ='kenn_pbv_aggr_bund_taetigkeit';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_pbv_aggr',
'bund_dienstart',
'Dienstart (1=Wiss./2=Nichtwiss. Bundesschlssel)',
'',
'SMALLINT',
'10',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_dienstart',
foreignkey_col='bund_dienstart',
foreignkey_cap='drucktext',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_pbv_aggr_bund_dienstart';

update tmp_fields set foreignkey_func='val'
where trim(table_name) || '_' || trim(name) ='kenn_pbv_aggr_bund_dienstart';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_pbv_aggr',
'buadbz',
'Amts-Dienstbez. (Bundesschlssel)',
'',
'CHAR',
'5',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_k_buadbz',
foreignkey_col='buadbz',
foreignkey_cap='adbz',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_pbv_aggr_buadbz';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_pbv_aggr',
'klr_geldgeber',
'Geldgeber aus Finanzierung ',
'In BaWue werden die dreistelligen Schlssel 110,190,210,290,300-311 geliefert.',
'CHAR',
'4',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_gege',
foreignkey_col='apnr',
foreignkey_cap='druck',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_pbv_aggr_klr_geldgeber';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_pbv_aggr',
'kapitel',
'Kapitel aus Finanzierung',
'',
'CHAR',
'5',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_pbv_aggr',
'stichtag',
'Datum der Gltigkeit des Besch.-Verh.',
'i.d.R. der 1.12. des jew. Jahres',
'DATE',
'2',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_pbv_aggr',
'zaehlung',
'Kpfe=k / VZAE zum Stichtag=v / (nur Sachsen:) VZAE im Jahr=j / Kpfe im Jahr=p ',
'',
'CHAR',
'2',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_perso_z',
foreignkey_col='key',
foreignkey_cap='name',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_pbv_aggr_zaehlung';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_pbv_aggr',
'datum',
'Datum der Erzeugung',
'Dieses Feld wird zur Archivierung von gelieferten Daten genutzt',
'date',
'4',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_pbv_aggr',
'summe',
'Summe',
'',
'DOUBLE',
'4',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_pbv_aggr',
'extkost',
'Externe Kostenstelle',
'Nummer der Fakultt (nur Sachsen)',
'CHAR',
'30',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_pbv_aggr',
'extkotr',
'Externer Produktschlssel',
'Nummer des externen Produktschlssels (nur Sachsen)',
'CHAR',
'30',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_pbv_aggr',
'befristet',
'Befristet',
'1=ja, 0=nein (nur Sachsen)',
'SMALLINT',
'2',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_pbv_aggr',
'staat',
'Nationalitt',
'1=Ausland, 0=Deutschland,2=Unbekannt (nur Sachsen)',
'INTEGER',
'2',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_pbv_aggr',
'ernennung_alter',
'Alter bei Ernennung',
'Jahr der Ernennung (EF36) bzw. ernennung_jahr_ngl - Geburtsjahr (EF25)',
'INTEGER',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_pbv_aggr',
'qualifizierung_art',
'Tenure Track oder Nachwuchsgruppenleitung',
'1=Nachwuchsgruppenleitung oder 2=Prof. Tenure Track',
'SMALLINT',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_pbv_aggr',
'finanzierung_art',
'finanzierungsart',
'Gem. STBA EF22 / Schlssel 5.2.1',
'CHAR',
'10',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_pbv_aggr_astat',
'hs_nr',
'Hochschulnummer',
'',
'INTEGER',
'4',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_hochschulen',
foreignkey_col='hs_nr',
foreignkey_cap='name',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_pbv_aggr_astat_hs_nr';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_pbv_aggr_astat',
'jahr',
'jahr',
'mnnlich oder weiblich',
'SMALLINT',
'1',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_pbv_aggr_astat',
'geschlecht',
'geschlecht',
'mnnlich oder weiblich',
'SMALLINT',
'1',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_pbv_aggr_astat',
'bund_fachgebiet',
'Fachgebiet ',
'(aus zugewiesener Dienststelle in POZ ermittelt)',
'CHAR',
'10',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_lfb_fg',
foreignkey_col='apnr',
foreignkey_cap='drucktext',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_pbv_aggr_astat_bund_fachgebiet';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_pbv_aggr_astat',
'bund_taetigkeit',
'Art der Ttigkeit ',
'Haupt (1)/Nebenberuflich (2)',
'SMALLINT',
'10',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_taetigkeit',
foreignkey_col='bund_taetigkeit',
foreignkey_cap='drucktext',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_pbv_aggr_astat_bund_taetigkeit';

update tmp_fields set foreignkey_func='val'
where trim(table_name) || '_' || trim(name) ='kenn_pbv_aggr_astat_bund_taetigkeit';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_pbv_aggr_astat',
'bund_dienstart',
'Dienstart (1=Wiss./2=Nichtwiss. Bundesschlssel)',
'',
'SMALLINT',
'10',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_dienstart',
foreignkey_col='bund_dienstart',
foreignkey_cap='drucktext',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_pbv_aggr_astat_bund_dienstart';

update tmp_fields set foreignkey_func='val'
where trim(table_name) || '_' || trim(name) ='kenn_pbv_aggr_astat_bund_dienstart';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_pbv_aggr_astat',
'buadbz',
'Amts-Dienstbez. (Bundesschlssel)',
'',
'CHAR',
'5',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_k_buadbz',
foreignkey_col='buadbz',
foreignkey_cap='adbz',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_pbv_aggr_astat_buadbz';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_pbv_aggr_astat',
'bund_geldgeber',
'Geldgeber aus Finanzierung ',
'In BaWue werden die dreistelligen Schlssel 110,190,210,290,300-311 geliefert.',
'CHAR',
'4',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_pbv_aggr_astat',
'zaehlung',
'Kpfe=k / VZAE zum Stichtag=v / (nur Sachsen:) VZAE im Jahr=j / Kpfe im Jahr=p ',
'',
'CHAR',
'2',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_perso_z',
foreignkey_col='key',
foreignkey_cap='name',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_pbv_aggr_astat_zaehlung';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_pbv_aggr_astat',
'datum',
'Datum der Erzeugung',
'Dieses Feld wird zur Archivierung von gelieferten Daten genutzt',
'date',
'4',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_pbv_aggr_astat',
'befristet',
'Befristet',
'1=ja, 0=nein (nur Sachsen)',
'SMALLINT',
'2',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_pbv_aggr_astat',
'staat',
'Nationalitt',
'1=Ausland, 0=Deutschland,2=Unbekannt (nur Sachsen)',
'INTEGER',
'2',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_pbv_aggr_astat',
'ernennung_jahr',
'Jahr der Ernennung',
'Jahr der Ernennung (EF36) bzw. ernennung_jahr_ngl, vierstellig',
'INTEGER',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_pbv_aggr_astat',
'ernennung_alter',
'Alter bei Ernennung',
'Jahr der Ernennung (EF36) bzw. ernennung_jahr_ngl - Geburtsjahr (EF25)',
'INTEGER',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_pbv_aggr_astat',
'qualifizierung_art',
'Tenure Track oder Nachwuchsgruppenleitung',
'1=Nachwuchsgruppenleitung oder 2=Prof. Tenure Track',
'SMALLINT',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_pbv_aggr_astat',
'fgr',
'Fchergruppe',
'',
'CHAR',
'10',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_dim_fgr',
foreignkey_col='apnr',
foreignkey_cap='drucktext',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_pbv_aggr_astat_fgr';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_pbv_aggr_astat',
'summe',
'Summe',
'',
'DOUBLE',
'4',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_pbv_astat',
'hs_nr',
'Hochschulnummer',
'',
'INTEGER',
'4',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_pbv_astat',
'jahr',
'Jahr',
'',
'INTEGER',
'4',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_pbv_astat',
'datum',
'Datum',
'',
'DATE',
'4',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_pbv_astat',
'personal_nr',
'Personalnr.',
'',
'INTEGER',
'4',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_pbv_astat',
'ernennung_jahr_ngl',
'Jahr bei Ernennung bei NGL',
'Nachwuchsgruppenleiter',
'SMALLINT',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_pbv_astat',
'ef01',
'ef01-Ordnungsmerkmal Satzart',
'',
'INTEGER',
'4',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_pbv_astat',
'ef02',
'ef02-Berichtsland',
'',
'VARCHAR',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_pbv_astat',
'ef03',
'ef03-Hochschulnummer',
'',
'VARCHAR',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_pbv_astat',
'ef04',
'ef04-Listennummer',
'',
'VARCHAR',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_pbv_astat',
'ef05',
'ef05-Organisatorische Zugehrigkeit Kategorie',
'',
'VARCHAR',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_pbv_astat',
'ef06',
'ef06-Lehr- u. Forschungsbereich',
'',
'VARCHAR',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_pbv_astat',
'ef07',
'ef07-frei lassen',
'',
'VARCHAR',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_pbv_astat',
'ef08',
'ef08-Paginiernummer',
'',
'VARCHAR',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_pbv_astat',
'ef09',
'ef09-immer N',
'',
'VARCHAR',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_pbv_astat',
'ef10',
'ef10-Fachl. Zugehrigkeit',
'frei lassen',
'VARCHAR',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_pbv_astat',
'ef11',
'ef11-Fachgebiet',
'',
'VARCHAR',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_pbv_astat',
'ef12',
'ef12-Dienstbezeichung',
'',
'VARCHAR',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_pbv_astat',
'ef13',
'ef13-Ttigkeit',
'',
'VARCHAR',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_pbv_astat',
'ef14',
'ef14-Arbeitszeit  Vollzeit/Teilzeit',
'Beschftigungsverhltnis',
'VARCHAR',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_pbv_astat',
'ef15',
'ef15-hauptberufl. Ttigkeit',
'',
'VARCHAR',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_pbv_astat',
'ef16',
'ef16-Std. Anzahl',
'Angabe in EF16 und EF17 nur bei nebenberuflicher Ttigkeit',
'VARCHAR',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_pbv_astat',
'ef17',
'ef17-Wochenstd. oder  Semesterstd.',
'',
'VARCHAR',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_pbv_astat',
'ef18',
'ef18-Dienstverhltnis',
'Angabe in EF18 bis EF21 nur fr hauptberufliches Personal',
'VARCHAR',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_pbv_astat',
'ef19',
'ef19-Beschftigung',
'',
'VARCHAR',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_pbv_astat',
'ef20',
'ef20-Laufbahngruppe',
'',
'VARCHAR',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_pbv_astat',
'ef21',
'ef21-Besoldungs-/ Vergtungsgruppe',
'',
'VARCHAR',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_pbv_astat',
'ef22',
'ef22-Art der Finanzierung',
'',
'VARCHAR',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_pbv_astat',
'ef23',
'ef23-Geschlecht',
'mnnlich / weiblich',
'INTEGER',
'4',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_pbv_astat',
'ef24',
'ef24-Geburtsdatum Monat',
'',
'VARCHAR',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_pbv_astat',
'ef25',
'ef25-Jahr',
'',
'INTEGER',
'4',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_pbv_astat',
'ef26',
'ef26-Staatsangeh.',
'Schlssel 5.4.1',
'INTEGER',
'4',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_pbv_astat',
'ef27',
'ef27-Hchster Schulabschluss',
'',
'VARCHAR',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_pbv_astat',
'ef28',
'ef28-Hochschule von EF27',
'',
'VARCHAR',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_pbv_astat',
'ef29',
'ef29-Staat von EF27',
'',
'VARCHAR',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_pbv_astat',
'ef30',
'ef30-Jahr des Erwerbs',
'',
'INTEGER',
'4',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_pbv_astat',
'ef31',
'ef31-1. Fach des 1. Studiengang',
'',
'VARCHAR',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_pbv_astat',
'ef32',
'ef32-Habi. Fachgebiet d. Habi.',
'',
'VARCHAR',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_pbv_astat',
'ef33',
'ef33-Qualifizierung Art',
'',
'VARCHAR',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_pbv_astat',
'ef34',
'ef34-Verfahren',
'',
'VARCHAR',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_pbv_astat',
'ef35',
'ef35-Hochschule Position',
'',
'VARCHAR',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_pbv_astat',
'ef36',
'ef36-Jahr d. ersten Berufung auf Zeit',
'Professoren',
'INTEGER',
'4',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_pbv_astat',
'ef37',
'ef37-Jahr d. ersten Berufung auf Lebenszeit',
'',
'INTEGER',
'4',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_pbv_astat',
'ef38',
'ef38-Vorquali.',
'',
'VARCHAR',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_pbv_astat',
'ef39',
'ef39',
'frei',
'VARCHAR',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_pbv_astat',
'ef40',
'ef40',
'frei',
'VARCHAR',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_pbv_astat',
'ef41',
'ef41',
'frei',
'VARCHAR',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_pbv_astat',
'ef42',
'ef42',
'frei',
'VARCHAR',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_pbv_astat',
'ef43',
'ef43',
'frei',
'VARCHAR',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_pbv_klr',
'hs_nr',
'Hochschulnummer',
'',
'INTEGER',
'4',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_pbv_klr',
'jahr',
'jahr',
'',
'SMALLINT',
'2',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_pbv_klr',
'monat',
'monat',
'',
'SMALLINT',
'2',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_pbv_klr',
'kapitel',
'Kapitel aus Finanzierung',
'',
'CHAR',
'5',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_pbv_klr',
'titel',
'titel',
'',
'CHAR',
'10',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_pbv_klr',
'kostenart',
'kostenart',
'',
'CHAR',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_pbv_klr',
'kalk_kostenart',
'kalk_kostenart',
'',
'CHAR',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_pbv_klr',
'bund_dienstart',
'Dienstart (1=Wiss./2=Nichtwiss. Bundesschlssel)',
'',
'SMALLINT',
'10',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_pbv_klr',
'buadbz',
'Amts-Dienstbez. (Bundesschlssel)',
'',
'CHAR',
'10',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_pbv_klr',
'klr_geldgeber',
'Geldgeber aus Finanzierung ',
'In BaWue werden die dreistelligen Schlssel 110,190,210,290,300-311 geliefert.',
'CHAR',
'10',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_pbv_klr',
'extkost',
'Externe Kostenstelle',
'Nummer der Fakultt (nur Sachsen)',
'CHAR',
'30',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_pbv_klr',
'extkotr',
'Externer Produktschlssel',
'Nummer des externen Produktschlssels (nur Sachsen)',
'CHAR',
'30',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_pbv_klr',
'stichtag',
'Datum der Gltigkeit des Besch.-Verh.',
'i.d.R. der 1.12. des jew. Jahres',
'DATE',
'2',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_pbv_klr',
'zaehlung',
'Kpfe=k / VZAE=v',
'',
'CHAR',
'2',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_pbv_klr',
'datum',
'Datum der Erzeugung',
'Dieses Feld wird zur Archivierung von gelieferten Daten genutzt',
'date',
'4',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_pbv_klr',
'summe',
'Summe',
'',
'DOUBLE',
'4',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_pkosten_cube',
'hs_nr',
'Hochschulnummer',
'',
'INTEGER',
'4',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='dim_hochschule',
foreignkey_col='hs_nr',
foreignkey_cap='name',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_pkosten_cube_hs_nr';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_pkosten_cube',
'jahr',
'Jahr der Buchung',
'',
'SMALLINT',
'2',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_pkosten_cube',
'quartal',
'Quartal der Buchung',
'',
'INTEGER',
'2',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_pkosten_cube',
'bvkr_art',
'Kostenart (BVKR)',
'Hier werden nur ausgewhlte kostenarten (gem. Grunddaten-Katalog) angezeigt.',
'CHAR',
'12',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='dim_kenn_bvkr_art',
foreignkey_col='apnr',
foreignkey_cap='druck',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_pkosten_cube_bvkr_art';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_pkosten_cube',
'klr_geldgeber',
'Geldgeber nach KLR (Drittm.,Fremdkap.,HH)',
'',
'CHAR',
'10',
0,
0,
0,
0);

update tmp_fields set foreignkey_tab='kenn_gege',
foreignkey_col='apnr',
foreignkey_cap='druck',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_pkosten_cube_klr_geldgeber';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_pkosten_cube',
'projnr',
'Externer Kostentrger',
'',
'CHAR',
'10',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_dim_extkotr',
foreignkey_col='key',
foreignkey_cap='name',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_pkosten_cube_projnr';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_pkosten_cube',
'inst_art',
'Externe Kostenstelle',
'Hier werden nur ausgewhlte Kostenstellen (gem. Grunddaten-Katalog) angezeigt.',
'CHAR',
'20',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_dim_extkost',
foreignkey_col='extkost',
foreignkey_cap='extkost_str',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_pkosten_cube_inst_art';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_pkosten_cube',
'betrag',
'Betrag in EUR',
'',
'DOUBLE',
'8',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_proj_gege',
'hs_nr',
'Hochschulnummer',
'',
'INTEGER',
'4',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_proj_gege',
'projnr',
'Projekt Schlssel',
'',
'CHAR',
'10',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_proj_gege',
'klr_geldgeber',
'KLR-Geldgeber',
'',
'CHAR',
'10',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_proj_gege',
'k_extkotr',
'externer Kostentrger',
'',
'CHAR',
'10',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_proj_gege',
'jahr',
'jahr',
'',
'INTEGER',
'4',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_prom_astat',
'hs_nr',
'Hochschulnummer',
'',
'INTEGER',
'',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_prom_astat',
'berichtseinheitid',
'Berichtseinheit ID',
'',
'VARCHAR',
'8',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_prom_astat',
'ef001',
'Berichtsland',
'',
'INTEGER',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_prom_astat',
'ef002',
'Berichtsjahr',
'',
'INTEGER',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_prom_astat',
'ef003',
'Hochschule der Promotion',
'',
'VARCHAR',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_prom_astat',
'ef004',
'Paginiernummer',
'',
'VARCHAR',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_prom_astat',
'ef005',
'Geschlecht',
'',
'INTEGER',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_prom_astat',
'ef006u1',
'Geburtsdatum - Tag',
'',
'INTEGER',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_prom_astat',
'ef006u2',
'Geburtsdatum - Monat',
'',
'INTEGER',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_prom_astat',
'ef006u3',
'Geburtsdatum - Jahr',
'',
'INTEGER',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_prom_astat',
'ef007',
'Name',
'',
'VARCHAR',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_prom_astat',
'ef008',
'Staatsangehrigkeit',
'',
'INTEGER',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_prom_astat',
'ef009',
'weitere Staatsangehrigkeit',
'',
'INTEGER',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_prom_astat',
'ef010',
'Art der Promotion',
'01-Hochschule BRD, 02-Koop. mit Ausland, 03-Koop. mit FH, 04-Koop. mit Forschg.Einr., 05-Koop. mit Sonst.',
'INTEGER',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_prom_astat',
'ef011',
'Promotionsfach',
'',
'CHAR',
'4',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_prom_astat',
'ef012',
'Art der Registrierung als Promovierender',
'1=Erstregistrierung, 2=Neuregistrierung, 3=aktive Fortsetzung,4=Beurlaubung / Unterbrechung, 5=Abschluss der Promotion, 6=Abbruch der Promotion',
'INTEGER',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_prom_astat',
'ef013u1',
'Promotionsbeginn Monat',
'',
'INTEGER',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_prom_astat',
'ef013u2',
'Promotionsbeginn Jahr',
'',
'INTEGER',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_prom_astat',
'ef014u1',
'Promotionsende Monat',
'',
'INTEGER',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_prom_astat',
'ef014u2',
'Promotionsende Jahr',
'',
'INTEGER',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_prom_astat',
'ef015',
'Immatrikulation',
'0 = nein, 1 = ja',
'INTEGER',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_prom_astat',
'ef016',
'Teilnahme an einem strukturierenden Promotionsprogramm',
'0 = nein, 1 = ja',
'INTEGER',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_prom_astat',
'ef017',
'Beschftigungsverhltnis an der Hochschule der Promotion',
'0 = nein, 1 = ja',
'INTEGER',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_prom_astat',
'ef018',
'Art der Dissertation',
'1 = Monografie, 2 = publikationsbasierte/kumulative Dissertation',
'INTEGER',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_prom_astat',
'ef019',
'Hochschule (Ersteinschreibung)',
'',
'VARCHAR',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_prom_astat',
'ef020',
'Staat der Hochschule',
'Bei Ersteinschreibung an einer Hochschule ausserhalb Deutschlands',
'INTEGER',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_prom_astat',
'ef021',
'Semester',
'1  = Sommersemester, 2 = Wintersemester',
'INTEGER',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_prom_astat',
'ef022',
'Jahr',
'',
'INTEGER',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_prom_astat',
'ef023',
'Zur Promotion berechtigende Abschlussprfung',
'0 = wurde noch nicht abgelegt 1 = wurde abgelegt und bestanden',
'INTEGER',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_prom_astat',
'ef024',
'Hochschule',
'',
'VARCHAR',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_prom_astat',
'ef025',
'Vorherige Hochschule Staat',
'Wenn Hochschule der zur Promotion berechtigenden, vorangegangenen bestandenen Abschlussprfung auerhalb Deutschlands',
'INTEGER',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_prom_astat',
'ef026',
'Art der Prfung',
'',
'CHAR',
'3',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_prom_astat',
'ef027',
'1. Studienfach',
'',
'CHAR',
'4',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_prom_astat',
'ef028',
'Monat des Prfungsabschlusses',
'',
'INTEGER',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_prom_astat',
'ef029',
'Jahr des Prfungsabschlusses',
'',
'INTEGER',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_prom_astat',
'ef030',
'Gesamtnote',
'',
'INTEGER',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_prom_astat',
'ef031',
'Jahr des Erwerbs einer HZB',
'',
'INTEGER',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_prom_astat',
'ef032',
'Art der ersten HZB',
'',
'VARCHAR',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_prom_astat',
'ef033u1',
'Land der ersten HZB',
'Art der ersten HZB - Bundesland, bzw. 99  fr Ausland',
'INTEGER',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_prom_astat',
'ef033u2',
'Kreis/Staat der ersten HZB',
'Kreis (bei Erwerb in Deutschland) bzw. Staat (bei Erwerb im Ausland)',
'INTEGER',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_prom_astat',
'ef034',
'frei fr landesinterne Angaben',
'',
'VARCHAR',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_prom_astat',
'ef035',
'frei fr landesinterne Angaben',
'',
'VARCHAR',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_prom_astat',
'ef036',
'frei fr landesinterne Angaben',
'',
'VARCHAR',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_prom_astat',
'ef037',
'frei fr landesinterne Angaben',
'',
'VARCHAR',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_prom_astat',
'ef038',
'frei fr landesinterne Angaben',
'',
'VARCHAR',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_promo',
'jahr_beginn',
'Jahr des Beginns der Promotion',
'',
'SMALLINT',
'40',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_promo',
'jahr_ende',
'Jahr des Ende der Promotion',
'',
'SMALLINT',
'40',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_promo',
'art_ende',
'erfolgreich (B=bestanden,NB=nicht bestanden, U=unbekannt)',
'',
'CHAR',
'2',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_promo',
'koop_land_ausl',
'Staat der Koop. HS (L=Eigenes Bundesland, D=Anderes Bundesland in Deutschland, A=Ausland)',
'',
'CHAR',
'1',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_promo',
'geschlecht',
'Geschlecht (1 mnnl.,2 weibl.)',
'',
'SMALLINT',
'2',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_promo',
'extkotr',
'Fchergruppe',
'',
'CHAR',
'20',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_promo',
'summe',
'Summe',
'',
'INTEGER',
'4',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_promo_aggr',
'hs_nr',
'hs_nr',
'',
'INTEGER',
'10',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_promo_aggr',
'jahr',
'Bezugsjahr',
'',
'SMALLINT',
'40',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_promo_aggr',
'jahr_beginn',
'Jahr des Beginns der Promotion',
'',
'SMALLINT',
'40',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_promo_aggr',
'jahr_ende',
'Jahr des Ende der Promotion',
'',
'SMALLINT',
'40',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_promo_aggr',
'art_ende',
'erfolgreich (B=bestanden,NB=nicht bestanden, U=unbekannt)',
'',
'CHAR',
'2',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_promo_aggr',
'koop_land_ausl',
'Staat der Koop. HS (L=Eigenes Bundesland, D=Anderes Bundesland in Deutschland, A=Ausland)',
'',
'CHAR',
'1',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_promo_aggr',
'geschlecht',
'Geschlecht (1 mnnl.,2 weibl.)',
'',
'SMALLINT',
'2',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_promo_aggr',
'extkotr',
'Fchergruppe',
'',
'CHAR',
'20',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_dim_fgr',
foreignkey_col='apnr',
foreignkey_cap='drucktext',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_promo_aggr_extkotr';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_promo_aggr',
'datum',
'Datum der Erzeugung',
'Dieses Feld wird zur Archivierung von gelieferten Daten genutzt',
'date',
'4',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_promo_aggr',
'summe',
'Summe',
'',
'INTEGER',
'4',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_promo_aggr',
'dauer_jahre',
'Dauer in Jahren',
'',
'FLOAT',
'4',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_promo_aggr',
'monat_beginn',
'Monat des Beginns der Promotion',
'',
'SMALLINT',
'40',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_promo_aggr',
'monat_ende',
'Monat des Ende der Promotion',
'',
'SMALLINT',
'40',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_promo_aggr',
'jahr_beginn_bezug',
'Bezugsjahr des Beginns der Promotion',
'Bei Monat 12 ist das Bezugsjahr das Folgejahr',
'SMALLINT',
'40',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_promo_aggr',
'jahr_ende_bezug',
'Bezugsjahr des Ende der Promotion',
'Bei Monat 12 ist das Bezugsjahr das Folgejahr',
'SMALLINT',
'40',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_pruefrout',
'tid',
'tid',
'Schlssel',
'SERIAL',
'4',
0,
1,
0,
0);

update tmp_fields set is_primarykey=1 
where trim(table_name) || '_' || trim(name) ='kenn_pruefrout_tid';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_pruefrout',
'datum',
'datum',
'Datum',
'DATE',
'2',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_pruefrout',
'gueltig_von',
'gueltig_von',
'Anfang Gltigkeit',
'DATE',
'4',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_pruefrout',
'gueltig_bis',
'gueltig_bis',
'Ende Gltigkeit',
'DATE',
'4',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_pruefrout',
'tabelle_quelle',
'tabelle_quelle',
'Quelltabelle',
'CHAR',
'18',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_pruefrout',
'tabelle_kenn',
'tabelle_kenn',
'Kenn Quelltabelle',
'CHAR',
'18',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_pruefrout',
'problem',
'problem',
'Beschreibung',
'CHAR',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_pruefrout',
'aktion',
'aktion',
'Protokoll Aktion',
'CHAR',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_quartal_hier',
'hs_nr',
'Hochschulnummer',
'',
'INTEGER',
'4',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_quartal_hier',
'quartal',
'Quartal',
'',
'INTEGER',
'4',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_quartal_hier',
'gruppe',
'Kostenart/Kostenstelle',
'bvkr/inst',
'CHAR',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_quartal_hier',
'key',
'Schlssel',
'',
'CHAR',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_quartal_hier',
'ueberg',
'bergeordnet lt. BVKR/Inst',
'',
'CHAR',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_report_stichtagsart',
'tid',
'Tupelidentifier',
'',
'SERIAL',
'4',
1,
1,
0,
0);

update tmp_fields set is_primarykey=1 
where trim(table_name) || '_' || trim(name) ='kenn_report_stichtagsart_tid';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_report_stichtagsart',
'report_id',
'ID des Reports',
'',
'CHAR',
'40',
1,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_cifx',
foreignkey_col='apnr',
foreignkey_cap='druck',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_report_stichtagsart_report_id';

update tmp_fields set foreignkey_cond='679=kenn_cifx.key'
where trim(table_name) || '_' || trim(name) ='kenn_report_stichtagsart_report_id'
and trim(foreignkey_tab) = 'kenn_cifx';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_report_stichtagsart',
'stichtagsart_id',
'ID der Stichtagsart',
'',
'CHAR',
'40',
1,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_stichtagsart',
foreignkey_col='apnr',
foreignkey_cap='druck',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_report_stichtagsart_stichtagsart_id';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_rpt_ansprech',
'tid',
'tid',
'',
'SERIAL',
'10',
1,
1,
0,
0);

update tmp_fields set is_primarykey=1 
where trim(table_name) || '_' || trim(name) ='kenn_rpt_ansprech_tid';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_rpt_ansprech',
'hs_nr',
'Hochschule',
'',
'INTEGER',
'10',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='hochschulinfo',
foreignkey_col='hs_nr',
foreignkey_cap='name',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_rpt_ansprech_hs_nr';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_rpt_ansprech',
'report_id',
'Bericht',
'',
'CHAR',
'10',
1,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_cifx',
foreignkey_col='apnr',
foreignkey_cap='druck',
foreignkey_uniquename='uniquename'
where trim(table_name) || '_' || trim(name) ='kenn_rpt_ansprech_report_id';

update tmp_fields set foreignkey_cond='679=kenn_cifx.key'
where trim(table_name) || '_' || trim(name) ='kenn_rpt_ansprech_report_id'
and trim(foreignkey_tab) = 'kenn_cifx';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_rpt_ansprech',
'name',
'Nachname',
'',
'VARCHAR',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_rpt_ansprech',
'vorname',
'Vorname',
'',
'VARCHAR',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_rpt_ansprech',
'email',
'Email',
'',
'VARCHAR',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_rpt_ansprech',
'telefon',
'Telefon',
'',
'VARCHAR',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_rpt_ansprech',
'exportieren',
'Exportieren?',
'Soll die Statistik im Unload-Job exportiert werden? (1=j,0,nein)',
'CHAR',
'1',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_rpt_version',
'tid',
'tid',
'',
'SERIAL',
'10',
1,
1,
0,
0);

update tmp_fields set is_primarykey=1 
where trim(table_name) || '_' || trim(name) ='kenn_rpt_version_tid';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_rpt_version',
'report_id',
'Bericht',
'',
'CHAR',
'40',
1,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_cifx',
foreignkey_col='apnr',
foreignkey_cap='druck',
foreignkey_uniquename='uniquename'
where trim(table_name) || '_' || trim(name) ='kenn_rpt_version_report_id';

update tmp_fields set foreignkey_cond='679=kenn_cifx.key'
where trim(table_name) || '_' || trim(name) ='kenn_rpt_version_report_id'
and trim(foreignkey_tab) = 'kenn_cifx';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_rpt_version',
'defaulttext',
'Name',
'z.B. Stellenbewirtschaftungsbericht HS-Kapitel',
'VARCHAR',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_rpt_version',
'uniquename',
'Schlssel',
'z.B. STBB_HSKAP1',
'VARCHAR',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_rpt_version',
'version_comment',
'Kommentar',
'z.B.Version x.x basierend auf Verordnung 8 vom 13.5.2023',
'TEXT',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_rpt_version',
'ordinal_number',
'Version (numerisch)',
'z.B.10',
'INTEGER',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_rpt_version',
'release_version',
'Paket-Version',
'z.B.HISinOne-BI 2024.06',
'VARCHAR',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_rpt_version',
'valid_from',
'Gltig von',
'z.B. 01.01.2022',
'DATE',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_rpt_version',
'valid_to',
'Gltig bis',
'z.B. 31.12.2024',
'DATE',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sb_astfr_lfb',
'tid',
'tid',
'Schlssel',
'SERIAL',
'4',
1,
1,
0,
0);

update tmp_fields set is_primarykey=1 
where trim(table_name) || '_' || trim(name) ='kenn_sb_astfr_lfb_tid';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sb_astfr_lfb',
'astfr',
'Schlssel Fachrichtung Gasthrerstat.',
'',
'CHAR',
'10',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sb_astfr_lfb',
'astfr_text',
'Volltext Fachrichtung Gasthrerstat.',
'',
'CHAR',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sb_astfr_lfb',
'sb_nr',
'Schlssel Studienbereich',
'',
'CHAR',
'10',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sb_astfr_lfb',
'sb_text',
'Volltext Studienbereich',
'',
'CHAR',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sb_astfr_lfb',
'lfb_nr',
'Schlssel Lehr- und Forschungsbereich',
'',
'CHAR',
'10',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sb_astfr_lfb',
'lfb_text',
'Volltext Lehr- und Forschungsbereich',
'',
'CHAR',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sember_stg_cube',
'hs_nr',
'Hochschule',
'',
'INTEGER',
'20',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='dim_hochschule',
foreignkey_col='hs_nr',
foreignkey_cap='name',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_sember_stg_cube_hs_nr';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sember_stg_cube',
'studiengang_nr',
'Studiengang-Nummer',
'z.B. 2 fr 2. Studiengang',
'SMALLINT',
'2',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sember_stg_cube',
'fach_nr',
'Fach-Nummer',
'z.B. 2 fr 2. Fach',
'SMALLINT',
'2',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sember_stg_cube',
'semester',
'Semester',
'',
'INTEGER',
'4',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='cif',
foreignkey_col='apnr',
foreignkey_cap='druck',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_sember_stg_cube_semester';

update tmp_fields set foreignkey_cond='661=cif.key'
where trim(table_name) || '_' || trim(name) ='kenn_sember_stg_cube_semester'
and trim(foreignkey_tab) = 'cif';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sember_stg_cube',
'fachsem',
'Anzahl Fachsemester',
'',
'INTEGER',
'4',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sember_stg_cube',
'geschlecht',
'Geschlecht',
'',
'INTEGER',
'4',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='cif',
foreignkey_col='apnr',
foreignkey_cap='druck',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_sember_stg_cube_geschlecht';

update tmp_fields set foreignkey_cond='9003=cif.key'
where trim(table_name) || '_' || trim(name) ='kenn_sember_stg_cube_geschlecht'
and trim(foreignkey_tab) = 'cif';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sember_stg_cube',
'hzbart',
'Gruppe der HZB',
'',
'INTEGER',
'4',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='cif',
foreignkey_col='apnr',
foreignkey_cap='druck',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_sember_stg_cube_hzbart';

update tmp_fields set foreignkey_cond='652=cif.key'
where trim(table_name) || '_' || trim(name) ='kenn_sember_stg_cube_hzbart'
and trim(foreignkey_tab) = 'cif';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sember_stg_cube',
'rsz',
'in der RSZ',
'(0=nein, 1=ja,-1=unbekannt)',
'INTEGER',
'4',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='cif',
foreignkey_col='apnr',
foreignkey_cap='druck',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_sember_stg_cube_rsz';

update tmp_fields set foreignkey_cond='658=cif.key'
where trim(table_name) || '_' || trim(name) ='kenn_sember_stg_cube_rsz'
and trim(foreignkey_tab) = 'cif';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sember_stg_cube',
'abschluss',
'Abschluss',
'',
'CHAR',
'20',
0,
0,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sember_stg_cube',
'abschluss_astat',
'Abschluss (amtlich)',
'',
'CHAR',
'10',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='dim_kenn_abschl_astat',
foreignkey_col='apnr',
foreignkey_cap='druck',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_sember_stg_cube_abschluss_astat';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sember_stg_cube',
'stg_astat',
'Fach (amtlich)',
'',
'CHAR',
'20',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='dim_kenn_stg_astat',
foreignkey_col='apnr',
foreignkey_cap='druck',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_sember_stg_cube_stg_astat';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sember_stg_cube',
'stg',
'Hochschule und Fach (intern)',
'',
'CHAR',
'20',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='dim_kenn_stg_int',
foreignkey_col='apnr',
foreignkey_cap='druck',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_sember_stg_cube_stg';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sember_stg_cube',
'ca12_staat',
'Staatsangehrigkeit',
'',
'INTEGER',
'10',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sember_stg_cube',
'hssem',
'Anzahl Hochschulsemester',
'',
'INTEGER',
'2',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='cif',
foreignkey_col='apnr',
foreignkey_cap='druck',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_sember_stg_cube_hssem';

update tmp_fields set foreignkey_cond='657=cif.key'
where trim(table_name) || '_' || trim(name) ='kenn_sember_stg_cube_hssem'
and trim(foreignkey_tab) = 'cif';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sember_stg_cube',
'kz_fach',
'Fachkennzeichen (amtlich)',
'',
'CHAR',
'10',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_kzfa',
foreignkey_col='astat',
foreignkey_cap='druck',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_sember_stg_cube_kz_fach';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sember_stg_cube',
'kz_rueck_beur_ein',
'Status',
'',
'SMALLINT',
'',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='cifx',
foreignkey_col='astat',
foreignkey_cap='druck',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_sember_stg_cube_kz_rueck_beur_ein';

update tmp_fields set foreignkey_func='val'
where trim(table_name) || '_' || trim(name) ='kenn_sember_stg_cube_kz_rueck_beur_ein';

update tmp_fields set foreignkey_cond='9001=cifx.key'
where trim(table_name) || '_' || trim(name) ='kenn_sember_stg_cube_kz_rueck_beur_ein'
and trim(foreignkey_tab) = 'cifx';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sember_stg_cube',
'hzbart_astat',
'Art der HZB (amtlich)',
'',
'CHAR',
'10',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_hzbart',
foreignkey_col='astat',
foreignkey_cap='druck',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_sember_stg_cube_hzbart_astat';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sember_stg_cube',
'stort',
'Standort',
'',
'CHAR',
'10',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_stort',
foreignkey_col='apnr',
foreignkey_cap='druck',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_sember_stg_cube_stort';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sember_stg_cube',
'stuart',
'Studienart (amtlich)',
'',
'CHAR',
'10',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_stuart',
foreignkey_col='apnr',
foreignkey_cap='druck',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_sember_stg_cube_stuart';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sember_stg_cube',
'stufrm',
'Studienform (amtlich)',
'',
'CHAR',
'10',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_stufrm',
foreignkey_col='apnr',
foreignkey_cap='druck',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_sember_stg_cube_stufrm';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sember_stg_cube',
'hrst',
'Hrerstatus (amtlich)',
'',
'CHAR',
'10',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sember_stg_cube',
'summe',
'Summe',
'',
'INTEGER',
'4',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_semester',
'tid',
'Schlssel',
'z.B. 20091=SS 2009, 20082=WS 2008/2009',
'INTEGER',
'4',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_semester',
'kurz',
'kurz',
'Kurztext des Semesters',
'CHAR',
'50',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_semester',
'druck',
'druck',
'Volltext des Semesters',
'CHAR',
'200',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_semester',
'akad_jahr',
'Akademisches Jahr BW',
'Die Definiton des akademischen Jahres von Baden Wrtemberg lautet: Akademisches Jahr ist das Wintersemester des Jahres und das drausf folgende Sommersemester. Z.B.: akad Jahr 2006 = 20062 + 20071',
'SMALLINT',
'4',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_semester',
'akad_jahr_absolv',
'Akademisches Jahr fr Absolventen SA',
'Die Definiton des akademischen Jahres fr Absolventen von Sachsen lautet: Akademisches Jahr fr Absolventen ist das Wintersemester des Vorjahres und das Sommersemester des akademischen Jahres. Z.B.: akad Jahr 2006 = 20052 + 20061',
'SMALLINT',
'4',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_semester',
'akad_jahr_anf',
'Akademisches Jahr fr Studienanfnger SA',
'Die Definiton des akademischen Jahres fr Studienanfnger von Sachsen lautet: Akademisches Jahr fr Studienanfnger ist das Sommersemester und das Wintersemester des akademischen Jahres. Z.B.: akad Jahr 2006 = 20061 + 20062',
'SMALLINT',
'4',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_semester',
'sem_beginn',
'sem_beginn',
'Semester Beginn',
'DATE',
'4',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_semester',
'sem_ende',
'sem_ende',
'Semester Ende',
'DATE',
'4',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sgd_aggr',
'hs_nr',
'Hochschulnummer',
'',
'INTEGER',
'4',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_hochschulen',
foreignkey_col='hs_nr',
foreignkey_cap='name',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_sgd_aggr_hs_nr';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sgd_aggr',
'bund_fachgebiet',
'Fachgebiet ',
'(aus zugewiesener Dienststelle in SOE ermittelt)',
'CHAR',
'10',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_lfb_fg',
foreignkey_col='apnr',
foreignkey_cap='drucktext',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_sgd_aggr_bund_fachgebiet';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sgd_aggr',
'bund_dienstart',
'Dienstart (1=Wiss./2=Nichtwiss. Bundesschlssel)',
'',
'SMALLINT',
'10',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_dienstart',
foreignkey_col='bund_dienstart',
foreignkey_cap='drucktext',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_sgd_aggr_bund_dienstart';

update tmp_fields set foreignkey_func='val'
where trim(table_name) || '_' || trim(name) ='kenn_sgd_aggr_bund_dienstart';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sgd_aggr',
'faktor',
'Halbe Stelle/ganze Stelle',
'Minimum von (soe.anteil_proz / 100) und (sgd.ansatz_proz/100)),z.B.0.5 fr halbe Stelle',
'DECIMAL',
'(3,2)',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sgd_aggr',
'buadbz',
'Bundesschlssel ADBZ',
'dient zur Unterscheidung Prof./Wiss.Mitarb./etc',
'CHAR',
'10',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_k_buadbz',
foreignkey_col='buadbz',
foreignkey_cap='adbz',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_sgd_aggr_buadbz';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sgd_aggr',
'besetzung',
'Besetzungsart',
'Besetzt (ja-J, nein-N)',
'CHAR',
'1',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sgd_aggr',
'vzae_besetzung',
'Umfang der Besetzung (VZ)',
'VZ-Summe der die Stelle besetzenden Personen',
'DOUBLE',
'4',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sgd_aggr',
'koepfe_besetzung',
'Umfang der Besetzung (Kpfe)',
'Anzahl der die Stelle besetzenden Personen (Kpfe)',
'DOUBLE',
'4',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sgd_aggr',
'buadbz_besetzung',
'Amtsdienstbezeichung (Bund) der Besetzung',
'',
'CHAR',
'10',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sgd_aggr',
'da_besetzung',
'Dienstart (Bund) der Besetzung',
'wiss.(1)/nichtwiss.(2) Personal',
'SMALLINT',
'2',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sgd_aggr',
'taet_besetzung',
'Ttigkeit (Bund) der Besetzung',
'Haupt(1)/Nebenberufliche(2) Ttigkeit',
'SMALLINT',
'2',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sgd_aggr',
'stichtag',
'Datum der Gltigkeit der Stelle',
'i.d.R. der 1.12. des jew. Jahres',
'DATE',
'2',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sgd_aggr',
'datum',
'Datum der Erzeugung',
'Dieses Feld wird zur Archivierung von gelieferten Daten genutzt',
'date',
'4',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sgd_aggr',
'zaehlung',
'Zhlung der Stelle',
'v=VZ',
'CHAR',
'2',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_stell_z',
foreignkey_col='key',
foreignkey_cap='name',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_sgd_aggr_zaehlung';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sgd_aggr',
'summe',
'Summe der Stellen',
'',
'DOUBLE',
'4',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sgd_aggr',
'titel',
'Titel der Stelle',
'Nur NHS Sachsen',
'CHAR',
'10',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sgd_aggr',
'bund_bvl_stelle',
'BVL-Gruppe Stelle',
'Nur NHS Sachsen',
'CHAR',
'10',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sgd_aggr',
'hhv',
'Haushaltsvermerk',
'1=KW, 2=Staubsaugervermerk. Nur NHS Sachsen',
'SMALLINT',
'2',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sgd_aggr',
'kategorie_gruppe',
'Stellenkategorie',
'Plan=1, Leer=2. Nur NHS Sachsen',
'SMALLINT',
'2',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sgd_aggr',
'vzae_besetzung_beamt',
'Umfang der Besetzung (VZ) durch Beamte',
'VZ-Summe der die Stelle besetzenden Personen (Beamte)',
'DOUBLE',
'4',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sgd_aggr',
'vzae_besetzung_besch',
'Umfang der Besetzung (VZ) durch Beschftigte',
'VZ-Summe der die Stelle besetzenden Personen (Beschftigte)',
'DOUBLE',
'4',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sgd_aggr',
'vzae_besetzung_uw',
'Umfang der Besetzung (VZ) unterwertig',
'VZ-Summe der die Stelle besetzenden Personen mit unterwertiger BVL-Gruppe',
'DOUBLE',
'4',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sgd_aggr',
'adbz_land',
'Landesschlssel ADBZ',
'dient zur Unterscheidung Rektor_in, Juniorprf etc. (nur Sachsen)',
'CHAR',
'10',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sgd_aggr',
'bvl_stelle_kurz',
'Kurztext der BVL-Gruppe',
'z.B. "W 3"',
'VARCHAR',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sgd_aggr',
'kapitel',
'Kapitel',
'lt. Landeshaushalt',
'CHAR',
'10',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sichten',
'tid',
'tid',
'Schlssel',
'SERIAL',
'4',
1,
1,
0,
0);

update tmp_fields set is_primarykey=1 
where trim(table_name) || '_' || trim(name) ='kenn_sichten_tid';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sichten',
'dimension',
'Kurzname der Dimension',
'',
'CHAR',
'40',
1,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sichten',
'dimension_lang',
'Beschreibungstext Dimension',
'',
'CHAR',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sichten',
'stichtag',
'Stichtag alt (Datum)',
'Das Feld ist obsolet',
'DATE',
'10',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sichten',
'sicht_id',
'TID der Sicht (obsolet)',
'',
'INTEGER',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sichten',
'sichtart',
'Art der Sicht',
'',
'CHAR',
'40',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sichten',
'sicht_name_intern',
'ID der Sicht',
'',
'CHAR',
'200',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sichten',
'stichtag_id',
'Stichtag',
'Zu welchem Stichtag ist die Dimension gltig? Wenn null, dann immer',
'INTEGER',
'10',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_stichtag',
foreignkey_col='tid',
foreignkey_cap='bezugszeit',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_sichten_stichtag_id';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_skosten_cube',
'hs_nr',
'Hochschulnummer',
'',
'INTEGER',
'4',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='dim_hochschule',
foreignkey_col='hs_nr',
foreignkey_cap='name',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_skosten_cube_hs_nr';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_skosten_cube',
'jahr',
'jahr',
'KoRe-Periode Jahr',
'SMALLINT',
'2',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_skosten_cube',
'quartal',
'Quartal der Buchung',
'',
'INTEGER',
'2',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_skosten_cube',
'projnr',
'Projektnr. (ext. Kostentrger)',
'Empfangendes Projekt',
'CHAR',
'10',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_dim_extkotr',
foreignkey_col='key',
foreignkey_cap='name',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_skosten_cube_projnr';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_skosten_cube',
'produkt',
'Produkt',
'Lehre/Forschung/DL',
'CHAR',
'10',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_cifx',
foreignkey_col='apnr',
foreignkey_cap='druck',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_skosten_cube_produkt';

update tmp_fields set foreignkey_cond='677=kenn_cifx.key'
where trim(table_name) || '_' || trim(name) ='kenn_skosten_cube_produkt'
and trim(foreignkey_tab) = 'kenn_cifx';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_skosten_cube',
'prim_sek',
'Prim./Sek.',
'P=Primr, S=Sek.',
'CHAR',
'10',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_cifx',
foreignkey_col='apnr',
foreignkey_cap='druck',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_skosten_cube_prim_sek';

update tmp_fields set foreignkey_cond='685=kenn_cifx.key'
where trim(table_name) || '_' || trim(name) ='kenn_skosten_cube_prim_sek'
and trim(foreignkey_tab) = 'kenn_cifx';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_skosten_cube',
'koa_block',
'Kostenartenblock',
'nur BaWue',
'CHAR',
'10',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_cifx',
foreignkey_col='apnr',
foreignkey_cap='druck',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_skosten_cube_koa_block';

update tmp_fields set foreignkey_cond='684=kenn_cifx.key'
where trim(table_name) || '_' || trim(name) ='kenn_skosten_cube_koa_block'
and trim(foreignkey_tab) = 'kenn_cifx';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_skosten_cube',
'betrag',
'betrag',
'Betrag in EUR',
'DOUBLE',
'8',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'hs_nr',
'Hochschulnummer',
'',
'INTEGER',
'',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'semester',
'Semester',
'',
'integer',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'matrikel_nr',
'Matrikelnr.',
'',
'integer',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef001',
'ef001-Berichtsland 01 = Schleswig-Holstein . . . 16 = Thringen',
'             Berichtsland             01 = Schleswig-Holstein             .             .             .             16 = Thringen           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef002',
'ef002-Berichtssemester 1 = Sommersemester 2 = Wintersemester',
'             Berichtssemester             1 = Sommersemester             2 = Wintersemester           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef003',
'ef003-Berichtsjahr',
'Berichtsjahr',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef004',
'ef004-Hochschulstandort',
'Hochschulstandort',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef005',
'ef005-Paginiernummer',
'Paginiernummer',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef006',
'ef006-Matrikelnummer',
'Matrikelnummer',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef007',
'ef007-Geschlecht 1 = mnnlich 2 = weiblich',
'             Geschlecht             1 = mnnlich             2 = weiblich           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef008u1',
'ef008u1-Geburtsdatum - Tag',
'Geburtsdatum - Tag',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef008u2',
'ef008u2-Geburtsdatum - Monat',
'Geburtsdatum - Monat',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef008u3',
'ef008u3-Geburtsdatum - Jahr',
'Geburtsdatum - Jahr',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef009',
'ef009-Name (Die ersten 4 Buchstaben des Vornamens',
'Name (Die ersten 4 Buchstaben des Vornamens',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef010',
'ef010-Staatsangehrigkeit',
'Staatsangehrigkeit',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef011',
'ef011-Weitere Staatsangehrigkeit',
'Weitere Staatsangehrigkeit',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef012u1',
'ef012u1-Semesterwohnsitz - Bundesland/Ausland: Bundesland bzw. "99" fr Ausland',
'Semesterwohnsitz - Bundesland/Ausland:             Bundesland bzw. "99" fr Ausland',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef012u2',
'ef012u2-Semesterwohnsitz Kreis/Staat: Kreis bei Wohnsitz in Deutschland bzw. Staat bei Wohnsitz im Ausland',
'Semesterwohnsitz Kreis/Staat:             Kreis bei Wohnsitz in Deutschland             bzw. Staat bei Wohnsitz im Ausland',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef013u1',
'ef013u1-Heimatwohnsitz - Bundesland/Ausland: Bundesland bzw. "99" fr Ausland',
'Heimatwohnsitz - Bundesland/Ausland:             Bundesland bzw. "99" fr Ausland',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef013u2',
'ef013u2-Heimatwohnsitz Kreis/Staat: Kreis bei Wohnsitz in Deutschland bzw. Staat bei Wohnsitz im Ausland',
'Heimatwohnsitz Kreis/Staat:             Kreis bei Wohnsitz in Deutschland             bzw. Staat bei Wohnsitz im Ausland',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef014',
'ef014-Hrerstatus: 1 = Haupthrer 2 = Nebenhrer/Zweithrer 3 = Studienkollegiat',
'             Hrerstatus:             1 = Haupthrer             2 = Nebenhrer/Zweithrer             3 = Studienkollegiat           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef015',
'ef015-Frei fr StL',
'Frei fr StL',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef016',
'ef016-Frei fr StL',
'Frei fr StL',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef017',
'ef017-Hochschulstandort der Ersteinschreibung',
'Hochschule der Ersteinschreibung',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef018',
'ef018-Bei Ersteinschreibung an einer Hochschule ausserhalb Deutschlands der Staat der Hochschule',
'Bei Ersteinschreibung an einer Hochschule auerhalb Deutschlands der Staat der Hochschule',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef019',
'ef019-Ersteinschreibung in Deutschland/Semester',
'             1 = Sommersemester             2 = Wintersemester           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef020',
'ef020-Jahr der Ersteinschreibung',
'Jahr der Ersteinschreibung',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef021',
'ef021-Anzahl der Hochschulsemester an deutschen Hochschulen insgesamt',
'             (einschl. Urlaubs-, Praxissemester sowie             Semester in der DDR bzw. Berlin (Ost)).           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef022',
'ef022-Urlaubssemester',
'Urlaubssemester',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef023',
'ef023-Praxissemester',
'Praxissemester',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef024',
'ef024-Semester am Studienkolleg',
'Semester am Studienkolleg',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef025',
'ef025-Anzahl der Unterbrechungssemester insgesamt',
'Anzahl der Unterbrechungssemester insgesamt',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef026',
'ef026-Art der Studienunterbrechung (Nur bei Exmatrikulation)',
'Art der Studienunterbrechung (Nur bei Exmatrikulation)',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef027',
'ef027-Frei fr StL',
'Frei fr StL',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef028',
'ef028-Art der Einschreibung/Exmatrikulation/Beurlaubung 1 = Ersteinschreibung 2 = Neueinschreibung 3 = Rckmeldung 4 = Beurlaubung 5 = Exmatrikulation 6 = frhere Exmatrikulation',
'Art der Einschreibung/Exmatrikulation/Beurlaubung             1 = Ersteinschreibung             2 = Neueinschreibung             3 = Rckmeldung             4 = Beurlaubung             5 = Exmatrikulation             6 = frhere Exmatrikulation',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef029',
'ef029-Grund der Beurlaubung/Exmatrikulation',
'Grund der Beurlaubung/Exmatrikulation',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef030',
'ef030-Art des Studiums im Berichtssemester (1. Studiengang) 1. Studium in Deutschland 1 = Prsenzstudium 2 = Fernstudium 3 = Praxissemester 2. Auslandsstudium 4 = Prsenzstudium 5 = Praxissemester',
'             Art des Studiums im Berichtssemester (1. Studiengang)             1. Studium in Deutschland             1 = Prsenzstudium             2 = Fernstudium             3 = Praxissemester             2. Auslandsstudium             4 = Prsenzstudiu',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef031',
'ef031-Voll-/Teilzeit/ Duales Studium im Berichtssemester (1. Studiengang) 1 = Vollzeit 2 = Teilzeit 3 = Duales Studium',
'Voll-/Teilzeit/ Duales Studium im Berichtssemester (1. Studiengang)             1 = Vollzeit             2 = Teilzeit             3 = Duales Studium',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef032',
'ef032-Anzahl der Fachsemester im Hinblick auf die angestrebte Abschlussprfung im Berichtssemester (1. Studiengang)',
'             Anzahl der Fachsemester im Hinblick auf die angestrebte Abschlussprfung             im Berichtssemester (1. Studiengang)           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef033u1',
'ef033u1-Angestrebte Abschlussprfung im Berichtssemester (1. Studiengang)-Studienform',
'Angestrebte Abschlussprfung im Berichtssemester (1. Studiengang)-Studienform',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef033u2',
'ef033u2-Angestrebte Abschlussprfung im Berichtssemester (1. Studiengang)-Abschluss',
'Angestrebte Abschlussprfung im Berichtssemester (1. Studiengang)-Studienform',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef034u1',
'ef034u1-Ort der angestrebten Abschlussprfung - Bundesland bzw. "99" fr Ausland',
'Ort der angestrebten Abschlussprfung - Bundesland bzw. "99" fr Ausland',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef034u2',
'ef034u2-Ort der angestrebten Abschlussprfung - Kreis bei Ort in Deutschland',
'Ort der angestrebten Abschlussprfung - Kreis bei Ort in Deutschland',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef035',
'ef035-Regelstudienzeit 1. Studiengang',
'Regelstudienzeit 1. Studiengang',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef036',
'ef036-1. Studienfach im Berichtssemester (1. Studiengang)',
'1. Studienfach im Berichtssemester (1. Studiengang)',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef037',
'ef037-2. Studienfach im Berichtssemester (1. Studiengang)',
'2. Studienfach im Berichtssemester (1. Studiengang)',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef038',
'ef038-Frei fr StL',
'Frei fr StL',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef039',
'ef039-3. Studienfach im Berichtssemester (1. Studiengang)',
'3. Studienfach im Berichtssemester (1. Studiengang)',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef040',
'ef040-Frei fr StL',
'Frei fr StL',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef041',
'ef041-Frei fr StL',
'Frei fr StL',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef042',
'ef042-Frei fr StL',
'Frei fr StL',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef043',
'ef043-Frei fr StL',
'Frei fr StL',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef044',
'ef044-Art der Einschreibung/Exmatrikulation/Beurlaubung 1 = Ersteinschreibung 2 = Neueinschreibung 3 = Rckmeldung 4 = Beurlaubung 5 = Exmatrikulation 6 = frhere Exmatrikulation',
'Art der Einschreibung/Exmatrikulation/Beurlaubung             1 = Ersteinschreibung             2 = Neueinschreibung             3 = Rckmeldung             4 = Beurlaubung             5 = Exmatrikulation             6 = frhere Exmatrikulation',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef045',
'ef045-Grund der Beurlaubung/Exmatrikulation',
'Grund der Beurlaubung/Exmatrikulation',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef046',
'ef046-Art des Studiums im Berichtssemester (2. Studiengang) 1. Studium in Deutschland 1 = Prsenzstudium 2 = Fernstudium 3 = Praxissemester 2. Auslandsstudium 4 = Prsenzstudium 5 = Praxissemester',
'             Art des Studiums im Berichtssemester (2. Studiengang)             1. Studium in Deutschland             1 = Prsenzstudium             2 = Fernstudium             3 = Praxissemester             2. Auslandsstudium             4 = Prsenzstudiu',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef047',
'ef047-Voll-/Teilzeit/ Duales Studium im Berichtssemester (2. Studiengang) 1 = Vollzeit 2 = Teilzeit 3 = Duales Studium',
'Voll-/Teilzeit/ Duales Studium im Berichtssemester (2. Studiengang)             1 = Vollzeit             2 = Teilzeit             3 = Duales Studium',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef048',
'ef048-Anzahl der Fachsemester im Hinblick auf die angestrebte Abschlussprfung im Berichtssemester (2. Studiengang)',
'             Anzahl der Fachsemester im Hinblick auf die angestrebte Abschlussprfung             im Berichtssemester (2. Studiengang)           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef049u1',
'ef049u1-Angestrebte Abschlussprfung im Berichtssemester (1. Studiengang)-Studienform',
'Angestrebte Abschlussprfung im Berichtssemester (2. Studiengang)-Studienform',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef049u2',
'ef049u2-Angestrebte Abschlussprfung im Berichtssemester (1. Studiengang)-Abschluss',
'Angestrebte Abschlussprfung im Berichtssemester (2. Studiengang)-Studienform',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef050u1',
'ef050u1-Ort der angestrebten Abschlussprfung - Bundesland bzw. "99" fr Ausland (2. Studiengang)',
'Ort der angestrebten Abschlussprfung - Bundesland bzw. "99" fr Ausland (2. Studiengang)',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef050u2',
'ef050u2-Ort der angestrebten Abschlussprfung - Kreis bei Ort in Deutschland (2. Studiengang)',
'Ort der angestrebten Abschlussprfung - Kreis bei Ort in Deutschland (2. Studiengang)',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef051',
'ef051-Regelstudienzeit 2. Studiengang',
'Regelstudienzeit 2. Studiengang',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef052',
'ef052-1. Studienfach im Berichtssemester (2. Studiengang)',
'1. Studienfach im Berichtssemester (2. Studiengang)',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef053',
'ef053-2. Studienfach im Berichtssemester (2. Studiengang)',
'2. Studienfach im Berichtssemester (2. Studiengang)',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef054',
'ef054-Frei fr StL',
'Frei fr StL',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef055',
'ef055-3. Studienfach im Berichtssemester (2. Studiengang)',
'3. Studienfach im Berichtssemester (2. Studiengang)',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef056',
'ef056-Frei fr StL',
'Frei fr StL',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef057',
'ef057-Frei fr StL',
'Frei fr StL',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef058',
'ef058-Frei fr StL',
'Frei fr StL',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef059',
'ef059-Frei fr StL',
'Frei fr StL',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef060',
'ef060-Einschreibung an einer anderen Hochschule - Hochschulstandort',
'Einschreibung an einer anderen Hochschule - Hochschulstandort',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef061',
'ef061-Einschreibung an einer anderen Hochschule - Bei Einschreibung an einer Hochschule ausserhalb Deutschlands der Staat der Hochschule',
'Einschreibung an einer anderen Hochschule - Bei Einschreibung an einer Hochschule auerhalb Deutschlands der Staat der Hochschule',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef062',
'ef062-Angestrebte Abschlussprfung, bei Einschreibung an einer anderen Hochschule im Berichtssemester.',
'             Angestrebte Abschlussprfung, bei Einschreibung an             einer anderen Hochschule im Berichtssemester.           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef063',
'ef063-1. Studienfach, bei Einschreibung an einer anderen Hochschule im Berichtssemester.',
'             1. Studienfach, bei Einschreibung an einer             anderen Hochschule im Berichtssemester.           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef064',
'ef064-2. Studienfach, bei Einschreibung an einer anderen Hochschule im Berichtssemester.',
'             2. Studienfach, bei Einschreibung an einer             anderen Hochschule im Berichtssemester.           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef065',
'ef065-3. Studienfach, bei Einschreibung an einer anderen Hochschule im Berichtssemester.',
'             3. Studienfach, bei Einschreibung an einer             anderen Hochschule im Berichtssemester.           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef066',
'ef066-Frei fr StL',
'Frei fr StL',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef067',
'ef067-Frei fr StL',
'Frei fr StL',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef068',
'ef068-Frei fr StL',
'Frei fr StL',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef069',
'ef069-Kennziffer fr jetzige oder andere Hochschule 1 = jetzige Hochschule 2 = andere Hochschule in Deutschland 3 = Hochschule im Ausland 4 = jetzige und weitere Hochschulen',
'             Kennziffer fr jetzige oder andere Hochschule             1 = jetzige Hochschule             2 = andere Hochschule in Deutschland             3 = Hochschule im Ausland             4 = jetzige und weitere Hochschulen           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef070',
'ef070-Studiengang gleich dem Berichtssemster?',
'Studiengang gleich dem Berichtssemster?',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef071',
'ef071-Hochschulstandort',
'Hochschulstandort',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef072',
'ef072-Wenn Hochschule im vorhergehenden Semester ausserhalb Deutschlands der Staat der Hochschule',
'Wenn Hochschule im vorhergehenden Semester auerhalb Deutschlands der Staat der Hochschule',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef073',
'ef073-Angestrebte Abschlussprfung beim Studium im vorhergehenden Semester, nur Studium in Deutschland (1. Studiengang).',
'             Angestrebte Abschlussprfung beim Studium im vorhergehenden Semester,             nur Studium in Deutschland (1. Studiengang).           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef074',
'ef074-1. Studienfach beim Studium im vorhergehenden Semester, nur Studium in Deutschland (1. Studiengang).',
'1. Studienfach beim Studium im vorhergehenden Semester, nur Studium in Deutschland (1. Studiengang).',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef075',
'ef075-2. Studienfach beim Studium im vorhergehenden Semester, nur Studium in Deutschland (1. Studiengang).',
'             2. Studienfach beim Studium im vorhergehenden Semester,             nur Studium in Deutschland (1. Studiengang).           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef076',
'ef076-3. Studienfach beim Studium im vorhergehenden Semester, nur Studium in Deutschland (1. Studiengang).',
'             3. Studienfach beim Studium im vorhergehenden Semester,             nur Studium in Deutschland (1. Studiengang).           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef077',
'ef077-Frei fr StL',
'Frei fr StL',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef078',
'ef078-Frei fr StL',
'Frei fr StL',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef079',
'ef079-Frei fr StL',
'Frei fr StL',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef080',
'ef080-Hochschulstandort',
'Hochschulstandort',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef081',
'ef081-Wenn Hochschule im vorhergehenden Semester ausserhalb Deutschlands der Staat der Hochschule',
'Wenn Hochschule im vorhergehenden Semester auerhalb Deutschlands der Staat der Hochschule',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef082',
'ef082-Angestrebte Abschlussprfung beim Studium im vorhergehenden Semester, nur Studium in Deutschland (2. Studiengang).',
'             Angestrebte Abschlussprfung beim Studium im vorhergehenden Semester,             nur Studium in Deutschland (2. Studiengang).           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef083',
'ef083-1. Studienfach beim Studium im vorhergehenden Semester, nur Studium in Deutschland (2. Studiengang).',
'             1. Studienfach beim Studium im vorhergehenden Semester,             nur Studium in Deutschland (2. Studiengang).           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef084',
'ef084-2. Studienfach beim Studium im vorhergehenden Semester, nur Studium in Deutschland (2. Studiengang).',
'             2. Studienfach beim Studium im vorhergehenden Semester,             nur Studium in Deutschland (2. Studiengang).           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef085',
'ef085-3. Studienfach beim Studium im vorhergehenden Semester, nur Studium in Deutschland (2. Studiengang).',
'             3. Studienfach beim Studium im vorhergehenden Semester,             nur Studium in Deutschland (2. Studiengang).           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef086',
'ef086-Frei fr StL',
'Frei fr StL',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef087',
'ef087-Frei fr StL',
'Frei fr StL',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef088',
'ef088-Frei fr StL',
'Frei fr StL',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef089',
'ef089-Hochschulstandort',
'Hochschulstandort',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef090',
'ef090-Wenn Hochschule einer bereits abgelegten Abschlussprfung auerhalb Deutschlands der Staat der Hochschule',
'Wenn Hochschule einer bereits abgelegten Abschlussprfung auerhalb Deutschlands der Staat der Hochschule',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef091',
'ef091-Art der Prfung bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (letzte Prfung).',
'             Art der Prfung bei  bereits vor dem Berichtssemester             abgelegten Abschlussprfungen an Hochschulen             (letzte Prfung).           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef092',
'ef092-1. Studienfach bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (letzte Prfung).',
'             1. Studienfach bei  bereits vor dem Berichtssemester             abgelegten Abschlussprfungen an Hochschulen             (letzte Prfung).           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef093',
'ef093-2. Studienfach bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (letzte Prfung).',
'             2. Studienfach bei  bereits vor dem Berichtssemester             abgelegten Abschlussprfungen an Hochschulen             (letzte Prfung).           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef094',
'ef094-3. Studienfach bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (letzte Prfung).',
'             3. Studienfach bei  bereits vor dem Berichtssemester             abgelegten Abschlussprfungen an Hochschulen             (letzte Prfung).           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef095',
'ef095-Monat des Prfnugsabschlusses bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (letzte Prfung).',
'             Monat des Prfungsabschlusses             bei  bereits vor dem Berichtssemester             abgelegten Abschlussprfungen an Hochschulen             (letzte Prfung).           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef096',
'ef096-Jahr des Prfungsabschlusses bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (letzte Prfung).',
'             Jahr des Prfungsabschlusses             bei  bereits vor dem Berichtssemester             abgelegten Abschlussprfungen an Hochschulen             (letzte Prfung).           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef097',
'ef097-Prfungsergebnis bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (letzte Prfung). 1 = insgesamt bestanden 2 = endgltig nicht bestanden',
'             Prfungsergebnis bei  bereits vor dem Berichtssemester             abgelegten Abschlussprfungen an Hochschulen             (letzte Prfung).             1 = insgesamt bestanden             2 = endgltig nicht bestanden           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef098',
'ef098-Gesamtnote bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (letzte Prfung). X,00',
'             Gesamtnote bei  bereits vor dem Berichtssemester             abgelegten Abschlussprfungen an Hochschulen             (letzte Prfung).             X,00           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef099',
'ef099-Frei fr StL',
'Frei fr StL',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef100',
'ef100-Frei fr StL',
'Frei fr StL',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef101',
'ef101-Frei fr StL',
'Frei fr StL',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef102',
'ef102-Frei fr StL',
'Frei fr StL',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef103',
'ef103-Hochschulstandort',
'Hochschulstandort (vorletzte Prfung)',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef104',
'ef104-Wenn Hochschule einer bereits abgelegten Abschlussprfung auerhalb Deutschlands der Staat der Hochschule',
'Wenn Hochschule einer bereits abgelegten Abschlussprfung auerhalb Deutschlands der Staat der Hochschule (vorletzte Prfung)',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef105',
'ef105-Art der Prfung bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (vorletzte Prfung).',
'             Art der Prfung bei  bereits vor dem Berichtssemester             abgelegten Abschlussprfungen an Hochschulen             (vorletzte Prfung).           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef106',
'ef106-1. Studienfach bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (vorletzte Prfung).',
'             1. Studienfach bei  bereits vor dem Berichtssemester             abgelegten Abschlussprfungen an Hochschulen             (vorletzte Prfung).           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef107',
'ef107-2. Studienfach bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (vorletzte Prfung).',
'             2. Studienfach bei  bereits vor dem Berichtssemester             abgelegten Abschlussprfungen an Hochschulen             (vorletzte Prfung).           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef108',
'ef108-3. Studienfach bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (vorletzte Prfung).',
'             3. Studienfach bei  bereits vor dem Berichtssemester             abgelegten Abschlussprfungen an Hochschulen             (vorletzte Prfung).           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef109',
'ef109-Monat des Prfnugsabschlusses bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (vorletzte Prfung).',
'             Monat des Prfungsabschlusses             bei  bereits vor dem Berichtssemester             abgelegten Abschlussprfungen an Hochschulen             (vorletzte Prfung).           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef110',
'ef110-Jahr des Prfungsabschlusses bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (vorletzte Prfung).',
'             Jahr des Prfungsabschlusses             bei  bereits vor dem Berichtssemester             abgelegten Abschlussprfungen an Hochschulen             (vorletzte Prfung).           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef111',
'ef111-Prfungsergebnis bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (vorletzte Prfung). 1 = insgesamt bestanden 2 = endgltig nicht bestanden',
'             Prfungsergebnis bei  bereits vor dem Berichtssemester             abgelegten Abschlussprfungen an Hochschulen             (vorletzte Prfung).             1 = insgesamt bestanden             2 = endgltig nicht bestanden           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef112',
'ef112-Gesamtnote bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (vorletzte Prfung). X,00',
'             Gesamtnote bei  bereits vor dem Berichtssemester             abgelegten Abschlussprfungen an Hochschulen             (vorletzte Prfung).             X,00           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef113',
'ef113-Frei fr StL',
'Frei fr StL',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef114',
'ef114-Frei fr StL',
'Frei fr StL',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef115',
'ef115-Frei fr StL',
'Frei fr StL',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef116',
'ef116-Frei fr StL',
'Frei fr StL',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef117',
'ef117-Jahr des ersten Erwerbs der HZB',
'Jahr des ersten Erwerbs der HZB',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef118',
'ef118-Art der HZB',
'Art der HZB',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef119u1',
'ef119u1-Erwerb der HZB Bundesland bzw. "99" fr Ausland',
'             Erwerb der HZB             Bundesland bzw. "99" fr Ausland           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef119u2',
'ef119u2-Erwerb der HZB Kreis (bei Erwerb in Deutschland) bzw. Staat (bei Erwerb im Ausland)',
'             Erwerb der HZB             Kreis (bei Erwerb in Deutschland)             bzw. Staat (bei Erwerb im Ausland)           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef120',
'ef120-Frei fr StL',
'Frei fr StL',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef121',
'ef121-Frei fr StL',
'Frei fr StL',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef122',
'ef122-Berufspraktische Ttigkeit vor dem Studium Art der Ttigkeit 1 = Berufsausbildung mit Abschluss sonst LEER',
'             Berufspraktische Ttigkeit vor dem Studium                          Art der Ttigkeit             1 = Berufsausbildung mit Abschluss             sonst LEER           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef123',
'ef123-Berufspraktische Ttigkeit vor dem Studium Art der Ttigkeit 1 = Praktikum oder Volontariat im Hinblick auf das derzeitige Studium sonst LEER',
'             Berufspraktische Ttigkeit vor dem Studium                          Art der Ttigkeit             1 = Praktikum oder Volontariat im Hinblick auf das derzeitige Studium             sonst LEER           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef124',
'ef124-Frei fr StL',
'Frei fr StL',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef125',
'ef125-Frei fr StL',
'Frei fr StL',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef126',
'ef126-Prfungsamt der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (1. Prfung)',
'             Prfungsamt der seit der letzten             Semestermeldung insgesamt             abgeschlossene Prfung(en).             (1. Prfung)           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef127',
'ef127-Anzahl der Fachsemester fr diese Prfung der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (1. Prfung)',
'             Anzahl der Fachsemester fr diese             Prfung der seit der letzten             Semestermeldung insgesamt             abgeschlossene Prfung(en).             (1. Prfung)           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef128',
'ef128-Anzahl der Fachsemester fr diese Prfung der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (1. Prfung)',
'             Anzahl der Fachsemester fr diese             Prfung der seit der letzten             Semestermeldung insgesamt             abgeschlossene Prfung(en).             (1. Prfung)                          dar.: Anzahl der angerechneten Fachseme',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef129',
'ef129-Anzahl der Fachsemester fr diese Prfung der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (1. Prfung) hier: Aus einem anderem Studiengang an einer deutschen Hochschule (einschl. Praxissemester)',
'             Anzahl der Fachsemester fr diese             Prfung der seit der letzten             Semestermeldung insgesamt             abgeschlossene Prfung(en).             (1. Prfung)                          hier: Aus einem anderem Studiengang an ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef130',
'ef130-Anzahl der Fachsemester fr diese Prfung der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (1. Prfung) hier: Berufspraktische Ttigkeit vor der Einschreibungim Studiengang der Prfung, soweit als Praxissemester bewertet',
'             Anzahl der Fachsemester fr diese             Prfung der seit der letzten             Semestermeldung insgesamt             abgeschlossene Prfung(en).             (1. Prfung)                          hier: Berufspraktische Ttigkeit vor de',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef131',
'ef131-Anzahl der Fachsemester fr diese Prfung der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (1. Prfung) hier: aus einem Auslandsstudium',
'             Anzahl der Fachsemester fr diese             Prfung der seit der letzten             Semestermeldung insgesamt             abgeschlossene Prfung(en).             (1. Prfung)                          hier: aus einem Auslandsstudium        ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef132',
'ef132-seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en) (1. Prfung) - Anzahl der fr den Studiengang anerkannten ECTS-Punkte',
'seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en) (1. Prfung) - Anzahl der fr den Studiengang anerkannten ECTS-Punkte',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef133',
'ef133-seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en) (1. Prfung) - beruflicher Qualifikationen "Darunter-Position" von EF132',
'seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en) (1. Prfung) - beruflicher Qualifikationen "Darunter-Position" von EF132',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef134',
'ef134-seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en) (1. Prfung) - im Ausland erworbenen anerkannte ECTS-Punkte',
'seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en) (1. Prfung) - im Ausland erworbenen anerkannte ECTS-Punkte',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef135',
'ef135-1. Auslandsaufenthalt 1. Prfung - Staat des Auslandsaufenthalts',
'1. Auslandsaufenthalt 1. Prfung - Staat des Auslandsaufenthalts',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef136',
'ef136-1. Auslandsaufenthalt 1. Prfung - Dauer des Aufenthaltes in Monaten',
'1. Auslandsaufenthalt 1. Prfung - Dauer des Aufenthaltes in Monaten',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef137',
'ef137-1. Auslandsaufenthalt 1. Prfung - Art des Auslandsaufenthaltes',
'1. Auslandsaufenthalt 1. Prfung - Art des Auslandsaufenthaltes',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef138',
'ef138-1. Auslandsaufenthalt 1. Prfung - Art des Mobilittsprogramm',
'1. Auslandsaufenthalt 1. Prfung - Art des Mobilittsprogramms',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef139',
'ef139-2. Auslandsaufenthalt 1. Prfung - Staat des Auslandsaufenthalts',
'2. Auslandsaufenthalt 1. Prfung - Staat des Auslandsaufenthalts',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef140',
'ef140-2. Auslandsaufenthalt 1. Prfung - Dauer des Aufenthaltes in Monaten',
'2. Auslandsaufenthalt 1. Prfung - Dauer des Aufenthaltes in Monaten',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef141',
'ef141-2. Auslandsaufenthalt 1. Prfung - Art des Auslandsaufenthaltes',
'2. Auslandsaufenthalt 1. Prfung - Art des Auslandsaufenthaltes',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef142',
'ef142-2. Auslandsaufenthalt 1. Prfung - Art des Mobilittsprogramm',
'2. Auslandsaufenthalt 1. Prfung - Art des Mobilittsprogramms',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef143',
'ef143-3. Auslandsaufenthalt 1. Prfung - Staat des Auslandsaufenthalts',
'3. Auslandsaufenthalt 1. Prfung - Staat des Auslandsaufenthalts',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef144',
'ef144-3. Auslandsaufenthalt 1. Prfung - Dauer des Aufenthaltes in Monaten',
'3. Auslandsaufenthalt 1. Prfung - Dauer des Aufenthaltes in Monaten',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef145',
'ef145-3. Auslandsaufenthalt 1. Prfung - Art des Auslandsaufenthaltes',
'3. Auslandsaufenthalt 1. Prfung - Art des Auslandsaufenthaltes',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef146',
'ef146-3. Auslandsaufenthalt 1. Prfung - Art des Mobilittsprogramm',
'3. Auslandsaufenthalt 1. Prfung - Art des Mobilittsprogramms',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef147u1',
'ef147u1-Art der Prfung der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (1. Prfung)- Studienform',
'',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef147u2',
'ef147u2-Art der Prfung der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (1. Prfung)- Abschluss',
'',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef148',
'ef148-Fr Promotionsabsolventen Art der Promotion (1. Prfung)',
'Fr Promotionsabsolventen Art der Promotion (1. Prfung)',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef149',
'ef149-Regelstudienzeit (1. Prfung)',
'Regelstudienzeit (1. Prfung)',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef150',
'ef150-1. Studienfach der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (1. Prfung)',
'             1. Studienfach der seit der letzten             Semestermeldung insgesamt             abgeschlossene Prfung(en).             (1. Prfung)           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef151',
'ef151-2. Studienfach der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (1. Prfung)',
'             2. Studienfach der seit der letzten             Semestermeldung insgesamt             abgeschlossene Prfung(en).             (1. Prfung)           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef152',
'ef152-Frei fr StL',
'Frei fr StL',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef153',
'ef153-3. Studienfach der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (1. Prfung)',
'             3. Studienfach der seit der letzten             Semestermeldung insgesamt             abgeschlossene Prfung(en).             (1. Prfung)           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef154',
'ef154-Frei fr StL',
'Frei fr StL',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef155',
'ef155-Monat des Prfungsabschlusses bei der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (1. Prfung)',
'             Monat des Prfungsabschlusses             bei der seit der letzten             Semestermeldung insgesamt             abgeschlossene Prfung(en).             (1. Prfung)           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef156',
'ef156-Jahr des Prfungsabschlusses bei der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (1. Prfung)',
'             Jahr des Prfungsabschlusses             bei der seit der letzten             Semestermeldung insgesamt             abgeschlossene Prfung(en).             (1. Prfung)           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef157',
'ef157-Prfungsergebnis bei der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (1. Prfung)',
'             Prfungsergebnis bei der seit der letzten             Semestermeldung insgesamt             abgeschlossene Prfung(en).             (1. Prfung)           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef158',
'ef158-Gesamtnote bei der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (1. Prfung) X,00',
'             Gesamtnote bei der seit der letzten             Semestermeldung insgesamt             abgeschlossene Prfung(en).             (1. Prfung)             X,00           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef159',
'ef159-Frei fr StL',
'Frei fr StL',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef160',
'ef160-Frei fr StL',
'Frei fr StL',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef161',
'ef161-Frei fr StL',
'Frei fr StL',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef162',
'ef162-Frei fr StL',
'Frei fr StL',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef163',
'ef163-Prfungsamt der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung)',
'             Prfungsamt der seit der letzten             Semestermeldung insgesamt             abgeschlossene Prfung(en).             (2. Prfung)           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef164',
'ef164-Anzahl der Fachsemester fr diese Prfung der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung)',
'             Anzahl der Fachsemester fr diese             Prfung der seit der letzten             Semestermeldung insgesamt             abgeschlossene Prfung(en).             (2. Prfung)           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef165',
'ef165-Anzahl der Fachsemester fr diese Prfung der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung)',
'             Anzahl der Fachsemester fr diese             Prfung der seit der letzten             Semestermeldung insgesamt             abgeschlossene Prfung(en).             (2. Prfung)             dar.: Anzahl der angerechneten Fachsemester insgesam',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef166',
'ef166-Anzahl der Fachsemester fr diese Prfung der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung) hier: Aus einem anderem Studiengang an einer deutschen Hochschule (einschl. Praxissemester)',
'             Anzahl der Fachsemester fr diese             Prfung der seit der letzten             Semestermeldung insgesamt             abgeschlossene Prfung(en).             (2. Prfung)                          hier: Aus einem anderem Studiengang an ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef167',
'ef167-Anzahl der Fachsemester fr diese Prfung der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung) hier: Berufspraktische Ttigkeit vor der Einschreibungim Studiengang der Prfung, soweit als Praxissemester bewertet',
'             Anzahl der Fachsemester fr diese             Prfung der seit der letzten             Semestermeldung insgesamt             abgeschlossene Prfung(en).             (2. Prfung)                          hier: Berufspraktische Ttigkeit vor de',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef168',
'ef168-Anzahl der Fachsemester fr diese Prfung der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung) hier: aus einem Auslandsstudium',
'             Anzahl der Fachsemester fr diese             Prfung der seit der letzten             Semestermeldung insgesamt             abgeschlossene Prfung(en).             (2. Prfung)                          hier: aus einem Auslandsstudium        ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef169',
'ef169-seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en) (2. Prfung) - Anzahl der fr den Studiengang anerkannten ECTS-Punkte',
'seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en) (2. Prfung) - Anzahl der fr den Studiengang anerkannten ECTS-Punkte',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef170',
'ef170-seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en) (2. Prfung) - beruflicher Qualifikationen "Darunter-Position" von EF132',
'seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en) (2. Prfung) - beruflicher Qualifikationen "Darunter-Position" von EF170',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef171',
'ef171-seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en) (2. Prfung) - im Ausland erworbenen anerkannte ECTS-Punkte',
'seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en) (2. Prfung) - im Ausland erworbenen anerkannte ECTS-Punkte',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef172',
'ef172-1. Auslandsaufenthalt 2. Prfung - Staat des Auslandsaufenthalts',
'1. Auslandsaufenthalt 2. Prfung - Staat des Auslandsaufenthalts',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef173',
'ef173-1. Auslandsaufenthalt 2. Prfung - Dauer des Aufenthaltes in Monaten',
'1. Auslandsaufenthalt 2. Prfung - Dauer des Aufenthaltes in Monaten',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef174',
'ef174-1. Auslandsaufenthalt 2. Prfung - Art des Auslandsaufenthaltes',
'1. Auslandsaufenthalt 2. Prfung - Art des Auslandsaufenthaltes',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef175',
'ef175-1. Auslandsaufenthalt 2. Prfung - Art des Mobilittsprogramm',
'1. Auslandsaufenthalt 2. Prfung - Art des Mobilittsprogramms',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef176',
'ef176-2. Auslandsaufenthalt 2. Prfung - Staat des Auslandsaufenthalts',
'2. Auslandsaufenthalt 2. Prfung - Staat des Auslandsaufenthalts',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef177',
'ef177-2. Auslandsaufenthalt 2. Prfung - Dauer des Aufenthaltes in Monaten',
'2. Auslandsaufenthalt 2. Prfung - Dauer des Aufenthaltes in Monaten',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef178',
'ef178-2. Auslandsaufenthalt 2. Prfung - Art des Auslandsaufenthaltes',
'2. Auslandsaufenthalt 2. Prfung - Art des Auslandsaufenthaltes',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef179',
'ef179-2. Auslandsaufenthalt 2. Prfung - Art des Mobilittsprogramm',
'2. Auslandsaufenthalt 2. Prfung - Art des Mobilittsprogramms',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef180',
'ef180-3. Auslandsaufenthalt 2. Prfung - Staat des Auslandsaufenthalts',
'3. Auslandsaufenthalt 2. Prfung - Staat des Auslandsaufenthalts',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef181',
'ef181-3. Auslandsaufenthalt 2. Prfung - Dauer des Aufenthaltes in Monaten',
'3. Auslandsaufenthalt 2. Prfung - Dauer des Aufenthaltes in Monaten',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef182',
'ef182-3. Auslandsaufenthalt 2. Prfung - Art des Auslandsaufenthaltes',
'3. Auslandsaufenthalt 2. Prfung - Art des Auslandsaufenthaltes',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef183',
'ef183-3. Auslandsaufenthalt 2. Prfung - Art des Mobilittsprogramm',
'3. Auslandsaufenthalt 2. Prfung - Art des Mobilittsprogramms',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef184u1',
'ef184u1-Art der Prfung der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung)-Studienform',
'',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef184u2',
'ef184u2-Art der Prfung der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung)-Abschluss',
'',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef185',
'ef185-Fr Promotionsabsolventen Art der Promotion (2. Prfung)',
'Fr Promotionsabsolventen Art der Promotion (2. Prfung)',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef186',
'ef186-Regelstudienzeit (2. Prfung)',
'Regelstudienzeit (2. Prfung)',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef187',
'ef187-1. Studienfach der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung)',
'             1. Studienfach der seit der letzten             Semestermeldung insgesamt             abgeschlossene Prfung(en).             (2. Prfung)           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef188',
'ef188-2. Studienfach der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung)',
'             2. Studienfach der seit der letzten             Semestermeldung insgesamt             abgeschlossene Prfung(en).             (2. Prfung)           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef189',
'ef189-Frei fr StL',
'Frei fr StL',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef190',
'ef190-3. Studienfach der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung)',
'             3. Studienfach der seit der letzten             Semestermeldung insgesamt             abgeschlossene Prfung(en).             (2. Prfung)           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef191',
'ef191-Frei fr StL',
'Frei fr StL',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef192',
'ef192-Monat des Prfungsabschlusses bei der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung)',
'             Monat des Prfungsabschlusses             bei der seit der letzten             Semestermeldung insgesamt             abgeschlossene Prfung(en).             (2. Prfung)           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef193',
'ef193-Jahr des Prfungsabschlusses bei der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung)',
'             Jahr des Prfungsabschlusses             bei der seit der letzten             Semestermeldung insgesamt             abgeschlossene Prfung(en).             (2. Prfung)           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef194',
'ef194-Prfungsergebnis bei der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung)',
'             Prfungsergebnis bei der seit der letzten             Semestermeldung insgesamt             abgeschlossene Prfung(en).             (2. Prfung)           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef195',
'ef195-Gesamtnote bei der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung) X,00',
'             Gesamtnote bei der seit der letzten             Semestermeldung insgesamt             abgeschlossene Prfung(en).             (2. Prfung)             X,00           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef196',
'ef196-Frei fr StL',
'Frei fr StL',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef197',
'ef197-Frei fr StL',
'Frei fr StL',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef198',
'ef198-Frei fr StL',
'Frei fr StL',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'ef199',
'ef199-Frei fr StL',
'Frei fr StL',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'id',
'id',
'',
'SERIAL',
'4',
1,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat',
'importdatum',
'importdatum',
'Datum/Uhrzeit des Imports',
'DATETIME',
'3594',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat_2015',
'hs_nr',
'Hochschulnummer',
'',
'INTEGER',
'',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat_2015',
'semester',
'Semester',
'',
'integer',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat_2015',
'matrikel_nr',
'Matrikelnr.',
'',
'integer',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat_2015',
'ef001',
'ef001-Berichtsland 01 = Schleswig-Holstein . . . 16 = Thringen',
'             Berichtsland             01 = Schleswig-Holstein             .             .             .             16 = Thringen           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat_2015',
'ef002',
'ef002-Berichtssemester 1 = Sommersemester 2 = Wintersemester',
'             Berichtssemester             1 = Sommersemester             2 = Wintersemester           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat_2015',
'ef003',
'ef003-Berichtsjahr',
'Berichtsjahr',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat_2015',
'ef004',
'ef004-Hochschule',
'Hochschule',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat_2015',
'ef005',
'ef005-Paginiernummer',
'Paginiernummer',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat_2015',
'ef006',
'ef006-Matrikelnummer',
'Matrikelnummer',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat_2015',
'ef007',
'ef007-Geschlecht 1 = mnnlich 2 = weiblich',
'             Geschlecht             1 = mnnlich             2 = weiblich           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat_2015',
'ef008u1',
'ef008u1-Geburtsdatum - Monat',
'Geburtsdatum - Monat',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat_2015',
'ef008u2',
'ef008u2-Geburtsdatum - Jahr',
'Geburtsdatum - Jahr',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat_2015',
'ef009',
'ef009-Staatsangehrigkeit',
'Staatsangehrigkeit',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat_2015',
'ef010u1',
'ef010u1-Semesterwohnsitz - Bundesland/Ausland: Bundesland bzw. "99" fr Ausland',
'Semesterwohnsitz - Bundesland/Ausland:             Bundesland bzw. "99" fr Ausland',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat_2015',
'ef010u2',
'ef010u2-Semesterwohnsitz Kreis/Staat: Kreis bei Wohnsitz in Deutschland bzw. Staat bei Wohnsitz im Ausland',
'Semesterwohnsitz Kreis/Staat:             Kreis bei Wohnsitz in Deutschland             bzw. Staat bei Wohnsitz im Ausland',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat_2015',
'ef011u1',
'ef011u1-Heimatwohnsitz - Bundesland/Ausland: Bundesland bzw. "99" fr Ausland',
'Heimatwohnsitz - Bundesland/Ausland:             Bundesland bzw. "99" fr Ausland',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat_2015',
'ef011u2',
'ef011u2-Heimatwohnsitz Kreis/Staat: Kreis bei Wohnsitz in Deutschland bzw. Staat bei Wohnsitz im Ausland',
'Heimatwohnsitz Kreis/Staat:             Kreis bei Wohnsitz in Deutschland             bzw. Staat bei Wohnsitz im Ausland',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat_2015',
'ef012',
'ef012-Hrerstatus: 1 = Haupthrer 2 = Nebenhrer/Zweithrer 3 = Studienkollegiat',
'             Hrerstatus:             1 = Haupthrer             2 = Nebenhrer/Zweithrer             3 = Studienkollegiat           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat_2015',
'ef013',
'ef013-Frei fr StL',
'Frei fr StL',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat_2015',
'ef014',
'ef014-Frei fr StL',
'Frei fr StL',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat_2015',
'ef015',
'ef015-Frei fr StL',
'Frei fr StL',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat_2015',
'ef016',
'ef016-Hochschule der Ersteinschreibung',
'Hochschule der Ersteinschreibung',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat_2015',
'ef017',
'ef017-Ersteinschreibung in Deutschland/Semester',
'             1 = Sommersemester             2 = Wintersemester           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat_2015',
'ef018',
'ef018-Jahr der Ersteinschreibung',
'Jahr der Ersteinschreibung',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat_2015',
'ef019',
'ef019-Anzahl der Hochschulsemester an deutschen Hochschulen insgesamt',
'             (einschl. Urlaubs-, Praxissemester sowie             Semester in der DDR bzw. Berlin (Ost)).           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat_2015',
'ef020',
'ef020-Urlaubssemester',
'Urlaubssemester',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat_2015',
'ef021',
'ef021-Praxissemester',
'Praxissemester',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat_2015',
'ef022',
'ef022-- Semester in der DDR bzw. Berlin (Ost) (einschl. Urlaubssemester)',
'             - Semester in der DDR bzw. Berlin (Ost)             (einschl. Urlaubssemester)           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat_2015',
'ef023',
'ef023-Nur bei Studium in der DDR bzw. Berlin (Ost) Art des Studiums 1 = Prsenzstudium 2 = Fernstudium',
'             Nur bei Studium in der DDR bzw. Berlin (Ost)             Art des Studiums             1 = Prsenzstudium             2 = Fernstudium           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat_2015',
'ef024',
'ef024-Semester am Studienkolleg',
'Semester am Studienkolleg',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat_2015',
'ef025',
'ef025-Anzahl der Unterbrechungssemester insgesamt',
'Anzahl der Unterbrechungssemester insgesamt',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat_2015',
'ef026',
'ef026-Art der Einschreibung/Exmatrikulation/Beurlaubung 1 = Ersteinschreibung 2 = Neueinschreibung 3 = Rckmeldung 4 = Beurlaubung 5 = Exmatrikulation 6 = frhere Exmatrikulation',
'Art der Einschreibung/Exmatrikulation/Beurlaubung             1 = Ersteinschreibung             2 = Neueinschreibung             3 = Rckmeldung             4 = Beurlaubung             5 = Exmatrikulation             6 = frhere Exmatrikulation',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat_2015',
'ef027',
'ef027-Grund der Beurlaubung/Exmatrikulation',
'Grund der Beurlaubung/Exmatrikulation',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat_2015',
'ef028',
'ef028-Art des Studiums im Berichtssemester (1. Studiengang) 1. Studium in Deutschland 1 = Prsenzstudium 2 = Fernstudium 3 = Praxissemester 2. Auslandsstudium 4 = Prsenzstudium 5 = Praxissemester',
'             Art des Studiums im Berichtssemester (1. Studiengang)             1. Studium in Deutschland             1 = Prsenzstudium             2 = Fernstudium             3 = Praxissemester             2. Auslandsstudium             4 = Prsenzstudiu',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat_2015',
'ef029',
'ef029-Voll-/Teilzeit/ Duales Studium im Berichtssemester (1. Studiengang) 1 = Vollzeit 2 = Teilzeit 3 = Duales Studium',
'Voll-/Teilzeit/ Duales Studium im Berichtssemester (1. Studiengang)             1 = Vollzeit             2 = Teilzeit             3 = Duales Studium',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat_2015',
'ef030',
'ef030-Anzahl der Fachsemester im Hinblick auf die angestrebte Abschlussprfung im Berichtssemester (1. Studiengang)',
'             Anzahl der Fachsemester im Hinblick auf die angestrebte Abschlussprfung             im Berichtssemester (1. Studiengang)           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat_2015',
'ef031u1',
'ef031u1-Angestrebte Abschlussprfung im Berichtssemester (1. Studiengang)-Studienform',
'Angestrebte Abschlussprfung im Berichtssemester (1. Studiengang)',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat_2015',
'ef031u2',
'ef031u2-Angestrebte Abschlussprfung im Berichtssemester (1. Studiengang)-Abschluss',
'Angestrebte Abschlussprfung im Berichtssemester (1. Studiengang)',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat_2015',
'ef032',
'ef032-1. Studienfach im Berichtssemester (1. Studiengang)',
'1. Studienfach im Berichtssemester (1. Studiengang)',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat_2015',
'ef033',
'ef033-Frei fr StL',
'Frei fr StL',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat_2015',
'ef034',
'ef034-2. Studienfach im Berichtssemester (1. Studiengang)',
'2. Studienfach im Berichtssemester (1. Studiengang)',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat_2015',
'ef035',
'ef035-Frei fr StL',
'Frei fr StL',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat_2015',
'ef036',
'ef036-3. Studienfach im Berichtssemester (1. Studiengang)',
'3. Studienfach im Berichtssemester (1. Studiengang)',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat_2015',
'ef037',
'ef037-Frei fr StL',
'Frei fr StL',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat_2015',
'ef038',
'ef038-Frei fr StL',
'Frei fr StL',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat_2015',
'ef039',
'ef039-Frei fr StL',
'Frei fr StL',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat_2015',
'ef040',
'ef040-Frei fr StL',
'Frei fr StL',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat_2015',
'ef041',
'ef041-Art der Einschreibung/Exmatrikulation/Beurlaubung 1 = Ersteinschreibung 2 = Neueinschreibung 3 = Rckmeldung 4 = Beurlaubung 5 = Exmatrikulation 6 = frhere Exmatrikulation',
'Art der Einschreibung/Exmatrikulation/Beurlaubung             1 = Ersteinschreibung             2 = Neueinschreibung             3 = Rckmeldung             4 = Beurlaubung             5 = Exmatrikulation             6 = frhere Exmatrikulation',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat_2015',
'ef042',
'ef042-Grund der Beurlaubung/Exmatrikulation',
'Grund der Beurlaubung/Exmatrikulation',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat_2015',
'ef043',
'ef043-Art des Studiums im Berichtssemester (2. Studiengang) 1. Studium in Deutschland 1 = Prsenzstudium 2 = Fernstudium 3 = Praxissemester 2. Auslandsstudium 4 = Prsenzstudium 5 = Praxissemester',
'             Art des Studiums im Berichtssemester (2. Studiengang)             1. Studium in Deutschland             1 = Prsenzstudium             2 = Fernstudium             3 = Praxissemester             2. Auslandsstudium             4 = Prsenzstudiu',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat_2015',
'ef044',
'ef044-Voll-/Teilzeit/ Duales Studium im Berichtssemester (2. Studiengang) 1 = Vollzeit 2 = Teilzeit 3 = Duales Studium',
'Voll-/Teilzeit/ Duales Studium im Berichtssemester (2. Studiengang)             1 = Vollzeit             2 = Teilzeit             3 = Duales Studium',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat_2015',
'ef045',
'ef045-Anzahl der Fachsemester im Hinblick auf die angestrebte Abschlussprfung im Berichtssemester (2. Studiengang)',
'             Anzahl der Fachsemester im Hinblick auf die angestrebte Abschlussprfung             im Berichtssemester (2. Studiengang)           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat_2015',
'ef046u1',
'ef046u1-Angestrebte Abschlussprfung im Berichtssemester (2. Studiengang)-Studienform',
'Angestrebte Abschlussprfung im Berichtssemester (2. Studiengang)',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat_2015',
'ef046u2',
'ef046u2-Angestrebte Abschlussprfung im Berichtssemester (2. Studiengang)-Abschluss',
'Angestrebte Abschlussprfung im Berichtssemester (2. Studiengang)',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat_2015',
'ef047',
'ef047-1. Studienfach im Berichtssemester (2. Studiengang)',
'1. Studienfach im Berichtssemester (2. Studiengang)',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat_2015',
'ef048',
'ef048-Frei fr StL',
'Frei fr StL',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat_2015',
'ef049',
'ef049-2. Studienfach im Berichtssemester (2. Studiengang)',
'2. Studienfach im Berichtssemester (2. Studiengang)',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat_2015',
'ef050',
'ef050-Frei fr StL',
'Frei fr StL',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat_2015',
'ef051',
'ef051-3. Studienfach im Berichtssemester (2. Studiengang)',
'3. Studienfach im Berichtssemester (2. Studiengang)',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat_2015',
'ef052',
'ef052-Frei fr StL',
'Frei fr StL',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat_2015',
'ef053',
'ef053-Frei fr StL',
'Frei fr StL',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat_2015',
'ef054',
'ef054-Frei fr StL',
'Frei fr StL',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat_2015',
'ef055',
'ef055-Frei fr StL',
'Frei fr StL',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat_2015',
'ef056',
'ef056-Hochschule (bei Einschreibung an einer anderen HS im Berichtssemester)',
'Hochschule (bei Einschreibung an einer anderen HS im Berichtssemester)',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat_2015',
'ef057',
'ef057-Frei fr StL',
'Frei fr StL',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat_2015',
'ef058',
'ef058-Frei fr StL',
'Frei fr StL',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat_2015',
'ef059u1',
'ef059u1-Angestrebte Abschlussprfung, bei Einschreibung an einer anderen Hochschule im Berichtssemester-Studienform',
'             Angestrebte Abschlussprfung, bei Einschreibung an             einer anderen Hochschule im Berichtssemester.           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat_2015',
'ef059u2',
'ef059u2-Angestrebte Abschlussprfung, bei Einschreibung an einer anderen Hochschule im Berichtssemester-Abschluss',
'             Angestrebte Abschlussprfung, bei Einschreibung an             einer anderen Hochschule im Berichtssemester.           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat_2015',
'ef060',
'ef060-1. Studienfach, bei Einschreibung an einer anderen Hochschule im Berichtssemester.',
'             1. Studienfach, bei Einschreibung an einer             anderen Hochschule im Berichtssemester.           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat_2015',
'ef061',
'ef061-2. Studienfach, bei Einschreibung an einer anderen Hochschule im Berichtssemester.',
'             2. Studienfach, bei Einschreibung an einer             anderen Hochschule im Berichtssemester.           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat_2015',
'ef062',
'ef062-3. Studienfach, bei Einschreibung an einer anderen Hochschule im Berichtssemester.',
'             3. Studienfach, bei Einschreibung an einer             anderen Hochschule im Berichtssemester.           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat_2015',
'ef063',
'ef063-Frei fr StL',
'Frei fr StL',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat_2015',
'ef064',
'ef064-Kennziffer fr jetzige oder andere Hochschule 1 = jetzige Hochschule 2 = andere Hochschule in Deutschland 3 = Hochschule im Ausland 4 = jetzige und weitere Hochschulen',
'             Kennziffer fr jetzige oder andere Hochschule             1 = jetzige Hochschule             2 = andere Hochschule in Deutschland             3 = Hochschule im Ausland             4 = jetzige und weitere Hochschulen           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat_2015',
'ef065',
'ef065-Studiengang gleich dem Berichtssemster?',
'Studiengang gleich dem Berichtssemster?',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat_2015',
'ef066',
'ef066-Hochschule beim Studium im vorhergehenden Semester, nur Studium in Deutschland (1. Studiengang).',
'             Hochschule beim Studium im vorhergehenden Semester,             nur Studium in Deutschland (1. Studiengang).           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat_2015',
'ef067',
'ef067-Frei fr StL',
'Frei fr StL',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat_2015',
'ef068',
'ef068-Frei fr StL',
'Frei fr StL',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat_2015',
'ef069u2',
'ef069u2-Angestrebte Abschlussprfung beim Studium im vorhergehenden Semester, nur Studium in Deutschland (1. Studiengang)-Studienform',
'             Angestrebte Abschlussprfung beim Studium im vorhergehenden Semester,             nur Studium in Deutschland (1. Studiengang).           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat_2015',
'ef069u1',
'ef069u1-Angestrebte Abschlussprfung beim Studium im vorhergehenden Semester, nur Studium in Deutschland (1. Studiengang)-Abschluss',
'             Angestrebte Abschlussprfung beim Studium im vorhergehenden Semester,             nur Studium in Deutschland (1. Studiengang).           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat_2015',
'ef070',
'ef070-1. Studienfach beim Studium im vorhergehenden Semester, nur Studium in Deutschland (1. Studiengang).',
'             1. Studienfach beim Studium im vorhergehenden Semester,             nur Studium in Deutschland (1. Studiengang).           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat_2015',
'ef071',
'ef071-2. Studienfach beim Studium im vorhergehenden Semester, nur Studium in Deutschland (1. Studiengang).',
'             2. Studienfach beim Studium im vorhergehenden Semester,             nur Studium in Deutschland (1. Studiengang).           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat_2015',
'ef072',
'ef072-3. Studienfach beim Studium im vorhergehenden Semester, nur Studium in Deutschland (1. Studiengang).',
'             3. Studienfach beim Studium im vorhergehenden Semester,             nur Studium in Deutschland (1. Studiengang).           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat_2015',
'ef073',
'ef073-Frei fr StL',
'Frei fr StL',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat_2015',
'ef074',
'ef074-Hochschule beim Studium im vorhergehenden Semester, nur Studium in Deutschland (2. Studiengang).',
'             Hochschule beim Studium im vorhergehenden Semester,             nur Studium in Deutschland (2. Studiengang).           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat_2015',
'ef075',
'ef075-Frei fr StL',
'Frei fr StL',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat_2015',
'ef076',
'ef076-Frei fr StL',
'Frei fr StL',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat_2015',
'ef077u1',
'ef077u1-Angestrebte Abschlussprfung beim Studium im vorhergehenden Semester, nur Studium in Deutschland (2. Studiengang)-Studienform',
'             Angestrebte Abschlussprfung beim Studium im vorhergehenden Semester,             nur Studium in Deutschland (2. Studiengang).           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat_2015',
'ef077u2',
'ef077u2-Angestrebte Abschlussprfung beim Studium im vorhergehenden Semester, nur Studium in Deutschland (2. Studiengang)-Abschluss',
'             Angestrebte Abschlussprfung beim Studium im vorhergehenden Semester,             nur Studium in Deutschland (2. Studiengang).           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat_2015',
'ef078',
'ef078-1. Studienfach beim Studium im vorhergehenden Semester, nur Studium in Deutschland (2. Studiengang).',
'             1. Studienfach beim Studium im vorhergehenden Semester,             nur Studium in Deutschland (2. Studiengang).           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat_2015',
'ef079',
'ef079-2. Studienfach beim Studium im vorhergehenden Semester, nur Studium in Deutschland (2. Studiengang).',
'             2. Studienfach beim Studium im vorhergehenden Semester,             nur Studium in Deutschland (2. Studiengang).           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat_2015',
'ef080',
'ef080-3. Studienfach beim Studium im vorhergehenden Semester, nur Studium in Deutschland (2. Studiengang).',
'             3. Studienfach beim Studium im vorhergehenden Semester,             nur Studium in Deutschland (2. Studiengang).           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat_2015',
'ef081',
'ef081-Frei fr StL',
'Frei fr StL',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat_2015',
'ef082',
'ef082-1. Land (Staat) bei einem frheren - auf das jetzige Studium in Deutschland bezogene - Studium im Ausland.',
'             1. Land (Staat) bei einem frheren - auf das jetzige             Studium in Deutschland bezogene - Studium im Ausland.           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat_2015',
'ef083',
'ef083-Monate im 1. Land (Staat) bei einem frheren - auf das jetzige Studium in Deutschland bezogene - Studium im Ausland.',
'             Monate im 1. Land (Staat) bei einem frheren - auf das jetzige             Studium in Deutschland bezogene - Studium im Ausland.           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat_2015',
'ef084',
'ef084-Frei fr StL',
'Frei fr StL',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat_2015',
'ef085',
'ef085-2. Land (Staat) bei einem frheren - auf das jetzige Studium in Deutschland bezogene - Studium im Ausland.',
'             2. Land (Staat) bei einem frheren - auf das jetzige             Studium in Deutschland bezogene - Studium im Ausland.           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat_2015',
'ef086',
'ef086-Monate im 2. Land (Staat) bei einem frheren - auf das jetzige Studium in Deutschland bezogene - Studium im Ausland.',
'             Monate im 2. Land (Staat) bei einem frheren - auf das jetzige             Studium in Deutschland bezogene - Studium im Ausland.           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat_2015',
'ef087',
'ef087-Frei fr StL',
'Frei fr StL',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat_2015',
'ef088',
'ef088-Frei fr StL',
'Frei fr StL',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat_2015',
'ef089',
'ef089-Frei fr StL',
'Frei fr StL',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat_2015',
'ef090',
'ef090-Frei fr StL',
'Frei fr StL',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat_2015',
'ef091u1',
'ef091u1-Art der Prfung bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (letzte Prfung)-Studienform',
'             Art der Prfung bei  bereits vor dem Berichtssemester             abgelegten Abschlussprfungen an Hochschulen             (letzte Prfung).           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat_2015',
'ef091u2',
'ef091u2-Art der Prfung bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (letzte Prfung)-Abschluss',
'             Art der Prfung bei  bereits vor dem Berichtssemester             abgelegten Abschlussprfungen an Hochschulen             (letzte Prfung).           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat_2015',
'ef092',
'ef092-1. Studienfach bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (letzte Prfung).',
'             1. Studienfach bei  bereits vor dem Berichtssemester             abgelegten Abschlussprfungen an Hochschulen             (letzte Prfung).           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat_2015',
'ef093',
'ef093-2. Studienfach bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (letzte Prfung).',
'             2. Studienfach bei  bereits vor dem Berichtssemester             abgelegten Abschlussprfungen an Hochschulen             (letzte Prfung).           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat_2015',
'ef094',
'ef094-3. Studienfach bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (letzte Prfung).',
'             3. Studienfach bei  bereits vor dem Berichtssemester             abgelegten Abschlussprfungen an Hochschulen             (letzte Prfung).           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat_2015',
'ef095',
'ef095-Frei fr StL',
'Frei fr StL',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat_2015',
'ef096',
'ef096-Monat des Prfnugsabschlusses bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (letzte Prfung).',
'             Monat des Prfnugsabschlusses             bei  bereits vor dem Berichtssemester             abgelegten Abschlussprfungen an Hochschulen             (letzte Prfung).           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat_2015',
'ef097',
'ef097-Jahr des Prfungsabschlusses bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (letzte Prfung).',
'             Jahr des Prfungsabschlusses             bei  bereits vor dem Berichtssemester             abgelegten Abschlussprfungen an Hochschulen             (letzte Prfung).           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat_2015',
'ef098',
'ef098-Prfungsergebnis bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (letzte Prfung). 1 = insgesamt bestanden 2 = endgltig nicht bestanden',
'             Prfungsergebnis bei  bereits vor dem Berichtssemester             abgelegten Abschlussprfungen an Hochschulen             (letzte Prfung).             1 = insgesamt bestanden             2 = endgltig nicht bestanden           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat_2015',
'ef099',
'ef099-Gesamtnote bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (letzte Prfung). X,00',
'             Gesamtnote bei  bereits vor dem Berichtssemester             abgelegten Abschlussprfungen an Hochschulen             (letzte Prfung).             X,00           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat_2015',
'ef100u1',
'ef100u1-Art der Prfung bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (vorletzte Prfung)-Studienform',
'             Art der Prfung bei  bereits vor dem Berichtssemester             abgelegten Abschlussprfungen an Hochschulen             (vorletzte Prfung).           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat_2015',
'ef100u2',
'ef100u2-Art der Prfung bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (vorletzte Prfung)-Abschluss',
'             Art der Prfung bei  bereits vor dem Berichtssemester             abgelegten Abschlussprfungen an Hochschulen             (vorletzte Prfung).           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat_2015',
'ef101',
'ef101-1. Studienfach bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (vorletzte Prfung).',
'             1. Studienfach bei  bereits vor dem Berichtssemester             abgelegten Abschlussprfungen an Hochschulen             (vorletzte Prfung).           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat_2015',
'ef102',
'ef102-2. Studienfach bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (vorletzte Prfung).',
'             2. Studienfach bei  bereits vor dem Berichtssemester             abgelegten Abschlussprfungen an Hochschulen             (vorletzte Prfung).           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat_2015',
'ef103',
'ef103-3. Studienfach bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (vorletzte Prfung).',
'             3. Studienfach bei  bereits vor dem Berichtssemester             abgelegten Abschlussprfungen an Hochschulen             (vorletzte Prfung).           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat_2015',
'ef104',
'ef104-Frei fr StL',
'Frei fr StL',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat_2015',
'ef105',
'ef105-Monat des Prfnugsabschlusses bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (vorletzte Prfung).',
'             Monat des Prfnugsabschlusses             bei  bereits vor dem Berichtssemester             abgelegten Abschlussprfungen an Hochschulen             (vorletzte Prfung).           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat_2015',
'ef106',
'ef106-Jahr des Prfungsabschlusses bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (vorletzte Prfung).',
'             Jahr des Prfungsabschlusses             bei  bereits vor dem Berichtssemester             abgelegten Abschlussprfungen an Hochschulen             (vorletzte Prfung).           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat_2015',
'ef107',
'ef107-Prfungsergebnis bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (vorletzte Prfung). 1 = insgesamt bestanden 2 = endgltig nicht bestanden',
'             Prfungsergebnis bei  bereits vor dem Berichtssemester             abgelegten Abschlussprfungen an Hochschulen             (vorletzte Prfung).             1 = insgesamt bestanden             2 = endgltig nicht bestanden           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat_2015',
'ef108',
'ef108-Gesamtnote bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (vorletzte Prfung). X,00',
'             Gesamtnote bei  bereits vor dem Berichtssemester             abgelegten Abschlussprfungen an Hochschulen             (vorletzte Prfung).             X,00           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat_2015',
'ef109',
'ef109-Jahr des ersten Erwerbs der HZB',
'Jahr des ersten Erwerbs der HZB',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat_2015',
'ef110',
'ef110-Art der HZB',
'Art der HZB',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat_2015',
'ef111u1',
'ef111u1-Erwerb der HZB Bundesland bzw. "99" fr Ausland',
'             Erwerb der HZB             Bundesland bzw. "99" fr Ausland           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat_2015',
'ef111u2',
'ef111u2-Erwerb der HZB Kreis (bei Erwerb in Deutschland) bzw. Staat (bei Erwerb im Ausland)',
'             Erwerb der HZB             Kreis (bei Erwerb in Deutschland)             bzw. Staat (bei Erwerb im Ausland)           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat_2015',
'ef112',
'ef112-Berufspraktische Ttigkeit vor dem Studium Art der Ttigkeit 1 = Berufsausbildung mit Abschluss sonst LEER',
'             Berufspraktische Ttigkeit vor dem Studium                          Art der Ttigkeit             1 = Berufsausbildung mit Abschluss             sonst LEER           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat_2015',
'ef113',
'ef113-Berufspraktische Ttigkeit vor dem Studium Art der Ttigkeit 1 = Praktikum oder Volontariat im Hinblick auf das derzeitige Studium sonst LEER',
'             Berufspraktische Ttigkeit vor dem Studium                          Art der Ttigkeit             1 = Praktikum oder Volontariat im Hinblick auf das derzeitige Studium             sonst LEER           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat_2015',
'ef114',
'ef114-Frei fr StL',
'Frei fr StL',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat_2015',
'ef115',
'ef115-Frei fr StL',
'Frei fr StL',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat_2015',
'ef116',
'ef116-Frei fr StL',
'Frei fr StL',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat_2015',
'ef117',
'ef117-Frei fr StL',
'Frei fr StL',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat_2015',
'ef118',
'ef118-Frei fr StL',
'Frei fr StL',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat_2015',
'ef119',
'ef119-Frei fr StL',
'Frei fr StL',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat_2015',
'ef120',
'ef120-Prfungsamt der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (1. Prfung)',
'             Prfungsamt der seit der letzten              Semestermeldung insgesamt              abgeschlossene Prfung(en).             (1. Prfung)           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat_2015',
'ef121',
'ef121-Anzahl der Fachsemester fr diese Prfung der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (1. Prfung)',
'             Anzahl der Fachsemester fr diese              Prfung der seit der letzten              Semestermeldung insgesamt              abgeschlossene Prfung(en).             (1. Prfung)           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat_2015',
'ef122',
'ef122-Anzahl der Fachsemester fr diese Prfung der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (1. Prfung)',
'             Anzahl der Fachsemester fr diese              Prfung der seit der letzten              Semestermeldung insgesamt              abgeschlossene Prfung(en).             (1. Prfung)           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat_2015',
'ef123',
'ef123-Anzahl der Fachsemester fr diese Prfung der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (1. Prfung) hier: Aus einem anderem Studiengang an einer deutschen Hochschule (einschl. Praxissemester)',
'             Anzahl der Fachsemester fr diese              Prfung der seit der letzten              Semestermeldung insgesamt              abgeschlossene Prfung(en).             (1. Prfung)                          hier: Aus einem anderem Studiengang ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat_2015',
'ef124',
'ef124-Anzahl der Fachsemester fr diese Prfung der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (1. Prfung) hier: Berufspraktische Ttigkeit vor der Einschreibungim Studiengang der Prfung, soweit als Praxissemester bewertet',
'             Anzahl der Fachsemester fr diese              Prfung der seit der letzten              Semestermeldung insgesamt              abgeschlossene Prfung(en).             (1. Prfung)                          hier: Berufspraktische Ttigkeit vor',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat_2015',
'ef125',
'ef125-Anzahl der Fachsemester fr diese Prfung der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (1. Prfung) hier: aus einem Auslandsstudium',
'             Anzahl der Fachsemester fr diese              Prfung der seit der letzten              Semestermeldung insgesamt              abgeschlossene Prfung(en).             (1. Prfung)                          hier: aus einem Auslandsstudium     ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat_2015',
'ef126u1',
'ef126u1-Art der Prfung der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (1. Prfung)-Studienform',
'             Art der Prfung der seit der letzten              Semestermeldung insgesamt              abgeschlossene Prfung(en).             (1. Prfung)           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat_2015',
'ef126u2',
'ef126u2-Art der Prfung der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (1. Prfung)-Abschluss',
'             Art der Prfung der seit der letzten              Semestermeldung insgesamt              abgeschlossene Prfung(en).             (1. Prfung)           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat_2015',
'ef127',
'ef127-1. Studienfach der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (1. Prfung)',
'             1. Studienfach der seit der letzten              Semestermeldung insgesamt              abgeschlossene Prfung(en).             (1. Prfung)           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat_2015',
'ef128',
'ef128-2. Studienfach der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (1. Prfung)',
'             2. Studienfach der seit der letzten              Semestermeldung insgesamt              abgeschlossene Prfung(en).             (1. Prfung)           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat_2015',
'ef129',
'ef129-3. Studienfach der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (1. Prfung)',
'             3. Studienfach der seit der letzten              Semestermeldung insgesamt              abgeschlossene Prfung(en).             (1. Prfung)           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat_2015',
'ef130',
'ef130-Frei fr StL',
'Frei fr StL',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat_2015',
'ef131',
'ef131-Frei fr StL',
'Frei fr StL',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat_2015',
'ef132',
'ef132-Monat des Prfungsabschlusses bei der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (1. Prfung)',
'             Monat des Prfungsabschlusses             bei der seit der letzten              Semestermeldung insgesamt              abgeschlossene Prfung(en).             (1. Prfung)           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat_2015',
'ef133',
'ef133-Jahr des Prfungsabschlusses bei der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (1. Prfung)',
'             Jahr des Prfungsabschlusses             bei der seit der letzten              Semestermeldung insgesamt              abgeschlossene Prfung(en).             (1. Prfung)           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat_2015',
'ef134',
'ef134-Prfungsergebnis bei der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (1. Prfung)',
'             Prfungsergebnis bei der seit der letzten              Semestermeldung insgesamt              abgeschlossene Prfung(en).             (1. Prfung)           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat_2015',
'ef135',
'ef135-Gesamtnote bei der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (1. Prfung) X,00',
'             Gesamtnote bei der seit der letzten              Semestermeldung insgesamt              abgeschlossene Prfung(en).             (1. Prfung)             X,00           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat_2015',
'ef136',
'ef136-Prfungsamt der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung)',
'             Prfungsamt der seit der letzten              Semestermeldung insgesamt              abgeschlossene Prfung(en).             (2. Prfung)           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat_2015',
'ef137',
'ef137-Anzahl der Fachsemester fr diese Prfung der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung)',
'             Anzahl der Fachsemester fr diese              Prfung der seit der letzten              Semestermeldung insgesamt              abgeschlossene Prfung(en).             (2. Prfung)           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat_2015',
'ef138',
'ef138-Anzahl der Fachsemester fr diese Prfung der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung)',
'             Anzahl der Fachsemester fr diese              Prfung der seit der letzten              Semestermeldung insgesamt              abgeschlossene Prfung(en).             (2. Prfung)           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat_2015',
'ef139',
'ef139-Anzahl der Fachsemester fr diese Prfung der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung) hier: Aus einem anderem Studiengang an einer deutschen Hochschule (einschl. Praxissemester)',
'             Anzahl der Fachsemester fr diese              Prfung der seit der letzten              Semestermeldung insgesamt              abgeschlossene Prfung(en).             (2. Prfung)                          hier: Aus einem anderem Studiengang ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat_2015',
'ef140',
'ef140-Anzahl der Fachsemester fr diese Prfung der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung) hier: Berufspraktische Ttigkeit vor der Einschreibungim Studiengang der Prfung, soweit als Praxissemester bewertet',
'             Anzahl der Fachsemester fr diese              Prfung der seit der letzten              Semestermeldung insgesamt              abgeschlossene Prfung(en).             (2. Prfung)                          hier: Berufspraktische Ttigkeit vor',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat_2015',
'ef141',
'ef141-Anzahl der Fachsemester fr diese Prfung der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung) hier: aus einem Auslandsstudium',
'             Anzahl der Fachsemester fr diese              Prfung der seit der letzten              Semestermeldung insgesamt              abgeschlossene Prfung(en).             (2. Prfung)                          hier: aus einem Auslandsstudium     ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat_2015',
'ef142u1',
'ef142u1-Art der Prfung der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung)-Studienform',
'             Art der Prfung der seit der letzten              Semestermeldung insgesamt              abgeschlossene Prfung(en).             (2. Prfung)           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat_2015',
'ef142u2',
'ef142u2-Art der Prfung der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung)-Abschluss',
'             Art der Prfung der seit der letzten              Semestermeldung insgesamt              abgeschlossene Prfung(en).             (2. Prfung)           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat_2015',
'ef143',
'ef143-1. Studienfach der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung)',
'             1. Studienfach der seit der letzten              Semestermeldung insgesamt              abgeschlossene Prfung(en).             (2. Prfung)           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat_2015',
'ef144',
'ef144-2. Studienfach der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung)',
'             2. Studienfach der seit der letzten              Semestermeldung insgesamt              abgeschlossene Prfung(en).             (2. Prfung)           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat_2015',
'ef145',
'ef145-3. Studienfach der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung)',
'             3. Studienfach der seit der letzten              Semestermeldung insgesamt              abgeschlossene Prfung(en).             (2. Prfung)           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat_2015',
'ef146',
'ef146-Frei fr StL',
'Frei fr StL',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat_2015',
'ef147',
'ef147-Frei fr StL',
'Frei fr StL',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat_2015',
'ef148',
'ef148-Monat des Prfungsabschlusses bei der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung)',
'             Monat des Prfungsabschlusses             bei der seit der letzten              Semestermeldung insgesamt              abgeschlossene Prfung(en).             (2. Prfung)           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat_2015',
'ef149',
'ef149-Jahr des Prfungsabschlusses bei der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung)',
'             Jahr des Prfungsabschlusses             bei der seit der letzten              Semestermeldung insgesamt              abgeschlossene Prfung(en).             (2. Prfung)           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat_2015',
'ef150',
'ef150-Prfungsergebnis bei der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung)',
'             Prfungsergebnis bei der seit der letzten              Semestermeldung insgesamt              abgeschlossene Prfung(en).             (2. Prfung)           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat_2015',
'ef151',
'ef151-Gesamtnote bei der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung) X,00',
'             Gesamtnote bei der seit der letzten              Semestermeldung insgesamt              abgeschlossene Prfung(en).             (2. Prfung)             X,00           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat_2015',
'ef152',
'ef152-Gesamtnote in Punkten bei der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung)',
'             Gesamtnote in Punkten             bei der seit der letzten              Semestermeldung insgesamt              abgeschlossene Prfung(en).             (2. Prfung)           ',
'varchar',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_astat_2015',
'id',
'id',
'',
'SERIAL',
'10',
1,
1,
0,
0);

update tmp_fields set is_primarykey=1 
where trim(table_name) || '_' || trim(name) ='kenn_sos_astat_2015_id';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_lab',
'hs_nr',
'Hochschulnummer',
'',
'INTEGER',
'4',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_hochschulen',
foreignkey_col='hs_nr',
foreignkey_cap='name',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_sos_lab_hs_nr';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_lab',
'studiengang_nr',
'Studiengang-Nummer',
'z.B. 2 fr 2. Studiengang',
'SMALLINT',
'2',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_lab',
'fach_nr',
'Fach-Nummer',
'z.B. 2 fr 2. Fach',
'SMALLINT',
'2',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_lab',
'geschlecht',
'Geschlecht (1 mnnl.,2 weibl.)',
'',
'SMALLINT',
'2',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_geschlecht',
foreignkey_col='apnr',
foreignkey_cap='name',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_sos_lab_geschlecht';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_lab',
'ca12_staat',
'Nationalitt',
'0=Deutsch,1=Ausland',
'SMALLINT',
'2',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_staat',
foreignkey_col='astat',
foreignkey_cap='name',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_sos_lab_ca12_staat';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_lab',
'sem_der_pruefung',
'Semester',
'Schlssel, siehe Tab. kenn_semester',
'SMALLINT',
'2',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_semester',
foreignkey_col='tid',
foreignkey_cap='druck',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_sos_lab_sem_der_pruefung';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_lab',
'stg',
'Fach (amtlich)',
'',
'CHAR',
'4',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_stg_astat',
foreignkey_col='astat',
foreignkey_cap='name',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_sos_lab_stg';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_lab',
'abschluss',
'Abschluss (amtlich)',
'',
'CHAR',
'2',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_abschl_astat',
foreignkey_col='astat',
foreignkey_cap='name',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_sos_lab_abschluss';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_lab',
'fach_sem_zahl',
'Dauer des Studiums in Fachsem.',
'',
'SMALLINT',
'2',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_lab',
'hzbart',
'Art der Hochschulzugangsber.',
'             SuperX-eigene Gruppierung:             hzbart=1 Allg. Hochschulreife,               hzbart=2 Fachhochschulreife,                                             hzbart=3 Fach(geb.) Hochschulreife im Ausl.,                             hzbart=4 All',
'CHAR',
'2',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_hzbart',
foreignkey_col='astat',
foreignkey_cap='name',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_sos_lab_hzbart';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_lab',
'kz_fach',
'Fachkennzeichen',
'Haupt-/Nebenfach (Amtl. Schlssel): H=Hauptfach, N=Nebenfach',
'CHAR',
'1',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_lab',
'regel',
'in der RSZ. BaWue: 0=nein, 1=ja,-1=unbekannt. Sachsen: -1=RSZ unbek., 0=ber der RSZ (+4),  1=in der RSZ,  2=RSZ +1,  3=RSZ +2,  4=RSZ +3 ',
'',
'SMALLINT',
'2',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_lab',
'datum',
'Datum der Erzeugung',
'Dieses Feld wird zur Archivierung von gelieferten Daten genutzt',
'date',
'4',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_lab',
'summe',
'Summe',
'',
'INTEGER',
'4',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_lab',
'extkost',
'Externe Kostenstelle',
'Nummer der Fakultt (nur Sachsen)',
'CHAR',
'30',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_lab',
'extkotr',
'Externer Produktschlssel',
'Nummer des externen Produktschlssels (nur Sachsen)',
'CHAR',
'30',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_lab',
'stufrm',
'Studienform ',
'Studienform W=Weiterbildung (nur Sachsen)',
'CHAR',
'10',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_stg',
'hs_nr',
'Hochschulnummer',
'',
'INTEGER',
'4',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_hochschulen',
foreignkey_col='hs_nr',
foreignkey_cap='name',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_sos_stg_hs_nr';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_stg',
'studiengang_nr',
'Studiengang-Nummer',
'z.B. 2 fr 2. Studiengang',
'SMALLINT',
'2',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_stg',
'fach_nr',
'Fach-Nummer',
'z.B. 2 fr 2. Fach',
'SMALLINT',
'2',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_stg',
'geschlecht',
'Geschlecht (1 mnnl.,2 weibl.)',
'',
'SMALLINT',
'2',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_geschlecht',
foreignkey_col='apnr',
foreignkey_cap='name',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_sos_stg_geschlecht';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_stg',
'ca12_staat',
'Nationalitt',
'',
'SMALLINT',
'2',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_staat',
foreignkey_col='astat',
foreignkey_cap='name',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_sos_stg_ca12_staat';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_stg',
'sem_rueck_beur_ein',
'Semester',
'Schlssel, siehe Tab. kenn_semester',
'SMALLINT',
'2',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_semester',
foreignkey_col='tid',
foreignkey_cap='druck',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_sos_stg_sem_rueck_beur_ein';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_stg',
'stg',
'Fach (amtlich)',
'',
'CHAR',
'4',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_stg_astat',
foreignkey_col='astat',
foreignkey_cap='name',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_sos_stg_stg';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_stg',
'abschluss',
'Abschluss (amtlich)',
'',
'CHAR',
'2',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_abschl_astat',
foreignkey_col='astat',
foreignkey_cap='name',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_sos_stg_abschluss';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_stg',
'regel',
'in der RSZ (0=nein, 1=ja,-1=unbekannt)',
'',
'SMALLINT',
'2',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_stg',
'hzbart',
'Art der Hochschulzugangsber.',
'             SuperX-eigene Gruppierung:             hzbart=1 Allg. Hochschulreife,               hzbart=2 Fachhochschulreife,                                             hzbart=3 Fach(geb.) Hochschulreife im Ausl.,                             hzbart=4 All',
'SMALLINT',
'2',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_hzbart',
foreignkey_col='astat',
foreignkey_cap='name',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_sos_stg_hzbart';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_stg',
'kz_rueck_beur_ein',
'Einschreib- oder Rckmeldestatus',
'1=Ersteinschr.,2=Neueinschreiber,3=Rckmelder,4=Beurlaubt,5=Exmatr.',
'SMALLINT',
'2',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_status',
foreignkey_col='tid',
foreignkey_cap='eintrag',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_sos_stg_kz_rueck_beur_ein';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_stg',
'fach_sem_zahl',
'Anzahl Fachsemester',
'',
'SMALLINT',
'2',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_stg',
'hssem',
'Anzahl Hochschulsemester',
'',
'SMALLINT',
'2',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_stg',
'kz_fach',
'Fachkennzeichen',
'Haupt-/Nebenfach (Amtl. Schlssel)',
'CHAR',
'1',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_stg',
'datum',
'Datum der Erzeugung',
'Dieses Feld wird zur Archivierung von gelieferten Daten genutzt',
'date',
'4',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_stg',
'summe',
'Summe',
'',
'INTEGER',
'4',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_stg',
'extkost',
'Externe Kostenstelle',
'Nummer der Fakultt (nur Sachsen)',
'CHAR',
'30',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_stg',
'extkotr',
'Externer Produktschlssel',
'Nummer des externen Produktschlssels (nur Sachsen)',
'CHAR',
'30',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_stg',
'stufrm',
'Studienform ',
'Studienform W=Weiterbildung (nur Sachsen)',
'CHAR',
'10',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_sos_stg',
'hrst',
'Hrerstatus',
'Hrerstatus (amtlich)',
'CHAR',
'10',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_cifx',
foreignkey_col='apnr',
foreignkey_cap='druck',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_sos_stg_hrst';

update tmp_fields set foreignkey_cond='674=kenn_cifx.key'
where trim(table_name) || '_' || trim(name) ='kenn_sos_stg_hrst'
and trim(foreignkey_tab) = 'kenn_cifx';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_staat',
'astat',
'astat',
'Krzel',
'CHAR',
'10',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_staat',
'druck',
'druck',
'Druckbeschreibung',
'CHAR',
'150',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_staat',
'erdteil',
'erdteil',
'Kontinent',
'CHAR',
'10',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_staat',
'd_akt_von',
'gltig von',
'',
'DATE',
'4',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_staat',
'd_akt_bis',
'gltig bis',
'',
'DATE',
'4',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_status',
'tid',
'tid',
'Schlssel',
'INTEGER',
'4',
1,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_status',
'apnr',
'apnr',
'Schlssel Geschlecht',
'CHAR',
'200',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_status',
'eintrag',
'eintrag',
'Beschreibung',
'CHAR',
'200',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stbb_kap_titel_bericht',
'hs_nr',
'Hochschulnummer',
'',
'INTEGER',
'10',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stbb_kap_titel_bericht',
'kapitel',
'Kapitel',
'',
'VARCHAR',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stbb_kap_titel_bericht',
'titel',
'Titel',
'',
'VARCHAR',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stbb_kap_titel_bericht',
'berichtsname',
'Berichtsname',
'',
'VARCHAR',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stbb_kap_titel_bericht',
'berichtsname_key',
'Berichtsname (Schlssel)',
'',
'VARCHAR',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stelle_bvl_bez',
'id',
'id',
'',
'SERIAL',
'10',
1,
1,
0,
0);

update tmp_fields set is_primarykey=1 
where trim(table_name) || '_' || trim(name) ='kenn_stelle_bvl_bez_id';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stelle_bvl_bez',
'sortnr',
'sortnr',
'',
'integer',
'10',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stelle_bvl_bez',
'kapitel',
'Kapitel',
'',
'VARCHAR',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stelle_bvl_bez',
'titel',
'Titel',
'',
'VARCHAR',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stelle_bvl_bez',
'bez',
'Bezeichnung (hochschulunabhngig)',
'',
'VARCHAR',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stelle_bvl_bez',
'bvl_stelle_kurz',
'Kurztext der BVL-Gruppe',
'z.B. "W 3"',
'VARCHAR',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stelle_bvl_bez',
'hs_nr',
'Hochschulnummer',
'',
'INTEGER',
'10',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stelle_bvl_bez',
'bez_hs',
'Bezeichnung der Stellengruppe an der jew. Hochschule',
'z.B. Rektor der Uni Leipzig',
'VARCHAR',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stelle_bvl_bez',
'adbz_land',
'Untergruppierung der BVL-Gruppe',
'z.B. "R" fr Rektor der Uni Leipzig',
'VARCHAR',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stelle_bvl_bez',
'optional',
'Zeile optional im STBB?',
'',
'INTEGER',
'10',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stelle_bvl_bez',
'zeilenkontext',
'Zeilen innerhalb werden wei formatiert, Zeilen auserhalb grau. Innerhalb bedeutet --> zwischen Zeilen, welche in der gewhlten Berichtsart Stellen ausweisen.',
'',
'VARCHAR',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stelle_bvl_bez',
'gueltig_von',
'Gltig von',
'',
'DATE',
'13',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stelle_bvl_bez',
'gueltig_bis',
'Gltig bis',
'',
'DATE',
'13',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stelle_hhpl',
'kapitel',
'Kapitel',
'lt. Landeshaushalt',
'CHAR',
'10',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stelle_hhpl',
'titel',
'Titel der Stelle',
'Nur NHS Sachsen',
'CHAR',
'10',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stelle_hhpl',
'hs_nr',
'Hochschulnummer',
'',
'INTEGER',
'10',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stelle_hhpl',
'bvl_stelle_kurz',
'Kurztext der BVL-Gruppe',
'z.B. "W 3"',
'VARCHAR',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stelle_hhpl',
'adbz_land',
'Untergruppierung der BVL-Gruppe',
'z.B. "R" fr Rektor der Uni Leipzig',
'VARCHAR',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stelle_hhpl',
'summe',
'Summe',
'',
'FLOAT',
'10',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stelle_hhpl',
'jahr_von',
'Jahr von',
'',
'INTEGER',
'13',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stelle_hhpl',
'jahr_bis',
'Jahr bis',
'',
'INTEGER',
'13',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stelle_hhpl',
'datum',
'Datum der Berechnung',
'',
'date',
'13',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stg_aggr',
'hs_nr',
'Hochschule',
'Hochschulnummer',
'INTEGER',
'4',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_hochschulen',
foreignkey_col='hs_nr',
foreignkey_cap='name',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_stg_aggr_hs_nr';

update tmp_fields set foreignkey_cond='kz_fach_int=kenn_kzfach_int.apnr'
where trim(table_name) || '_' || trim(name) ='kenn_stg_aggr_hs_nr'
and trim(foreignkey_tab) = 'kenn_kzfach_int';

update tmp_fields set foreignkey_cond='vertfg=kenn_vert_int.apnr'
where trim(table_name) || '_' || trim(name) ='kenn_stg_aggr_hs_nr'
and trim(foreignkey_tab) = 'kenn_vert_int';

update tmp_fields set foreignkey_cond='stort=kenn_stort.apnr'
where trim(table_name) || '_' || trim(name) ='kenn_stg_aggr_hs_nr'
and trim(foreignkey_tab) = 'kenn_stort';

update tmp_fields set foreignkey_cond='stg_int=kenn_stg_int.apnr'
where trim(table_name) || '_' || trim(name) ='kenn_stg_aggr_hs_nr'
and trim(foreignkey_tab) = 'kenn_stg_int';

update tmp_fields set foreignkey_cond='abint=kenn_abint.apnr'
where trim(table_name) || '_' || trim(name) ='kenn_stg_aggr_hs_nr'
and trim(foreignkey_tab) = 'kenn_abint';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stg_aggr',
'studiengang_nr',
'Studiengang-Nummer',
'z.B. 2 fr 2. Studiengang',
'SMALLINT',
'2',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stg_aggr',
'fach_nr',
'Fach-Nummer',
'z.B. 2 fr 2. Fach',
'SMALLINT',
'2',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stg_aggr',
'geschlecht',
'Geschlecht',
'1 mnnl.,2 weibl.',
'SMALLINT',
'2',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_geschl',
foreignkey_col='apnr',
foreignkey_cap='druck',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_stg_aggr_geschlecht';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stg_aggr',
'ca12_staat',
'Nationalitt',
'',
'SMALLINT',
'2',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_staat',
foreignkey_col='astat',
foreignkey_cap='druck',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_stg_aggr_ca12_staat';

update tmp_fields set foreignkey_func='val'
where trim(table_name) || '_' || trim(name) ='kenn_stg_aggr_ca12_staat';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stg_aggr',
'sem_rueck_beur_ein',
'Semester',
'Schlssel, siehe Tab. kenn_semester',
'SMALLINT',
'2',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_semester',
foreignkey_col='tid',
foreignkey_cap='druck',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_stg_aggr_sem_rueck_beur_ein';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stg_aggr',
'stg',
'Fach (amtlich)',
'',
'CHAR',
'4',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_stg_astat',
foreignkey_col='astat',
foreignkey_cap='dtxt',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_stg_aggr_stg';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stg_aggr',
'abschluss',
'Abschluss (amtlich)',
'',
'CHAR',
'2',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_abschl_astat',
foreignkey_col='astat',
foreignkey_cap='dtxt',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_stg_aggr_abschluss';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stg_aggr',
'regel',
'in der RSZ',
'0=nein, 1=ja,-1=unbekannt',
'SMALLINT',
'2',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stg_aggr',
'hzbart',
'Art der Hochschulzugangsber.',
'             SuperX-eigene Gruppierung:             hzbart=1 Allg. Hochschulreife,               hzbart=2 Fachhochschulreife,                                             hzbart=3 Fach(geb.) Hochschulreife im Ausl.,                             hzbart=4 All',
'SMALLINT',
'2',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_hzbart',
foreignkey_col='astat',
foreignkey_cap='druck',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_stg_aggr_hzbart';

update tmp_fields set foreignkey_func='val'
where trim(table_name) || '_' || trim(name) ='kenn_stg_aggr_hzbart';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stg_aggr',
'kz_rueck_beur_ein',
'Einschreib- oder Rckmeldestatus',
'1=Ersteinschr.,2=Neueinschreiber,3=Rckmelder,4=Beurlaubt,5=Exmatr.',
'SMALLINT',
'2',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_status',
foreignkey_col='tid',
foreignkey_cap='eintrag',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_stg_aggr_kz_rueck_beur_ein';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stg_aggr',
'fach_sem_zahl',
'Anzahl Fachsemester',
'',
'SMALLINT',
'2',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stg_aggr',
'hssem',
'Anzahl Hochschulsemester',
'',
'SMALLINT',
'2',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stg_aggr',
'kz_fach',
'Fachkennzeichen',
'Haupt-/Nebenfach (Amtl. Schlssel)',
'CHAR',
'1',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_kzfa',
foreignkey_col='astat',
foreignkey_cap='druck',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_stg_aggr_kz_fach';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stg_aggr',
'stort',
'Standort',
'Hochschulstandort (amtlich)',
'CHAR',
'10',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_stort',
foreignkey_col='apnr',
foreignkey_cap='druck',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_stg_aggr_stort';

update tmp_fields set foreignkey_cond='hs_nr=kenn_stort.hs_nr'
where trim(table_name) || '_' || trim(name) ='kenn_stg_aggr_stort'
and trim(foreignkey_tab) = 'kenn_stort';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stg_aggr',
'stuart',
'Studienart (amtlich)',
'Studienart (amtlich)',
'CHAR',
'10',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_stuart',
foreignkey_col='apnr',
foreignkey_cap='druck',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_stg_aggr_stuart';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stg_aggr',
'stufrm',
'Studienform (amtlich)',
'Studienform (amtlich)',
'CHAR',
'10',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_stufrm',
foreignkey_col='apnr',
foreignkey_cap='druck',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_stg_aggr_stufrm';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stg_aggr',
'stg_int',
'Fach (intern)',
'Fach (intern)',
'CHAR',
'10',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_stg_int',
foreignkey_col='apnr',
foreignkey_cap='druck',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_stg_aggr_stg_int';

update tmp_fields set foreignkey_cond='hs_nr=kenn_stg_int.hs_nr'
where trim(table_name) || '_' || trim(name) ='kenn_stg_aggr_stg_int'
and trim(foreignkey_tab) = 'kenn_stg_int';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stg_aggr',
'abint',
'Abschluss (intern)',
'Abschluss (intern)',
'CHAR',
'10',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_abint',
foreignkey_col='apnr',
foreignkey_cap='druck',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_stg_aggr_abint';

update tmp_fields set foreignkey_cond='hs_nr=kenn_abint.hs_nr'
where trim(table_name) || '_' || trim(name) ='kenn_stg_aggr_abint'
and trim(foreignkey_tab) = 'kenn_abint';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stg_aggr',
'hzbart_astat',
'Hochschulzugangsberechtigung',
'Hochschulzugangsberechtigung (amtlich)',
'CHAR',
'10',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_hzbart_astat_akt',
foreignkey_col='apnr',
foreignkey_cap='druck',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_stg_aggr_hzbart_astat';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stg_aggr',
'hrst',
'Hrerstatus',
'Hrerstatus (amtlich)',
'CHAR',
'10',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_cifx',
foreignkey_col='apnr',
foreignkey_cap='druck',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_stg_aggr_hrst';

update tmp_fields set foreignkey_cond='674=kenn_cifx.key'
where trim(table_name) || '_' || trim(name) ='kenn_stg_aggr_hrst'
and trim(foreignkey_tab) = 'kenn_cifx';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stg_aggr',
'datum',
'Datum der Erzeugung',
'Dieses Feld wird zur Archivierung von gelieferten Daten genutzt',
'date',
'4',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stg_aggr',
'summe',
'Summe',
'',
'INTEGER',
'4',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stg_aggr',
'kz_fach_int',
'Fachkennzeichen (intern)',
'Haupt-/Nebenfach (intern)',
'CHAR',
'10',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_kzfach_int',
foreignkey_col='apnr',
foreignkey_cap='druck',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_stg_aggr_kz_fach_int';

update tmp_fields set foreignkey_cond='hs_nr=kenn_kzfach_int.hs_nr'
where trim(table_name) || '_' || trim(name) ='kenn_stg_aggr_kz_fach_int'
and trim(foreignkey_tab) = 'kenn_kzfach_int';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stg_aggr',
'vertfg',
'Vertiefung',
'Vertiefung (intern)',
'CHAR',
'10',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_vert_int',
foreignkey_col='apnr',
foreignkey_cap='druck',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_stg_aggr_vertfg';

update tmp_fields set foreignkey_cond='hs_nr=kenn_vert_int.hs_nr'
where trim(table_name) || '_' || trim(name) ='kenn_stg_aggr_vertfg'
and trim(foreignkey_tab) = 'kenn_vert_int';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stg_aggr',
'stg_land',
'Fach Land (amtlich)',
'',
'CHAR',
'4',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='k_astat_studienfach_land_l',
foreignkey_col='schluessel',
foreignkey_cap='name',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_stg_aggr_stg_land';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stg_aggr_astat',
'hs_nr',
'Hochschule',
'Hochschulnummer',
'INTEGER',
'4',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_hochschulen',
foreignkey_col='hs_nr',
foreignkey_cap='name',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_stg_aggr_astat_hs_nr';

update tmp_fields set foreignkey_cond='stort=kenn_stort.apnr'
where trim(table_name) || '_' || trim(name) ='kenn_stg_aggr_astat_hs_nr'
and trim(foreignkey_tab) = 'kenn_stort';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stg_aggr_astat',
'studiengang_nr',
'Studiengang-Nummer',
'z.B. 2 fr 2. Studiengang',
'SMALLINT',
'2',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stg_aggr_astat',
'fach_nr',
'Fach-Nummer',
'z.B. 2 fr 2. Fach',
'SMALLINT',
'2',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stg_aggr_astat',
'geschlecht',
'Geschlecht',
'1 mnnl.,2 weibl.',
'SMALLINT',
'2',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_geschl',
foreignkey_col='apnr',
foreignkey_cap='druck',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_stg_aggr_astat_geschlecht';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stg_aggr_astat',
'ca12_staat',
'Nationalitt',
'',
'SMALLINT',
'2',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_staat',
foreignkey_col='astat',
foreignkey_cap='druck',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_stg_aggr_astat_ca12_staat';

update tmp_fields set foreignkey_func='val'
where trim(table_name) || '_' || trim(name) ='kenn_stg_aggr_astat_ca12_staat';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stg_aggr_astat',
'sem_rueck_beur_ein',
'Semester',
'Schlssel, siehe Tab. kenn_semester',
'SMALLINT',
'2',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_semester',
foreignkey_col='tid',
foreignkey_cap='druck',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_stg_aggr_astat_sem_rueck_beur_ein';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stg_aggr_astat',
'stg',
'Fach (amtlich)',
'',
'CHAR',
'4',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_stg_astat',
foreignkey_col='astat',
foreignkey_cap='dtxt',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_stg_aggr_astat_stg';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stg_aggr_astat',
'abschluss',
'Abschluss (amtlich)',
'',
'CHAR',
'2',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_abschl_astat',
foreignkey_col='astat',
foreignkey_cap='dtxt',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_stg_aggr_astat_abschluss';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stg_aggr_astat',
'fgr',
'Fchergruppe',
'',
'CHAR',
'10',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_dim_fgr',
foreignkey_col='apnr',
foreignkey_cap='drucktext',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_stg_aggr_astat_fgr';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stg_aggr_astat',
'abgrp',
'Abschlussart',
'Bachelor, Master, Sonstige',
'CHAR',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stg_aggr_astat',
'regel',
'Regelstudienzeit',
'',
'SMALLINT',
'2',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stg_aggr_astat',
'kz_rueck_beur_ein',
'Einschreib- oder Rckmeldestatus',
'1=Ersteinschr.,2=Neueinschreiber,3=Rckmelder,4=Beurlaubt,5=Exmatr.',
'SMALLINT',
'2',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_status',
foreignkey_col='tid',
foreignkey_cap='eintrag',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_stg_aggr_astat_kz_rueck_beur_ein';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stg_aggr_astat',
'fach_sem_zahl',
'Anzahl Fachsemester',
'',
'SMALLINT',
'2',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stg_aggr_astat',
'hssem',
'Anzahl Hochschulsemester',
'',
'SMALLINT',
'2',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stg_aggr_astat',
'stort',
'Standort',
'Hochschulstandort (amtlich)',
'CHAR',
'10',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_stort',
foreignkey_col='apnr',
foreignkey_cap='druck',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_stg_aggr_astat_stort';

update tmp_fields set foreignkey_cond='hs_nr=kenn_stort.hs_nr'
where trim(table_name) || '_' || trim(name) ='kenn_stg_aggr_astat_stort'
and trim(foreignkey_tab) = 'kenn_stort';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stg_aggr_astat',
'stuart',
'Studienart (amtlich)',
'Studienart (amtlich)',
'CHAR',
'10',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_stuart',
foreignkey_col='apnr',
foreignkey_cap='druck',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_stg_aggr_astat_stuart';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stg_aggr_astat',
'stufrm',
'Studienform (amtlich)',
'Studienform (amtlich)',
'CHAR',
'10',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_stufrm',
foreignkey_col='apnr',
foreignkey_cap='druck',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_stg_aggr_astat_stufrm';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stg_aggr_astat',
'hzbart_astat',
'Hochschulzugangsberechtigung Art',
'Hochschulzugangsberechtigung (amtlich)',
'CHAR',
'10',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_hzbart_astat_akt',
foreignkey_col='apnr',
foreignkey_cap='druck',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_stg_aggr_astat_hzbart_astat';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stg_aggr_astat',
'hzbkfzkz',
'Hochschulzugangsberechtigung Land',
'Bundesland der Hochschulzugangsberechtigung (amtlich), bei Ausland 99. ef119 Stelle 1 und 2',
'CHAR',
'2',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stg_aggr_astat',
'hrst',
'Hrerstatus',
'Hrerstatus (amtlich)',
'CHAR',
'10',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_cifx',
foreignkey_col='apnr',
foreignkey_cap='druck',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_stg_aggr_astat_hrst';

update tmp_fields set foreignkey_cond='674=kenn_cifx.key'
where trim(table_name) || '_' || trim(name) ='kenn_stg_aggr_astat_hrst'
and trim(foreignkey_tab) = 'kenn_cifx';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stg_aggr_astat',
'letzte_pruefung_stort',
'Letzte Externe Prfung Hochschule/Standort',
'ef089',
'CHAR',
'10',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stg_aggr_astat',
'letzte_pruefung_staat',
'Letzte Externe Prfung Staat',
'nur wenn Ausland ef090',
'SMALLINT',
'2',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stg_aggr_astat',
'letzte_pruefung_abschluss',
'Letzte Externe Prfung Abschluss (amtlich)',
'Bereits vor dem Berichtssemester abgelegte Abschlussprfungen an Hochschulen ef091',
'CHAR',
'2',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stg_aggr_astat',
'letzte_pruefung_ergebnis',
'Letzte Externe Prfung Prfungsergebnis',
'Erfolgreich=1,endgltig nicht bestanden=2 ef097',
'SMALLINT',
'2',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stg_aggr_astat',
'vorletzte_pruefung_stort',
'Vorletzte Externe Prfung Hochschule/Standort',
'ef103',
'CHAR',
'10',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stg_aggr_astat',
'vorletzte_pruefung_staat',
'Vorletzte Externe Prfung Staat',
'nur wenn Ausland ef104',
'SMALLINT',
'2',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stg_aggr_astat',
'vorletzte_pruefung_abschluss',
'Vorletzte Externe Prfung Abschluss (amtlich)',
'Bereits vor dem Berichtssemester abgelegte Abschlussprfungen an Hochschulen ef105',
'CHAR',
'2',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stg_aggr_astat',
'vorletzte_pruefung_ergebnis',
'Vorletzte Externe Prfung Prfungsergebnis',
'Erfolgreich=1,endgltig nicht bestanden=2 ef107',
'SMALLINT',
'2',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stg_aggr_astat',
'datum',
'Datum der Erzeugung',
'Dieses Feld wird zur Archivierung von gelieferten Daten genutzt',
'date',
'4',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stg_aggr_astat',
'summe',
'Summe',
'',
'INTEGER',
'4',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stg_aggr_astat',
'stg_land',
'Fach Land (amtlich)',
'',
'CHAR',
'4',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='k_astat_studienfach_land_l',
foreignkey_col='schluessel',
foreignkey_cap='name',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_stg_aggr_astat_stg_land';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stg_cube',
'hs_nr',
'Hochschulen Namen',
'EDUDATA-Merkmal Nummer 405',
'INTEGER',
'4',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='dim_hochschule',
foreignkey_col='hs_nr',
foreignkey_cap='name',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_stg_cube_hs_nr';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stg_cube',
'ca12_staat',
'Staatsangehrigkeit (weltweit)',
'EDUDATA-Merkmal Nummer 410',
'INTEGER',
'4',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='cif',
foreignkey_col='apnr',
foreignkey_cap='druck',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_stg_cube_ca12_staat';

update tmp_fields set foreignkey_cond='12=cif.key'
where trim(table_name) || '_' || trim(name) ='kenn_stg_cube_ca12_staat'
and trim(foreignkey_tab) = 'cif';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stg_cube',
'geschlecht',
'Geschlecht',
'EDUDATA-Merkmal Nummer 501',
'INTEGER',
'4',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='cif',
foreignkey_col='apnr',
foreignkey_cap='druck',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_stg_cube_geschlecht';

update tmp_fields set foreignkey_cond='9003=cif.key'
where trim(table_name) || '_' || trim(name) ='kenn_stg_cube_geschlecht'
and trim(foreignkey_tab) = 'cif';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stg_cube',
'hzbart',
'Hochschulzugangsberechtigung',
'EDUDATA-Merkmal Nummer 806',
'INTEGER',
'4',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='cif',
foreignkey_col='apnr',
foreignkey_cap='druck',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_stg_cube_hzbart';

update tmp_fields set foreignkey_cond='652=cif.key'
where trim(table_name) || '_' || trim(name) ='kenn_stg_cube_hzbart'
and trim(foreignkey_tab) = 'cif';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stg_cube',
'studiengang_nr',
'Studiengang Nr.',
'EDUDATA-Merkmal Nummer 373',
'INTEGER',
'4',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='cif',
foreignkey_col='apnr',
foreignkey_cap='druck',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_stg_cube_studiengang_nr';

update tmp_fields set foreignkey_cond='653=cif.key'
where trim(table_name) || '_' || trim(name) ='kenn_stg_cube_studiengang_nr'
and trim(foreignkey_tab) = 'cif';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stg_cube',
'fach_nr',
'Studienfachnummer',
'EDUDATA-Merkmal Nummer 372',
'INTEGER',
'4',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='cif',
foreignkey_col='apnr',
foreignkey_cap='druck',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_stg_cube_fach_nr';

update tmp_fields set foreignkey_cond='654=cif.key'
where trim(table_name) || '_' || trim(name) ='kenn_stg_cube_fach_nr'
and trim(foreignkey_tab) = 'cif';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stg_cube',
'fach_sem_zahl',
'Studiensem. nach Fachsem.',
'EDUDATA-Merkmal Nummer 112',
'INTEGER',
'4',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='cif',
foreignkey_col='apnr',
foreignkey_cap='druck',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_stg_cube_fach_sem_zahl';

update tmp_fields set foreignkey_cond='655=cif.key'
where trim(table_name) || '_' || trim(name) ='kenn_stg_cube_fach_sem_zahl'
and trim(foreignkey_tab) = 'cif';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stg_cube',
'sem_rueck_beur_ein',
'Zeitpunkt semesterweise',
'EDUDATA-Merkmal Nummer 604',
'INTEGER',
'4',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='cif',
foreignkey_col='apnr',
foreignkey_cap='druck',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_stg_cube_sem_rueck_beur_ein';

update tmp_fields set foreignkey_cond='661=cif.key'
where trim(table_name) || '_' || trim(name) ='kenn_stg_cube_sem_rueck_beur_ein'
and trim(foreignkey_tab) = 'cif';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stg_cube',
'kz_rueck_beur_ein',
'Einschreib/Rckmeldestatus',
'EDUDATA-Merkmal Nummer 815',
'INTEGER',
'4',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='cifx',
foreignkey_col='astat',
foreignkey_cap='druck',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_stg_cube_kz_rueck_beur_ein';

update tmp_fields set foreignkey_func='val'
where trim(table_name) || '_' || trim(name) ='kenn_stg_cube_kz_rueck_beur_ein';

update tmp_fields set foreignkey_cond='9001=cifx.key'
where trim(table_name) || '_' || trim(name) ='kenn_stg_cube_kz_rueck_beur_ein'
and trim(foreignkey_tab) = 'cifx';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stg_cube',
'hssem',
'Studiensem. nach Hochschulsem.',
'EDUDATA-Merkmal Nummer 111',
'INTEGER',
'4',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='cif',
foreignkey_col='apnr',
foreignkey_cap='druck',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_stg_cube_hssem';

update tmp_fields set foreignkey_cond='657=cif.key'
where trim(table_name) || '_' || trim(name) ='kenn_stg_cube_hssem'
and trim(foreignkey_tab) = 'cif';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stg_cube',
'stufrm_astat',
'Studienform (amtlich)',
'EDUDATA-Merkmal Nummer 870',
'INTEGER',
'4',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_stufrm',
foreignkey_col='apnr',
foreignkey_cap='druck',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_stg_cube_stufrm_astat';

update tmp_fields set foreignkey_int='tid'
where trim(table_name) || '_' || trim(name) ='kenn_stg_cube_stufrm_astat';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stg_cube',
'stg_astat',
'Studienfach (amtlich)',
'EDUDATA-Merkmal Nummer 871',
'INTEGER',
'4',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_stg_astat',
foreignkey_col='astat',
foreignkey_cap='dtxt',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_stg_cube_stg_astat';

update tmp_fields set foreignkey_int='tid'
where trim(table_name) || '_' || trim(name) ='kenn_stg_cube_stg_astat';

update tmp_fields set foreignkey_cond='''Fach (amtlich)''=kenn_stg_astat.struktur_c'
where trim(table_name) || '_' || trim(name) ='kenn_stg_cube_stg_astat'
and trim(foreignkey_tab) = 'kenn_stg_astat';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stg_cube',
'kz_fach_astat',
'Fachkennzeichen (amtlich)',
'EDUDATA-Merkmal Nummer 872',
'INTEGER',
'4',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_kzfa',
foreignkey_col='astat',
foreignkey_cap='druck',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_stg_cube_kz_fach_astat';

update tmp_fields set foreignkey_int='tid'
where trim(table_name) || '_' || trim(name) ='kenn_stg_cube_kz_fach_astat';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stg_cube',
'abschluss_astat',
'Studienabschluss (amtlich)',
'EDUDATA-Merkmal Nummer 873',
'INTEGER',
'4',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_abschl_astat',
foreignkey_col='astat',
foreignkey_cap='dtxt',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_stg_cube_abschluss_astat';

update tmp_fields set foreignkey_int='tid'
where trim(table_name) || '_' || trim(name) ='kenn_stg_cube_abschluss_astat';

update tmp_fields set foreignkey_cond='''Abschluss (amtlich)''=kenn_abschl_astat.struktur_c'
where trim(table_name) || '_' || trim(name) ='kenn_stg_cube_abschluss_astat'
and trim(foreignkey_tab) = 'kenn_abschl_astat';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stg_cube',
'rsz',
'Regelstudienzeit',
'EDUDATA-Merkmal Nummer 805',
'INTEGER',
'4',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='cif',
foreignkey_col='apnr',
foreignkey_cap='druck',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_stg_cube_rsz';

update tmp_fields set foreignkey_cond='658=cif.key'
where trim(table_name) || '_' || trim(name) ='kenn_stg_cube_rsz'
and trim(foreignkey_tab) = 'cif';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stg_cube',
'extkotr',
'Ext. Kostentrger',
'EDUDATA-Merkmal Nummer 874',
'INTEGER',
'10',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_extkotr',
foreignkey_col='key',
foreignkey_cap='name',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_stg_cube_extkotr';

update tmp_fields set foreignkey_int='tid'
where trim(table_name) || '_' || trim(name) ='kenn_stg_cube_extkotr';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stg_cube',
'summe',
'Summe',
'',
'DECIMAL',
'(16,2)',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stg_int',
'hs_nr',
'Hochschulnummer',
'',
'INTEGER',
'4',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stg_int',
'apnr',
'Fach (intern)',
'Schlssel Fach',
'CHAR',
'10',
1,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stg_int',
'druck',
'Fachbezeichnung',
'Drucktext',
'VARCHAR',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stg_int',
'astat',
'Fach (amtlich) ',
'Amtlicher Schlssel',
'CHAR',
'10',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stg_int',
'abint',
'Abschluss (intern)',
'Schlssel Abschluss, wenn Fach in Anhngigkeit von Abschluss unterschiedliche ASTAT-Werte hat',
'CHAR',
'10',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stg_int',
'datum',
'Datum der Erzeugung',
'Dieses Feld wird zur Archivierung von gelieferten Daten genutzt',
'date',
'4',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stichtag',
'tid',
'Schlssel',
'',
'SERIAL',
'4',
0,
1,
0,
0);

update tmp_fields set is_primarykey=1 
where trim(table_name) || '_' || trim(name) ='kenn_stichtag_tid';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stichtag',
'stichtag',
'Stichtag',
'Datum des Stichtags',
'DATE',
'4',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stichtag',
'bezugszeit',
'Bezug des Stichtags',
'Semester/Haushaltsjahr/Quartal/Monat',
'SMALLINT',
'4',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_bezugszeit',
foreignkey_col='bezugszeit',
foreignkey_cap='druck',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_stichtag_bezugszeit';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stichtag',
'bezugsart',
'Bezugsart (Semester S,Jahr J, Quartal Q, Monat M)',
'',
'CHAR',
'1',
1,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stichtag',
'stichtagsart',
'Art des Stichtags',
'Studierendenstat./Prfungsstat./Haushalt etc.',
'CHAR',
'100',
0,
0,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stichtag',
'berechnen',
'Berechnen?',
'Soll die Statistik neu berechnet werden? (1=j,0,nein)',
'CHAR',
'1',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stichtag',
'exportieren',
'Exportieren?',
'Soll die Statistik im Unload-Job exportiert werden? (1=j,0,nein)',
'CHAR',
'1',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stichtag',
'stichtagsart_id',
'Stichtagsart',
'Studierendenstat./Prfungsstat./Haushalt etc.',
'CHAR',
'40',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_stichtagsart',
foreignkey_col='apnr',
foreignkey_cap='druck',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_stichtag_stichtagsart_id';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stichtagsart',
'apnr',
'Schlssel Stichtagsart',
'',
'CHAR',
'40',
1,
1,
0,
0);

update tmp_fields set is_primarykey=1 
where trim(table_name) || '_' || trim(name) ='kenn_stichtagsart_apnr';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stichtagsart',
'kurz',
'kurz',
'',
'VARCHAR',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stichtagsart',
'druck',
'druck',
'',
'VARCHAR',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stichtagsart',
'beschreibung',
'beschreibung',
'',
'VARCHAR',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stichtagsart',
'bezugsart',
'Bezugsart (Semester S, Akad. Jahr A,Jahr J, Quartal Q, Monat M)',
'',
'CHAR',
'1',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stichtagsart',
'aktiv',
'Aktiv (1,0)',
'',
'CHAR',
'1',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stichtagsart',
'berechnen',
'Berechnen mglich?',
'1=Ja,0=Nein',
'CHAR',
'1',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stichtagsart',
'datum_wird_ausgewertet',
'Datum wird ausgewertet?',
'1=Ja,0=Nein',
'SMALLINT',
'1',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stort',
'tid',
'Tupelidentifier',
'',
'SERIAL',
'4',
1,
1,
0,
0);

update tmp_fields set is_primarykey=1 
where trim(table_name) || '_' || trim(name) ='kenn_stort_tid';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stort',
'bland',
'Bundesland',
'',
'INTEGER',
'4',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stort',
'apnr',
'Schlssel Standort',
'Schlssel des Standortes',
'CHAR',
'10',
1,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stort',
'druck',
'Bezeichnung',
'Drucktext',
'VARCHAR',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stort',
'hs_nr',
'Hochschule',
'',
'INTEGER',
'4',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stort',
'kurz',
'Hochschule',
'',
'VARCHAR',
'254',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stuart',
'tid',
'Tupelidentifier',
'',
'SERIAL',
'4',
1,
1,
0,
0);

update tmp_fields set is_primarykey=1 
where trim(table_name) || '_' || trim(name) ='kenn_stuart_tid';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stuart',
'bland',
'Bundesland',
'',
'INTEGER',
'4',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stuart',
'apnr',
'Schlssel Studienart',
'Schlssel der Studienart',
'CHAR',
'10',
1,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stuart',
'druck',
'Bezeichnung',
'Drucktext',
'VARCHAR',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stud_aggr_astat',
'hs_nr',
'Hochschule',
'Hochschulnummer',
'INTEGER',
'4',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_hochschulen',
foreignkey_col='hs_nr',
foreignkey_cap='name',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_stud_aggr_astat_hs_nr';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stud_aggr_astat',
'studiengang_nr',
'Studiengang-Nummer',
'z.B. 2 fr 2. Studiengang',
'SMALLINT',
'2',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stud_aggr_astat',
'fach_nr',
'Fach-Nummer',
'z.B. 2 fr 2. Fach',
'SMALLINT',
'2',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stud_aggr_astat',
'geschlecht',
'Geschlecht',
' (1=nicht-weiblich,2= weibl.)',
'CHAR',
'10',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_cifx',
foreignkey_col='apnr',
foreignkey_cap='druck',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_stud_aggr_astat_geschlecht';

update tmp_fields set foreignkey_cond='693=kenn_cifx.key'
where trim(table_name) || '_' || trim(name) ='kenn_stud_aggr_astat_geschlecht'
and trim(foreignkey_tab) = 'kenn_cifx';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stud_aggr_astat',
'bildungstyp',
'Bildungstyp',
'BI=Deutsche/Bildungsinlnder ,BA_EWR=Bildungsaul. EWR, BA_EU=Bildungsauslnder EU, BA_N_EU Bildungsauslnder nicht-EU/EWR ',
'CHAR',
'10',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_cifx',
foreignkey_col='apnr',
foreignkey_cap='druck',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_stud_aggr_astat_bildungstyp';

update tmp_fields set foreignkey_cond='691=kenn_cifx.key'
where trim(table_name) || '_' || trim(name) ='kenn_stud_aggr_astat_bildungstyp'
and trim(foreignkey_tab) = 'kenn_cifx';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stud_aggr_astat',
'sem_rueck_beur_ein',
'Semester',
'Schlssel, siehe Tab. kenn_semester',
'SMALLINT',
'2',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_semester',
foreignkey_col='tid',
foreignkey_cap='druck',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_stud_aggr_astat_sem_rueck_beur_ein';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stud_aggr_astat',
'stg',
'Fach (amtlich)',
'',
'CHAR',
'4',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_stg_astat',
foreignkey_col='astat',
foreignkey_cap='dtxt',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_stud_aggr_astat_stg';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stud_aggr_astat',
'stg_land',
'Fach Land (amtlich)',
'',
'CHAR',
'4',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='k_astat_studienfach_land_l',
foreignkey_col='schluessel',
foreignkey_cap='name',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_stud_aggr_astat_stg_land';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stud_aggr_astat',
'abschlusstyp',
'Abschlusstyp',
'Gruppierung BaWue 2024: BA, BA LA, MA, MA LA, StaEx, Magister/Diplom/Kirchliche/Fakulttsprfung, Promotion, sonstige,Kein Abschluss/Abschluss im Ausland',
'CHAR',
'10',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_cifx',
foreignkey_col='apnr',
foreignkey_cap='druck',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_stud_aggr_astat_abschlusstyp';

update tmp_fields set foreignkey_cond='689=kenn_cifx.key'
where trim(table_name) || '_' || trim(name) ='kenn_stud_aggr_astat_abschlusstyp'
and trim(foreignkey_tab) = 'kenn_cifx';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stud_aggr_astat',
'regel',
'Regelstudienzeit',
'',
'SMALLINT',
'2',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stud_aggr_astat',
'fach_sem_zahl',
'Anzahl Fachsemester',
'',
'SMALLINT',
'2',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stud_aggr_astat',
'hssem_1',
'1. Hochschulsemester',
'1. Hochschulsemester, 0=nein,1=ja',
'CHAR',
'10',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_cifx',
foreignkey_col='apnr',
foreignkey_cap='druck',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_stud_aggr_astat_hssem_1';

update tmp_fields set foreignkey_cond='690=kenn_cifx.key'
where trim(table_name) || '_' || trim(name) ='kenn_stud_aggr_astat_hssem_1'
and trim(foreignkey_tab) = 'kenn_cifx';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stud_aggr_astat',
'aufbaustudium',
'Ist Aufbaustudium',
'Aufbau/Erweiterung/Ergnzung/Weiterbildung (1=ja)',
'CHAR',
'10',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stud_aggr_astat',
'hrst',
'Hrerstatus',
'Hrerstatus (amtlich)',
'CHAR',
'10',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_cifx',
foreignkey_col='apnr',
foreignkey_cap='druck',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_stud_aggr_astat_hrst';

update tmp_fields set foreignkey_cond='674=kenn_cifx.key'
where trim(table_name) || '_' || trim(name) ='kenn_stud_aggr_astat_hrst'
and trim(foreignkey_tab) = 'kenn_cifx';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stud_aggr_astat',
'datum',
'Datum der Erzeugung',
'Dieses Feld wird zur Archivierung von gelieferten Daten genutzt',
'date',
'4',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stud_aggr_astat',
'summe',
'Summe',
'',
'INTEGER',
'4',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stufrm',
'tid',
'Tupelidentifier',
'',
'SERIAL',
'4',
1,
1,
0,
0);

update tmp_fields set is_primarykey=1 
where trim(table_name) || '_' || trim(name) ='kenn_stufrm_tid';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stufrm',
'bland',
'Bundesland',
'',
'INTEGER',
'4',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stufrm',
'apnr',
'Schlssel Studienform',
'Schlssel der Studienform',
'CHAR',
'10',
1,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stufrm',
'druck',
'Bezeichnung',
'Drucktext',
'VARCHAR',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stug',
'hs_nr',
'Hochschulnummer',
'',
'INTEGER',
'4',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_hochschulen',
foreignkey_col='hs_nr',
foreignkey_cap='name',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_stug_hs_nr';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stug',
'stug_key',
'stug_key',
'Schlssel des Studienganges',
'CHAR',
'20',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stug',
'stug_von',
'stug_von',
'Gltigkeitszeitraum von',
'DATE',
'4',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stug',
'stug_fach',
'stug_fach',
'Amtl.Schlssel des Faches',
'CHAR',
'10',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stug',
'stug_abschl',
'stug_abschl',
'Amtl.Schlssel des Abschlusses',
'CHAR',
'10',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stug',
'stug_dbez',
'stug_dbez',
'Druckbezeichnung',
'CHAR',
'51',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stug',
'stug_rstuz',
'stug_rstuz',
'Regelstudienzeit in Semestern',
'SMALLINT',
'2',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stug',
'stug_cnw',
'stug_cnw',
'CNW=Summe aller lvm_ca eines Studienganges und eines Zeitraumes',
'DOUBLE',
'8',
0,
0,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stug',
'stug_bis',
'stug_bis',
'Gltigkeitszeitraum bis',
'DATE',
'4',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stug',
'key_lehreinh',
'key_lehreinh',
'Lehreinheit',
'CHAR',
'10',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stug',
'stug_plaetze',
'stug_plaetze',
'Anzahl Studienpltze als Summe ber die Regelstudienzeit',
'SMALLINT',
'2',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stug',
'k_extkotr',
'k_extkotr',
'Schlssel fr externe Kostentrger',
'CHAR',
'10',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stupl',
'hs_nr',
'Hochschulnummer',
'',
'INTEGER',
'',
1,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stupl',
'stug_key',
'stug_key',
'Studiengang = Fremdschluessel aus stug',
'CHAR',
'12',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stupl',
'stug_rstuz',
'stug_rstuz',
'Regelstudienzeit in Semestern',
'SMALLINT',
'2',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stupl',
'jahr',
'jahr',
'Jahr',
'INTEGER',
'',
0,
0,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stupl',
'sem',
'sem',
'Semester',
'INTEGER',
'',
1,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stupl',
'extkotr',
'Externer Produktschlssel',
'Nummer des externen Produktschlssels (nur Sachsen)',
'CHAR',
'30',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stupl',
'datum',
'Datum der Erzeugung',
'Dieses Feld wird zur Archivierung von gelieferten Daten genutzt',
'DATE',
'',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stupl',
'summe',
'summe',
'Aufnahmekapazitaet des Studienganges pro Semester',
'INTEGER',
'',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stylesheet_version',
'tid',
'tid',
'',
'SERIAL',
'10',
1,
1,
0,
0);

update tmp_fields set is_primarykey=1 
where trim(table_name) || '_' || trim(name) ='kenn_stylesheet_version_tid';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stylesheet_version',
'stylesheet_id',
'Stylesheet',
'',
'INTEGER',
'4',
1,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stylesheet_version',
'rpt_version_id',
'Version',
'',
'INTEGER',
'4',
1,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_su_imp_stud',
'hs_nr',
'Hochschulnummer',
'',
'INTEGER',
'4',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_hochschulen',
foreignkey_col='hs_nr',
foreignkey_cap='name',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_su_imp_stud_hs_nr';

update tmp_fields set foreignkey_tab='kenn_hochschulen',
foreignkey_col='hs_nr',
foreignkey_cap='name',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_su_imp_stud_hs_nr';

update tmp_fields set foreignkey_tab='kenn_stug',
foreignkey_col='hs_nr',
foreignkey_cap='stug_dbez',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_su_imp_stud_hs_nr';

update tmp_fields set foreignkey_cond='stugkey=kenn_stug.stug_key'
where trim(table_name) || '_' || trim(name) ='kenn_su_imp_stud_hs_nr'
and trim(foreignkey_tab) = 'kenn_stug';

update tmp_fields set foreignkey_cond='k_extkotr=kenn_extkotr.key'
where trim(table_name) || '_' || trim(name) ='kenn_su_imp_stud_hs_nr'
and trim(foreignkey_tab) = 'kenn_extkotr';

update tmp_fields set foreignkey_tab='kenn_inst',
foreignkey_col='hs_nr',
foreignkey_cap='name',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_su_imp_stud_hs_nr';

update tmp_fields set foreignkey_cond='lehreinheit=kenn_inst.key_apnr'
where trim(table_name) || '_' || trim(name) ='kenn_su_imp_stud_hs_nr'
and trim(foreignkey_tab) = 'kenn_inst';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_su_imp_stud',
'lehreinheit',
'Lehreinheit aus cob_stug',
'',
'CHAR',
'10',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_inst',
foreignkey_col='key_apnr',
foreignkey_cap='name',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_su_imp_stud_lehreinheit';

update tmp_fields set foreignkey_cond='hs_nr=kenn_inst.hs_nr'
where trim(table_name) || '_' || trim(name) ='kenn_su_imp_stud_lehreinheit'
and trim(foreignkey_tab) = 'kenn_inst';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_su_imp_stud',
'k_extkotr',
'externer Kostentrger',
'',
'CHAR',
'10',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_extkotr',
foreignkey_col='key',
foreignkey_cap='name',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_su_imp_stud_k_extkotr';

update tmp_fields set foreignkey_cond='hs_nr=kenn_extkotr.hs_nr'
where trim(table_name) || '_' || trim(name) ='kenn_su_imp_stud_k_extkotr'
and trim(foreignkey_tab) = 'kenn_extkotr';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_su_imp_stud',
'sem',
'sem',
'Semester=Angabe aus Jahr und Ziffer: 1=SS 2=WS, z.B. 20122 fr WS 2012',
'INTEGER',
'10',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_semester',
foreignkey_col='tid',
foreignkey_cap='name',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_su_imp_stud_sem';

update tmp_fields set foreignkey_tab='kenn_semester',
foreignkey_col='tid',
foreignkey_cap='druck',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_su_imp_stud_sem';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_su_imp_stud',
'stgnr',
'stgnr',
'stud.bezogene StudGangZhler(1.Pos=Abschl, 2.Pos=Fachzhler zum gleichen Abschlu)',
'VARCHAR',
'2',
0,
0,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_su_imp_stud',
'fsemnr',
'fsemnr',
'stud.bezogener Zhler des Fachsemesters',
'INTEGER',
'10',
0,
0,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_su_imp_stud',
'fachkey',
'fachkey',
'as-spezif. Schlssel des Faches',
'VARCHAR',
'4',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_stg_astat',
foreignkey_col='astat',
foreignkey_cap='name',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_su_imp_stud_fachkey';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_su_imp_stud',
'fachkeydbez',
'fachkeydbez',
'Drucktext Studienfach',
'VARCHAR',
'25',
0,
0,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_su_imp_stud',
'abslkey',
'abslkey',
'as-spezif. Schlssel des Abschlusses',
'VARCHAR',
'2',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_abschl_astat',
foreignkey_col='astat',
foreignkey_cap='name',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_su_imp_stud_abslkey';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_su_imp_stud',
'abslkeydbez',
'abslkeydbez',
'Drucktext Abschluart',
'VARCHAR',
'25',
0,
0,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_su_imp_stud',
'kzfach',
'kzfach',
'Fachkennzeichen fr Haupt/Nebenfach',
'VARCHAR',
'1',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_su_imp_stud',
'stufrm',
'stufrm',
'Studiengangform',
'VARCHAR',
'1',
0,
0,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_su_imp_stud',
'stufrmdbez',
'stufrmdbez',
'Studiengangform-Druckbezeichnung',
'VARCHAR',
'25',
0,
0,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_su_imp_stud',
'kzfachdbez',
'kzfachdbez',
'Fachkennzeichen',
'VARCHAR',
'25',
0,
0,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_su_imp_stud',
'ffstgnr',
'ffstgnr',
'Fachflle stud.bezogene StudGangZhler(1.Pos=Abschl, 2.Pos=Fachzhler zum gleichen Abschlu)',
'VARCHAR',
'2',
0,
0,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_su_imp_stud',
'gruppierung',
'gruppierung',
'Schlssel der zugewiesenen Fachfallgruppe',
'VARCHAR',
'4',
0,
0,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_su_imp_stud',
'ffgewicht',
'ffgewicht',
'Fachfallquivalent',
'DOUBLE',
'15',
0,
0,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_su_imp_stud',
'stugkey',
'stugkey',
'Studiengangschlssel aus kenn_stug',
'CHAR',
'20',
0,
1,
0,
0);

update tmp_fields set foreignkey_cond='hs_nr=kenn_stug.hs_nr'
where trim(table_name) || '_' || trim(name) ='kenn_su_imp_stud_stugkey'
and trim(foreignkey_tab) = 'kenn_stug';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_su_imp_stud',
'vza',
'Vollzeitquivalent',
'wird in BaWue ausgewertet (Bericht Kostentrger-Studiengnge, Kennz. Studierende gesamt VZ))',
'DOUBLE',
'15',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_su_imp_stud',
'ffges',
'Fachflle gesamt',
'',
'DOUBLE',
'15',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_su_imp_stud',
'ffidr',
'Fachflle in der RSZ',
'',
'DOUBLE',
'15',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_su_imp_stud',
'ff1_4',
'Fachflle 1.-4. Fachsemester',
'',
'DOUBLE',
'15',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_su_imp_stud',
'ffidrgfs',
'FFA i.d.RSZ',
'',
'DOUBLE',
'15',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_su_imp_stud',
'ff1_4gfs',
'VZ 1.-4. Fachsemester',
'',
'DOUBLE',
'15',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_su_imp_stud',
'ffidrgf2',
'VZ i.d. RSZ',
'wird in BaWue ausgewertet (Kennz. Studierende in der Regelstudienzeit VZ)',
'DOUBLE',
'15',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_su_imp_stud',
'ff1_4gf2',
'VZ 1.-4. Fachsemester',
'',
'DOUBLE',
'15',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_su_imp_stud',
'kpfges',
'Kpfe gesamt',
'',
'DOUBLE',
'15',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_su_imp_stud',
'kpfidr',
'Kpfe i.d. RSZ',
'',
'DOUBLE',
'15',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_su_imp_stud',
'kpf1_4',
'Kpfe 1.-4. Fachsemester',
'',
'DOUBLE',
'15',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_su_imp_stud',
'datum',
'Datum der Erzeugung',
'Dieses Feld wird zur Archivierung von gelieferten Daten genutzt',
'date',
'4',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_titel',
'hs_nr',
'Hochschulnummer',
'',
'INTEGER',
'4',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_titel',
'jahr',
'Jahr',
'',
'smallint',
'',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_titel',
'kapitel',
'Kapitel',
'',
'CHAR',
'5',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_titel',
'dr',
'Deckungsring',
'',
'CHAR',
'5',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_titel',
'dr2',
'dr2',
'',
'CHAR',
'5',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_titel',
'titel',
'Titel',
'',
'CHAR',
'10',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_titel',
'dritt',
'Drittmittel',
'',
'integer',
'',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_titel',
'ktobez',
'Kontenbezeichnung',
'',
'VARCHAR',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_vari',
'tid',
'Tupelidentifier',
'',
'SERIAL',
'4',
1,
1,
0,
0);

update tmp_fields set is_primarykey=1 
where trim(table_name) || '_' || trim(name) ='kenn_vari_tid';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_vari',
'vari_nr',
'Verteilschritt',
'',
'INTEGER',
'100',
1,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_vari',
'kotr_art',
'Art d. Kostentrgers',
'L=Lehre, F=Forschung,D=sonstige Dienstleistungen',
'CHAR',
'1',
1,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_cifx',
foreignkey_col='apnr',
foreignkey_cap='druck',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_vari_kotr_art';

update tmp_fields set foreignkey_cond='677=kenn_cifx.key'
where trim(table_name) || '_' || trim(name) ='kenn_vari_kotr_art'
and trim(foreignkey_tab) = 'kenn_cifx';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_vari',
'bezugszeit',
'Bezug des Zeitraums',
'Akad. Jahr/Haushaltsjahr/Quartal/Monat',
'INTEGER',
'4',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_vari',
'bezugsart',
'Bezugsart (Akad. Jahr A,Jahr J, Quartal Q, Monat M)',
'',
'CHAR',
'1',
1,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_vert_int',
'hs_nr',
'Hochschulnummer',
'',
'INTEGER',
'4',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_vert_int',
'apnr',
'Vertiefungen (intern)',
'Schlssel Vertiefungen',
'CHAR',
'10',
1,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_vert_int',
'druck',
'Vertiefungenbezeichnung',
'Drucktext',
'VARCHAR',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_vert_int',
'datum',
'Datum der Erzeugung',
'Dieses Feld wird zur Archivierung von gelieferten Daten genutzt',
'date',
'4',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_vtbu_aggr',
'hs_nr',
'Hochschulnummer',
'',
'INTEGER',
'4',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_hochschulen',
foreignkey_col='hs_nr',
foreignkey_cap='name',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_vtbu_aggr_hs_nr';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_vtbu_aggr',
'jahr',
'jahr',
'KoRe-Periode Jahr (vierstellig)',
'SMALLINT',
'2',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_vtbu_aggr',
'quartal',
'Quartal der Buchung',
'Das Jahr + angehngt das Quartal 1-4, z.B. 20091 fr 1. Quartal 2009.',
'INTEGER',
'2',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_vtbu_aggr',
'monat',
'monat',
'KoRe-Periode Monat,1-12',
'SMALLINT',
'2',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='dim_kenn_monat',
foreignkey_col='monat',
foreignkey_cap='name',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_vtbu_aggr_monat';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_vtbu_aggr',
'quell_ch110_inst',
'Abgebende Kostenstelle',
'Lehreinheit, die Kosten erbringt',
'VARCHAR',
'50',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_vtbu_aggr',
'quell_projnr',
'Projektnr. (ext. Kostentrger)',
'Abgebendes Projekt',
'CHAR',
'10',
0,
0,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_vtbu_aggr',
'quell_stug',
'Studiengang',
'Abgebender Studiengang',
'CHAR',
'20',
0,
0,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_vtbu_aggr',
'ziel_projnr',
'Projektnr. (ext. Kostentrger)',
'Empfangendes Projekt',
'CHAR',
'10',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_extkotr',
foreignkey_col='key',
foreignkey_cap='name',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_vtbu_aggr_ziel_projnr';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_vtbu_aggr',
'ziel_stug',
'Studiengang',
'',
'CHAR',
'20',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_stug',
foreignkey_col='stugkey',
foreignkey_cap='name',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_vtbu_aggr_ziel_stug';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_vtbu_aggr',
'ziel_fikrkey',
'Ziel-Kostenartenblock',
'_PERS_S=Personalkosten sonstige,_PERS_W=Personalkosten wiss.,_PERS_NW=Personalkosten nichtwiss., _SACHK_O_BEW=Sachkosten ohne Bewirtschaftungskosten,_SACHK_BEW=Sachkosten-Bewirtschaftungskosten,_ABSCHR=Abschreibungen,_KALK_MIETE=Kalkulatorische Mieten,_ER',
'CHAR',
'12',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_fikr',
foreignkey_col='key',
foreignkey_cap='lbez',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_vtbu_aggr_ziel_fikrkey';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_vtbu_aggr',
'kokl',
'Kontenklasse',
'K=Kosten,E=Erlse',
'CHAR',
'1',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_vtbu_aggr',
'klr_geldgeber',
'Geldgeber',
'Dreistelliger Schlssel Mittelherkunft KLR',
'CHAR',
'3',
0,
0,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_vtbu_aggr',
'vari',
'Verteilschritte',
'             Verteilschritt. BaWue: Kosten der Lehre-nachfrageorientiert (L), Lehre-angebotsorientiert (A), Forschung (F), Sonstige Dienstleistungen (D). Sachsen: B=Bewirtschaftungskosten,             S=Sekundrkosten der Fakulttsverwaltung,             ',
'CHAR',
'1',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_cifx',
foreignkey_col='apnr',
foreignkey_cap='druck',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_vtbu_aggr_vari';

update tmp_fields set foreignkey_cond='677=kenn_cifx.key'
where trim(table_name) || '_' || trim(name) ='kenn_vtbu_aggr_vari'
and trim(foreignkey_tab) = 'kenn_cifx';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_vtbu_aggr',
'datum',
'Datum der Erzeugung',
'Dieses Feld wird zur Archivierung von gelieferten Daten genutzt',
'date',
'4',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_vtbu_aggr',
'betrag',
'betrag',
'Kostenbetrag',
'DOUBLE',
'8',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_vtbu_aggr',
'ziel_ch110_inst',
'Ziel-Kostenstelle',
'Wird nur in Sachsen gefllt: Externer Produktschlssel der empf. Kostenstelle',
'CHAR',
'10',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_vtbu_qp_aggr',
'hs_nr',
'Hochschulnummer',
'',
'INTEGER',
'4',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_hochschulen',
foreignkey_col='hs_nr',
foreignkey_cap='name',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_vtbu_qp_aggr_hs_nr';

update tmp_fields set foreignkey_cond='quell_ch110_inst=kenn_inst.key_apnr'
where trim(table_name) || '_' || trim(name) ='kenn_vtbu_qp_aggr_hs_nr'
and trim(foreignkey_tab) = 'kenn_inst';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_vtbu_qp_aggr',
'jahr',
'Jahr',
'KoRe-Periode Jahr (vierstellig)',
'SMALLINT',
'2',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_vtbu_qp_aggr',
'quartal',
'Quartal',
'Das Jahr + angehngt das Quartal 1-4, z.B. 20091 fr 1. Quartal 2009.',
'INTEGER',
'2',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_vtbu_qp_aggr',
'monat',
'Monat',
'KoRe-Periode Monat,1-12',
'SMALLINT',
'2',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='dim_kenn_monat',
foreignkey_col='monat',
foreignkey_cap='name',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_vtbu_qp_aggr_monat';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_vtbu_qp_aggr',
'quell_ch110_inst',
'Abgebende Kostenstelle',
'Lehreinheit, die Kosten erbringt',
'VARCHAR',
'50',
0,
0,
0,
0);

update tmp_fields set foreignkey_tab='kenn_inst',
foreignkey_col='key_apnr',
foreignkey_cap='drucktext',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_vtbu_qp_aggr_quell_ch110_inst';

update tmp_fields set foreignkey_cond='hs_nr=kenn_inst.hs_nr'
where trim(table_name) || '_' || trim(name) ='kenn_vtbu_qp_aggr_quell_ch110_inst'
and trim(foreignkey_tab) = 'kenn_inst';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_vtbu_qp_aggr',
'ziel_projnr',
'Projektnr. (ext. Kostentrger)',
'Empfangendes Projekt',
'CHAR',
'10',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_extkotr',
foreignkey_col='key',
foreignkey_cap='name',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_vtbu_qp_aggr_ziel_projnr';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_vtbu_qp_aggr',
'kokl',
'Kontenklasse',
'K=Kosten,E=Erlse',
'CHAR',
'1',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_vtbu_qp_aggr',
'datum',
'Datum der Erzeugung',
'Dieses Feld wird zur Archivierung von gelieferten Daten genutzt',
'date',
'4',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_vtbu_qp_aggr',
'betrag',
'Betrag',
'Kostenbetrag',
'DOUBLE',
'8',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_zahl_wert',
'tid',
'tid',
'Primrschlssel',
'SERIAL',
'4',
1,
1,
0,
0);

update tmp_fields set is_primarykey=1 
where trim(table_name) || '_' || trim(name) ='kenn_zahl_wert_tid';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_zahl_wert',
'hs_nr',
'Hochschulnummer',
'',
'INTEGER',
'4',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_hochschulen',
foreignkey_col='hs_nr',
foreignkey_cap='name',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_zahl_wert_hs_nr';

update tmp_fields set foreignkey_cond='ch110_institut=kenn_inst.key_apnr'
where trim(table_name) || '_' || trim(name) ='kenn_zahl_wert_hs_nr'
and trim(foreignkey_tab) = 'kenn_inst';

update tmp_fields set foreignkey_cond='stugkey=kenn_stug.stug_key'
where trim(table_name) || '_' || trim(name) ='kenn_zahl_wert_hs_nr'
and trim(foreignkey_tab) = 'kenn_stug';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_zahl_wert',
'kenn_zahl',
'Bestandsart',
'',
'CHAR',
'40',
1,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_zahlen',
foreignkey_col='apnr',
foreignkey_cap='druck',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_zahl_wert_kenn_zahl';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_zahl_wert',
'jahr',
'Bezugsjahr',
'',
'SMALLINT',
'4',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_zahl_wert',
'sem',
'Bezugssemester',
'',
'SMALLINT',
'4',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_semester',
foreignkey_col='tid',
foreignkey_cap='druck',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_zahl_wert_sem';

update tmp_fields set foreignkey_tab='kenn_semester',
foreignkey_col='tid',
foreignkey_cap='druck',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_zahl_wert_sem';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_zahl_wert',
'ch110_institut',
'Kostenstelle/Institut',
'',
'VARCHAR',
'50',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_inst',
foreignkey_col='key_apnr',
foreignkey_cap='name',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_zahl_wert_ch110_institut';

update tmp_fields set foreignkey_cond='hs_nr=kenn_inst.hs_nr'
where trim(table_name) || '_' || trim(name) ='kenn_zahl_wert_ch110_institut'
and trim(foreignkey_tab) = 'kenn_inst';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_zahl_wert',
'stugkey',
'Studiengangschlssel KLR',
'in kenn_stug',
'CHAR',
'20',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_stug',
foreignkey_col='stug_key',
foreignkey_cap='stug_dbez',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_zahl_wert_stugkey';

update tmp_fields set foreignkey_cond='hs_nr=kenn_stug.hs_nr'
where trim(table_name) || '_' || trim(name) ='kenn_zahl_wert_stugkey'
and trim(foreignkey_tab) = 'kenn_stug';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_zahl_wert',
'bund_fachgebiet',
'Fachgebiet/Fchergruppe',
'(Bundesschlssel)',
'CHAR',
'10',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_lfb_fg',
foreignkey_col='apnr',
foreignkey_cap='name',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_zahl_wert_bund_fachgebiet';

update tmp_fields set foreignkey_tab='kenn_lfb_fg',
foreignkey_col='apnr',
foreignkey_cap='name',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_zahl_wert_bund_fachgebiet';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_zahl_wert',
'titel',
'Titel/Titelgruppe',
'',
'CHAR',
'10',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_zahl_wert',
'wert',
'Wert der Kennzahl',
'',
'DOUBLE',
'4',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_zahl_wert',
'wert_str',
'Wert der Kennzahl (fr Texteingaben)',
'',
'varchar',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_zahl_wert',
'geschlecht',
'Geschlecht',
'(1 mnnl.,2 weibl.)',
'SMALLINT',
'2',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_zahl_wert',
'ca12_staat',
'Nationalitt',
'0=Deutsch,1=Ausland',
'SMALLINT',
'2',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_zahl_wert',
'generic_dim1',
'Kategorie',
'',
'VARCHAR',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_zahl_wert',
'generic_dim2',
'Kategorie 2',
'',
'VARCHAR',
'255',
0,
0,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_zsl_ausgleich_kennungen',
'astat',
'astat',
'',
'CHAR',
'3',
1,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_zsl_ausgleich_kennungen',
'studienart',
'Studienart',
'',
'TEXT',
'255',
1,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_zsl_ausgleich_kennungen',
'kennung_stud_hs1',
'kennung_stud_hs1',
'',
'SMALLINT',
'4',
1,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_zsl_ausgleich_kennungen',
'kennung_stud_rsz2',
'kennung_stud_rsz2',
'',
'SMALLINT',
'4',
1,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_zsl_ausgleich_kennungen',
'kennung_absolv',
'kennung_absolv',
'',
'SMALLINT',
'4',
1,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_zsl_ausgleich_kennungen',
'faktor',
'faktor',
'',
'FLOAT',
'4',
1,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_zulzahl_id',
'id',
'Laufnummer',
'',
'SERIAL',
'10',
1,
1,
0,
0);

update tmp_fields set is_primarykey=1 
where trim(table_name) || '_' || trim(name) ='kenn_zulzahl_id_id';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_zulzahl_id',
'name',
'Name',
'',
'VARCHAR',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_zulzahl_id',
'beschreibung',
'beschreibung',
'',
'VARCHAR',
'255',
0,
0,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_zulzahl_id',
'fach',
'Studienfach',
'',
'VARCHAR',
'255',
0,
0,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_zulzahl_id',
'abschluss',
'Abschluss',
'',
'VARCHAR',
'255',
0,
0,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_zulzahl_id',
'hs_nr',
'Hochschule',
'',
'INTEGER',
'10',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_hochschulen',
foreignkey_col='hs_nr',
foreignkey_cap='kurztext',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_zulzahl_id_hs_nr';

update tmp_fields set foreignkey_tab='kenn_stort',
foreignkey_col='hs_nr',
foreignkey_cap='druck',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_zulzahl_id_hs_nr';

update tmp_fields set foreignkey_cond='stort=kenn_stort.apnr'
where trim(table_name) || '_' || trim(name) ='kenn_zulzahl_id_hs_nr'
and trim(foreignkey_tab) = 'kenn_stort';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_zulzahl_id',
'stort',
'Standort',
'',
'CHAR',
'10',
0,
1,
0,
0);

update tmp_fields set foreignkey_cond='hs_nr=kenn_stort.hs_nr'
where trim(table_name) || '_' || trim(name) ='kenn_zulzahl_id_stort'
and trim(foreignkey_tab) = 'kenn_stort';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_zulzahl_id',
'abgrp',
'Abschlussgruppe',
'',
'CHAR',
'10',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_zulzahl_id',
'erzeugt_am',
'Datum der Erzeugung des Datensatzes',
'',
'DATE',
'4',
0,
0,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_zulzahl_id',
'geaendert_am',
'Datum der letzten nderung des Datensatzes',
'',
'DATE',
'4',
0,
0,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_zulzahl_id',
'geaendert_von_id',
'UserID des ndernden',
'',
'INTEGER',
'4',
0,
0,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_zulzahl_id',
'erzeugt_von_id',
'UserID des Erzeugers',
'',
'INTEGER',
'4',
0,
0,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_zulzahl_id',
'redaktionsstatus',
'Redaktionsstatus',
'3=In Bearbeitung,4=Freigegeben',
'INTEGER',
'4',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_redaktionsstatus',
foreignkey_col='apnr',
foreignkey_cap='name',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_zulzahl_id_redaktionsstatus';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_zulzahl_sem',
'tid',
'Laufnummer',
'',
'SERIAL',
'10',
1,
1,
0,
0);

update tmp_fields set is_primarykey=1 
where trim(table_name) || '_' || trim(name) ='kenn_zulzahl_sem_tid';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_zulzahl_sem',
'zulzahl_id',
'Zulassungszahl-ID',
'',
'INTEGER',
'10',
1,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_zulzahl_sem',
'semester',
'Semester',
'',
'INTEGER',
'4',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_zulzahl_sem',
'zul_beschr',
'Zulassungsbeschrnkt?',
'1=ja, 0=nein',
'SMALLINT',
'2',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_zulzahl_sem',
'zulzahl',
'Zulassungszahl',
'',
'INTEGER',
'4',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_zulzahl2int',
'tid',
'Laufnummer',
'',
'SERIAL',
'10',
1,
1,
0,
0);

update tmp_fields set is_primarykey=1 
where trim(table_name) || '_' || trim(name) ='kenn_zulzahl2int_tid';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_zulzahl2int',
'zulzahl_id',
'Studiengang-ID',
'',
'INTEGER',
'10',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_zulzahl_id',
foreignkey_col='id',
foreignkey_cap='name',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_zulzahl2int_zulzahl_id';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_zulzahl2int',
'stg_int',
'Fach (intern)',
'',
'CHAR',
'10',
0,
1,
0,
0);

update tmp_fields set foreignkey_cond='hs_nr=kenn_stg_int.hs_nr'
where trim(table_name) || '_' || trim(name) ='kenn_zulzahl2int_stg_int'
and trim(foreignkey_tab) = 'kenn_stg_int';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_zulzahl2int',
'abschluss_int',
'Abschluss (intern)',
'',
'CHAR',
'10',
0,
1,
0,
0);

update tmp_fields set foreignkey_cond='hs_nr=kenn_abint.hs_nr'
where trim(table_name) || '_' || trim(name) ='kenn_zulzahl2int_abschluss_int'
and trim(foreignkey_tab) = 'kenn_abint';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_zulzahl2int',
'kz_fach_int',
'Fachkennzeichen (intern)',
'Haupt-/Nebenfach (intern)',
'CHAR',
'10',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_zulzahl2int',
'vertfg',
'Vertiefung',
'Vertiefung (intern)',
'CHAR',
'10',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_zulzahl2int',
'stg_astat',
'Fach (amtl.)',
'',
'CHAR',
'10',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_stg_astat',
foreignkey_col='astat',
foreignkey_cap='dtxt',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_zulzahl2int_stg_astat';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_zulzahl2int',
'abschluss_astat',
'Abschluss (amtl.)',
'',
'CHAR',
'10',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_abschl_astat',
foreignkey_col='astat',
foreignkey_cap='dtxt',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_zulzahl2int_abschluss_astat';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_zulzahl2int',
'hs_nr',
'Hochschule',
'',
'INTEGER',
'10',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_hochschulen',
foreignkey_col='hs_nr',
foreignkey_cap='kurztext',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_zulzahl2int_hs_nr';

update tmp_fields set foreignkey_tab='kenn_stg_int',
foreignkey_col='hs_nr',
foreignkey_cap='druck',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_zulzahl2int_hs_nr';

update tmp_fields set foreignkey_cond='stg_int=kenn_stg_int.apnr'
where trim(table_name) || '_' || trim(name) ='kenn_zulzahl2int_hs_nr'
and trim(foreignkey_tab) = 'kenn_stg_int';

update tmp_fields set foreignkey_tab='kenn_abint',
foreignkey_col='hs_nr',
foreignkey_cap='druck',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_zulzahl2int_hs_nr';

update tmp_fields set foreignkey_cond='abschluss_int=kenn_abint.apnr'
where trim(table_name) || '_' || trim(name) ='kenn_zulzahl2int_hs_nr'
and trim(foreignkey_tab) = 'kenn_abint';

update tmp_fields set foreignkey_tab='kenn_stort',
foreignkey_col='hs_nr',
foreignkey_cap='druck',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_zulzahl2int_hs_nr';

update tmp_fields set foreignkey_cond='stort=kenn_stort.apnr'
where trim(table_name) || '_' || trim(name) ='kenn_zulzahl2int_hs_nr'
and trim(foreignkey_tab) = 'kenn_stort';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_zulzahl2int',
'stort',
'Standort',
'',
'CHAR',
'10',
0,
1,
0,
0);

update tmp_fields set foreignkey_cond='hs_nr=kenn_stort.hs_nr'
where trim(table_name) || '_' || trim(name) ='kenn_zulzahl2int_stort'
and trim(foreignkey_tab) = 'kenn_stort';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_zulzahl2int',
'erzeugt_am',
'Datum der Erzeugung des Datensatzes',
'',
'DATE',
'4',
0,
0,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_zulzahl2int',
'geaendert_am',
'Datum der letzten nderung des Datensatzes',
'',
'DATE',
'4',
0,
0,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_zulzahl2int',
'geaendert_von_id',
'UserID des ndernden',
'',
'INTEGER',
'4',
0,
0,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_zulzahl2int',
'erzeugt_von_id',
'UserID des Erzeugers',
'',
'INTEGER',
'4',
0,
0,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('dim_hochschule',
'hs_nr',
'Laufnummer',
'',
'INTEGER',
'5',
1,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('dim_hochschule',
'name',
'Hochschulname',
'',
'CHAR',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('dim_hochschule',
'kurztext',
'Hochschulkurzname',
'',
'CHAR',
'50',
1,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('dim_hochschule',
'art',
'Hochschulart',
'',
'CHAR',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('dim_kenn_abschl_astat',
'apnr',
'Schlssel',
'',
'CHAR',
'20',
1,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('dim_kenn_abschl_astat',
'druck',
'Bezeichnung',
'',
'VARCHAR',
'255',
1,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('dim_kenn_abschl_astat',
'abschlussart',
'Abschlussart',
'',
'CHAR',
'100',
1,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('dim_kenn_abschl_astat',
'abschlussgruppe',
'Abschlussgruppe',
'',
'CHAR',
'100',
1,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('dim_kenn_bvkr_art',
'apnr',
'Schlssel',
'',
'CHAR',
'10',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('dim_kenn_bvkr_art',
'druck',
'Bezeichnung',
'',
'VARCHAR',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('dim_kenn_bvkr_art',
'parent',
'bergeordnete Kostenart',
'',
'CHAR',
'10',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('dim_kenn_bvkr_art',
'struktur_c',
'Art der Ebene',
'',
'CHAR',
'50',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('dim_kenn_bvkr_art',
'ebene',
'Ebene',
'',
'INTEGER',
'50',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('dim_kenn_bvkr_art',
'kostentyp',
'Kostentyp',
'',
'CHAR',
'10',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('dim_kenn_bvkr_art',
'kostentyp_str',
'Kostentyp (Name)',
'',
'VARCHAR',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('dim_kenn_koepfe_faelle',
'apnr',
'Schlssel',
'',
'CHAR',
'1',
1,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('dim_kenn_koepfe_faelle',
'druck',
'Bezeichnung',
'',
'VARCHAR',
'255',
1,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('dim_kenn_koepfe_faelle',
'struktur_int',
'Schlssel Zahl',
'',
'INTEGER',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('dim_kenn_monat',
'monat',
'Schlssel',
'',
'INTEGER',
'1',
1,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('dim_kenn_monat',
'quartal',
'Quartal',
'',
'INTEGER',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('dim_kenn_monat',
'halbjahr',
'Halbjahr',
'',
'INTEGER',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('dim_kenn_monat',
'name',
'Bezeichnung',
'',
'VARCHAR',
'255',
1,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('dim_kenn_stg_astat',
'apnr',
'Schlssel',
'',
'CHAR',
'20',
1,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('dim_kenn_stg_astat',
'druck',
'Bezeichnung',
'',
'VARCHAR',
'255',
1,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('dim_kenn_stg_astat',
'sb',
'Studienbereich (Nummer)',
'',
'CHAR',
'10',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('dim_kenn_stg_astat',
'sb_str',
'Studienbereich (Name)',
'',
'CHAR',
'100',
1,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('dim_kenn_stg_astat',
'fgr',
'Fchergruppe',
'',
'CHAR',
'100',
1,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('dim_kenn_stg_int',
'apnr',
'Schlssel',
'',
'CHAR',
'20',
1,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('dim_kenn_stg_int',
'druck',
'Bezeichnung',
'',
'VARCHAR',
'255',
1,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('dim_kenn_stg_int',
'hs_nr_str',
'Hochschule (Name)',
'',
'CHAR',
'100',
1,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('dim_kenn_stg_int',
'hs_nr',
'Hochschule (Nummer)',
'',
'INTEGER',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('dim_kenn_stg_int',
'stg_astat_str',
'Fach (amtlich)',
'',
'CHAR',
'100',
1,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('k_astat_studienfach_land_l',
'schluessel',
'schluessel',
'',
'VARCHAR',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('k_astat_studienfach_land_l',
'gueltig_ab',
'gueltig_ab',
'',
'INTEGER',
'10',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('k_astat_studienfach_land_l',
'land',
'land',
'',
'INTEGER',
'10',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('k_astat_studienfach_land_l',
'version',
'version',
'',
'INTEGER',
'10',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('k_astat_studienfach_land_l',
'sortkey',
'sortkey',
'',
'INTEGER',
'10',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('k_astat_studienfach_land_l',
'gueltig_bis',
'gueltig_bis',
'',
'INTEGER',
'10',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('k_astat_studienfach_land_l',
'name',
'name',
'',
'VARCHAR',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('k_astat_studienfach_land_l',
'isced',
'isced',
'',
'VARCHAR',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('k_astat_studienfach_land_l',
'keybund',
'keybund',
'',
'VARCHAR',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_abschl_astat',
'tid',
'tid',
'Schlssel',
'SERIAL',
'4',
1,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_abschl_astat',
'astat',
'amtlicher Schlssel',
'des Abschlusses bzw. der Abschlussgruppe',
'CHAR',
'10',
1,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_abschl_astat',
'parent',
'bergeordneter Schlssel',
'dient zum Aufbau der Baumstruktur',
'CHAR',
'10',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_abschl_astat',
'ktxt',
'Beschreibungstext (kurz)',
'',
'CHAR',
'10',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_abschl_astat',
'dtxt',
'Beschreibungstext (Druck)',
'',
'CHAR',
'150',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_abschl_astat',
'ltxt',
'Beschreibungstext (lang)',
'',
'CHAR',
'250',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_abschl_astat',
'sicht',
'Name der alternativen Hierarchie',
'Referenziert auf sichten.name_intern im  Kernmodul',
'CHAR',
'200',
1,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_abschl_astat',
'ebene',
'Ebene des Baums',
'',
'SMALLINT',
'2',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_abschl_astat',
'sort1',
'Sortierschlssel (Ganzzahl)',
'',
'INTEGER',
'4',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_abschl_astat',
'sortc1',
'Sortierschlssel (Alphabetisch)',
'',
'CHAR',
'10',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_abschl_astat',
'gueltig_von',
'Beginn der Gltigkeit',
'',
'DATE',
'4',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_abschl_astat',
'gueltig_bis',
'Ende der Gltigkeit',
'',
'DATE',
'4',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_abschl_astat',
'struktur_c',
'Art der Ebene',
'',
'CHAR',
'50',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_abschl_astat_pruef_grp',
'astat',
'Schlssel Abschluss (amtl. STBA)',
'',
'CHAR',
'10',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_abschl_astat_pruef_grp',
'pruef_grp',
'Prfungsgruppe Schlssel',
'',
'CHAR',
'10',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_abschl_astat_pruef_grp',
'kurz',
'Prfungsgruppe Kurzbezeichnung',
'',
'CHAR',
'10',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_abschl_astat_pruef_grp',
'druck',
'Prfungsgruppe Drucktext',
'',
'CHAR',
'100',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_abschl_astat_pruef_grp',
'lang_1',
'Prfungsgruppe Langtext',
'',
'CHAR',
'250',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_abschl_astat_pruef_grp',
'sort1',
'Sortiernummer',
'',
'SMALLINT',
'50',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_bezugszeit',
'bezugsart',
'Art der Bezugszeit',
'',
'CHAR',
'1',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_bezugszeit',
'bezugszeit',
'Bezugszeit',
'',
'INTEGER',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_bezugszeit',
'druck',
'Bezeichnung',
'',
'VARCHAR',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_dienstart',
'tid',
'tid',
'Schlssel',
'INTEGER',
'4',
1,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_dienstart',
'bund_dienstart',
'Schlssel der Dienstart',
'',
'CHAR',
'10',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_dienstart',
'kurztext',
'Kurztext',
'',
'CHAR',
'10',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_dienstart',
'drucktext',
'Drucktext',
'',
'CHAR',
'150',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_dienstart',
'langtext',
'Langtext',
'',
'CHAR',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_extkotr_a',
'key',
'Externer Kostentrger (Schlssel)',
'',
'CHAR',
'30',
1,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_extkotr_a',
'parent',
'bergeordneter Externer Kostentrger (Schlssel)',
'',
'CHAR',
'30',
1,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_extkotr_a',
'kurztext',
'Externer Kostentrger (Kurztext)',
'',
'CHAR',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_extkotr_a',
'name',
'Externer Kostentrger (Name)',
'',
'CHAR',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_extkotr_a',
'kategorie',
'Kostentrger-Kategorie',
'',
'CHAR',
'2',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_extkotr_a',
'gueltig_von',
'gltig von',
'',
'DATE',
'10',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_extkotr_a',
'gueltig_bis',
'gltig bis',
'',
'DATE',
'10',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_extkotr_lehre_k',
'key',
'Externer Kostentrger (Schlssel)',
'',
'CHAR',
'30',
1,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_extkotr_lehre_k',
'parent',
'bergeordneter Externer Kostentrger (Schlssel)',
'',
'CHAR',
'30',
1,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_extkotr_lehre_k',
'kurztext',
'Externer Kostentrger (Kurztext)',
'',
'CHAR',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_extkotr_lehre_k',
'name',
'Externer Kostentrger (Name)',
'',
'CHAR',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_extkotr_lehre_k',
'gueltig_von',
'gltig von',
'',
'DATE',
'10',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_extkotr_lehre_k',
'gueltig_bis',
'gltig bis',
'',
'DATE',
'10',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_extkotr_lfb',
'key',
'Externer Kostentrger (Schlssel)',
'',
'CHAR',
'10',
1,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_extkotr_lfb',
'parent',
'bergeordneter Externer Kostentrger (Schlssel)',
'',
'CHAR',
'10',
1,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_extkotr_lfb',
'name',
'Externer Kostentrger',
'',
'CHAR',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_extkotr_lfb',
'struktur_str',
'Ebene',
'',
'CHAR',
'10',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_extkotr_lfb',
'gueltig_von',
'Gltig von (Jahr)',
'',
'INTEGER',
'10',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_extkotr_lfb',
'gueltig_bis',
'Gltig bis (Jahr)',
'',
'INTEGER',
'10',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_gege',
'id',
'id',
'',
'INTEGER',
'',
1,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_gege',
'apnr',
'apnr',
'',
'CHAR',
'10',
1,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_gege',
'kurz',
'kurz',
'',
'CHAR',
'10',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_gege',
'druck',
'druck',
'',
'CHAR',
'100',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_gege',
'lang_1',
'lang_1',
'',
'CHAR',
'250',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_gege',
'struktur_c',
'struktur_c',
'',
'CHAR',
'50',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_gege',
'gruppe',
'gruppe',
'',
'CHAR',
'10',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_hochschulen_plus',
'hs_nr',
'hs_nr',
'',
'CHAR',
'40',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_hochschulen_plus',
'kuerzel',
'kuerzel',
'',
'CHAR',
'10',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_hs_sichten',
'hs_nr',
'Hochschulnummer (HIS)',
'',
'INTEGER',
'4',
1,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_hs_sichten',
'tid',
'tid',
'',
'INTEGER',
'4',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_hs_sichten',
'dimension',
'Kurzname der Dimension',
'',
'CHAR',
'40',
1,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_hs_sichten',
'dimension_lang',
'Beschreibungstext Dimension',
'',
'CHAR',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_hs_sichten',
'stichtag',
'Stichtag alt (Datum)',
'Das Feld ist obsolet',
'DATE',
'10',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_hs_sichten',
'alt_hier_id',
'alt_hier_id',
'id der alt.Hier in angegebenen Quelltabelle null bei regulrer Hierarchie',
'CHAR',
'150',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_hs_sichten',
'sichtart',
'Art der Sicht',
'',
'CHAR',
'40',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_hs_sichten',
'bezugszeit',
'Bezug des Stichtags',
'Semester/Haushaltsjahr/Quartal/Monat',
'SMALLINT',
'4',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_hs_sichten',
'bezugsart',
'Bezugsart (Semester S,Jahr J, Quartal Q, Monat M)',
'',
'CHAR',
'1',
1,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_hs_sichten',
'exportieren',
'Exportieren?',
'Soll die Statistik im Unload-Job exportiert werden? (1=j,0,nein)',
'CHAR',
'1',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_hs_st_trgart',
'name',
'Hochschulnummer (HIS)',
'',
'VARCHAR',
'255',
1,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_hs_st_trgart',
'apnr',
'apnr',
'',
'CHAR',
'10',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_hs_st_trgart',
'parent',
'Kurzname der Dimension',
'',
'CHAR',
'10',
1,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_hs_st_trgart',
'ebene',
'Beschreibungstext Dimension',
'',
'SMALLINT',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_hs_st_trgart',
'struktur_str',
'Stichtag alt (Datum)',
'Das Feld ist obsolet',
'VARCHAR',
'50',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_hs_stort',
'name',
'Hochschulnummer (HIS)',
'',
'VARCHAR',
'255',
1,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_hs_stort',
'apnr',
'apnr',
'',
'CHAR',
'10',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_hs_stort',
'parent',
'Kurzname der Dimension',
'',
'CHAR',
'10',
1,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_hs_stort',
'ebene',
'Beschreibungstext Dimension',
'',
'SMALLINT',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_hs_stort',
'struktur_str',
'Stichtag alt (Datum)',
'Das Feld ist obsolet',
'VARCHAR',
'50',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_hs_stort_art',
'name',
'Hochschulnummer (HIS)',
'',
'VARCHAR',
'255',
1,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_hs_stort_art',
'apnr',
'apnr',
'',
'CHAR',
'10',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_hs_stort_art',
'parent',
'Kurzname der Dimension',
'',
'CHAR',
'10',
1,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_hs_stort_art',
'ebene',
'Beschreibungstext Dimension',
'',
'SMALLINT',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_hs_stort_art',
'struktur_str',
'Stichtag alt (Datum)',
'Das Feld ist obsolet',
'VARCHAR',
'50',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_hs_stort_trg',
'name',
'Hochschulnummer (HIS)',
'',
'VARCHAR',
'255',
1,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_hs_stort_trg',
'apnr',
'apnr',
'',
'CHAR',
'10',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_hs_stort_trg',
'parent',
'Kurzname der Dimension',
'',
'CHAR',
'10',
1,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_hs_stort_trg',
'ebene',
'Beschreibungstext Dimension',
'',
'SMALLINT',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_hs_stort_trg',
'struktur_str',
'Stichtag alt (Datum)',
'Das Feld ist obsolet',
'VARCHAR',
'50',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_hzbart_astat_akt',
'tid',
'Tupelidentifier',
'',
'SERIAL',
'4',
1,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_hzbart_astat_akt',
'bland',
'Bundesland',
'',
'INTEGER',
'4',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_hzbart_astat_akt',
'apnr',
'Schlssel HZB-Art',
'Schlssel der Hochschulzugangsber.',
'CHAR',
'10',
1,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_hzbart_astat_akt',
'druck',
'Bezeichnung',
'Drucktext',
'VARCHAR',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_hzbart_astat_akt',
'gruppe',
'Gruppe',
'HZB-Art (gruppiert)',
'INTEGER',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_perso_z',
'name',
'name',
'',
'CHAR',
'100',
1,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_perso_z',
'key',
'key',
'',
'CHAR',
'10',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_quartale',
'apnr',
'apnr',
'',
'INTEGER',
'4',
1,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_quartale',
'kurz',
'kurz',
'',
'CHAR',
'10',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_quartale',
'druck',
'druck',
'',
'CHAR',
'150',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_quartale',
'lang_1',
'lang_1',
'',
'CHAR',
'150',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_quartale',
'sort1',
'sort1',
'',
'INTEGER',
'150',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_redaktionsstatus',
'apnr',
'Laufnummer',
'',
'INTEGER',
'10',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_redaktionsstatus',
'name',
'Redaktionsstatus (Name)',
'',
'VARCHAR',
'255',
1,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_report',
'apnr',
'Schlssel',
'',
'CHAR',
'10',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_report',
'druck',
'Bezeichnung',
'',
'VARCHAR',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_report',
'sortnr',
'Sortiernummer',
'',
'SMALLINT',
'50',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_report',
'land_apnr',
'Bundesland (ASTAT)',
'',
'CHAR',
'10',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_report',
'is_download',
'Ist Download',
'',
'CHAR',
'10',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_report',
'bezugsart',
'Zeitbezug (J/S/Q)',
'Jahr, Semester, Quartal',
'CHAR',
'50',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_report',
'gruppe',
'Bericht fr Stichtagsarten',
'',
'CHAR',
'10',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_report_fuer_stichtagsarten',
'apnr',
'Schlssel',
'',
'CHAR',
'10',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_report_fuer_stichtagsarten',
'druck',
'Bezeichnung',
'',
'VARCHAR',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_report_fuer_stichtagsarten',
'sortnr',
'Sortiernummer',
'',
'SMALLINT',
'50',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_report_fuer_stichtagsarten',
'land_apnr',
'Bundesland (ASTAT)',
'',
'CHAR',
'10',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_report_fuer_stichtagsarten',
'is_download',
'Ist Download',
'',
'CHAR',
'10',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_report_fuer_stichtagsarten',
'bezugsart',
'Zeitbezug (J/S/Q)',
'Jahr, Semester, Quartal',
'CHAR',
'50',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_report_katalog',
'apnr',
'Schlssel',
'',
'CHAR',
'100',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_report_katalog',
'druck',
'Bezeichnung',
'',
'VARCHAR',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_report_katalog',
'parent',
'bergeordnete Kostenart',
'',
'CHAR',
'100',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_report_katalog',
'struktur_str',
'Art der Ebene',
'',
'VARCHAR',
'50',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_report_katalog',
'sortnr',
'Sortiernummer',
'',
'SMALLINT',
'50',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_report_katalog',
'ebene',
'Ebene',
'',
'SMALLINT',
'50',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_report_katalog',
'quelltabelle',
'Datenquelle',
'',
'CHAR',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_report_katalog',
'report_id',
'ID des Reports',
'',
'CHAR',
'40',
1,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_report_katalog',
'uniquename',
'Schlssel Reportelement',
'',
'VARCHAR',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stbb_kapitel',
'kapitel',
'Kapitel',
'',
'VARCHAR',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stbb_titel',
'titel',
'Kapitel',
'',
'VARCHAR',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stell_z',
'name',
'name',
'',
'CHAR',
'100',
1,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stell_z',
'key',
'key',
'',
'CHAR',
'10',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stg_astat',
'tid',
'tid',
'Schlssel',
'SERIAL',
'4',
1,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stg_astat',
'astat',
'amtlicher Schlssel',
'des Fachs, Studienbereichs oder der Fchergruppe',
'CHAR',
'10',
1,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stg_astat',
'parent',
'bergeordneter Schlssel',
'dient zum Aufbau der Baumstruktur',
'CHAR',
'10',
0,
1,
0,
0);

update tmp_fields set foreignkey_tab='kenn_sb_astfr_lfb',
foreignkey_col='sb_nr',
foreignkey_cap='sb_text',
foreignkey_uniquename=''
where trim(table_name) || '_' || trim(name) ='kenn_stg_astat_parent';

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stg_astat',
'ktxt',
'Beschreibungstext (kurz)',
'',
'CHAR',
'10',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stg_astat',
'dtxt',
'Beschreibungstext (Druck)',
'',
'CHAR',
'150',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stg_astat',
'ltxt',
'Beschreibungstext (lang)',
'',
'CHAR',
'250',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stg_astat',
'sicht',
'Name der alternativen Hierarchie',
'Referenziert auf sichten.name_intern im  Kernmodul',
'CHAR',
'200',
1,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stg_astat',
'ebene',
'Ebene des Baums',
'',
'SMALLINT',
'2',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stg_astat',
'sort1',
'Sortierschlssel (Ganzzahl)',
'',
'INTEGER',
'4',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stg_astat',
'sortc1',
'Sortierschlssel (Alphabetisch)',
'',
'CHAR',
'10',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stg_astat',
'gueltig_von',
'Beginn der Gltigkeit',
'',
'DATE',
'4',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stg_astat',
'gueltig_bis',
'Ende der Gltigkeit',
'',
'DATE',
'4',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stg_astat',
'struktur_c',
'Art der Ebene',
'',
'CHAR',
'50',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stg_sb',
'name',
'Hochschulnummer (HIS)',
'',
'VARCHAR',
'255',
1,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stg_sb',
'apnr',
'apnr',
'',
'CHAR',
'10',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stg_sb',
'parent',
'Kurzname der Dimension',
'',
'CHAR',
'10',
1,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stg_sb',
'ebene',
'Beschreibungstext Dimension',
'',
'SMALLINT',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_stg_sb',
'struktur_str',
'Stichtag alt (Datum)',
'Das Feld ist obsolet',
'VARCHAR',
'50',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_taetigkeit',
'tid',
'tid',
'Schlssel',
'INTEGER',
'4',
1,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_taetigkeit',
'bund_taetigkeit',
'Schlssel der Ttigkeit',
'',
'CHAR',
'10',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_taetigkeit',
'kurztext',
'Kurztext',
'',
'CHAR',
'10',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_taetigkeit',
'drucktext',
'Drucktext',
'',
'CHAR',
'150',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_taetigkeit',
'langtext',
'Langtext',
'',
'CHAR',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_zahlen',
'apnr',
'apnr',
'',
'INTEGER',
'4',
1,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_zahlen',
'kurz',
'kurz',
'',
'CHAR',
'10',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_zahlen',
'druck',
'druck',
'',
'CHAR',
'150',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_zahlen',
'lang_1',
'lang_1',
'',
'CHAR',
'150',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_zahlen',
'gruppierung',
'gruppierung',
'',
'CHAR',
'255',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_zahlen',
'sort1',
'sort1',
'',
'INTEGER',
'150',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_zahlen',
'ebene',
'ebene',
'',
'INTEGER',
'150',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_zahlen',
'struktur_c',
'struktur_c',
'',
'CHAR',
'50',
0,
1,
0,
0);

insert into tmp_fields (
table_name,
name,
caption,
description,
field_type,
field_size,
field_not_null,
currentlyUsed,
check_integrity,
is_sum) 
values('kenn_zahlen',
'gruppe',
'gruppe',
'',
'CHAR',
'10',
0,
1,
0,
0);


delete from sx_fields where trim(table_name) in (select trim(T.table_name) from tmp_fields T);

create temp table tmp_hilf(tid integer);
insert into tmp_hilf select max(tid) from sx_fields;
update tmp_hilf set tid=0 where tid is null;

insert into sx_fields (tid,table_name,name,caption,description,field_type,
field_size,
field_not_null,
currentlyUsed,
foreignkey_tab,
foreignkey_col,
foreignkey_cap,
foreignkey_int,
foreignkey_cond,
foreignkey_func,
check_integrity,
is_sum

<#if TableFieldExists?exists && TableFieldExists('sx_fields','foreignkey_uniquename')>
,foreignkey_uniquename
</#if>


)
select F.tid + H.tid,
F.table_name,F.name,F.caption,F.description,F.field_type,
F.field_size,
F.field_not_null,
F.currentlyUsed,
F.foreignkey_tab,
F.foreignkey_col,
F.foreignkey_cap,
F.foreignkey_int,
F.foreignkey_cond,
F.foreignkey_func,
F.check_integrity,
F.is_sum

<#if TableFieldExists?exists && TableFieldExists('sx_fields','foreignkey_uniquename')>
,F.foreignkey_uniquename
</#if>

from tmp_fields F, tmp_hilf H;

<#if SQLdialect='Postgres'>
select sp_update_sequence('sx_fields');
</#if>

drop table tmp_hilf;
drop table tmp_fields;


</#if>

